/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.executor.join.RedundantSelfJoinExecutor;
import it.unibz.inf.ontop.iq.executor.join.SelfJoinLikeExecutor;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Comparator;
import java.util.Optional;

@Singleton
public class UCRedundantSelfJoinExecutor
extends RedundantSelfJoinExecutor {
    @Inject
    private UCRedundantSelfJoinExecutor(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, TermFactory termFactory) {
        super(iqFactory, substitutionFactory, unificationTools, termFactory);
    }

    @Override
    protected Optional<SelfJoinLikeExecutor.PredicateLevelProposal> proposePerPredicate(InnerJoinNode joinNode, ImmutableCollection<ExtensionalDataNode> initialNodes, RelationPredicate predicate, ImmutableList<Variable> priorityVariables, IntermediateQuery query) throws SelfJoinLikeExecutor.AtomUnificationException {
        ImmutableList uniqueConstraints = predicate.getRelationDefinition().getUniqueConstraints();
        if (uniqueConstraints.isEmpty()) {
            return Optional.empty();
        }
        ImmutableMultimap<ImmutableList<VariableOrGroundTerm>, ExtensionalDataNode> groupingMap = UCRedundantSelfJoinExecutor.groupByUniqueConstraintArguments(initialNodes, (ImmutableCollection<ImmutableList<Integer>>)((ImmutableCollection)uniqueConstraints.stream().map(UniqueConstraint::getAttributes).map(this::getSortedIndexes).collect(ImmutableCollectors.toList())));
        return Optional.of(this.proposeForGroupingMap(groupingMap));
    }

    private ImmutableList<Integer> getSortedIndexes(ImmutableList<Attribute> list) {
        return (ImmutableList)list.stream().map(Attribute::getIndex).sorted(Comparator.naturalOrder()).collect(ImmutableCollectors.toList());
    }

    private static ImmutableMultimap<ImmutableList<VariableOrGroundTerm>, ExtensionalDataNode> groupByUniqueConstraintArguments(ImmutableCollection<ExtensionalDataNode> dataNodes, ImmutableCollection<ImmutableList<Integer>> collectionOfUCPositions) {
        ImmutableMultimap.Builder groupingMapBuilder = ImmutableMultimap.builder();
        for (ImmutableList primaryKeyPositions : collectionOfUCPositions) {
            for (ExtensionalDataNode dataNode : dataNodes) {
                groupingMapBuilder.put(UCRedundantSelfJoinExecutor.extractArguments(dataNode.getProjectionAtom(), (ImmutableList<Integer>)primaryKeyPositions), (Object)dataNode);
            }
        }
        return groupingMapBuilder.build();
    }
}

