/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.DataNode;
import it.unibz.inf.ontop.iq.node.ExplicitVariableProjectionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.JoinLikeNode;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.impl.NodeCentricOptimizationResultsImpl;
import it.unibz.inf.ontop.iq.proposal.impl.SubstitutionPropagationProposalImpl;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfJoinLikeExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelfJoinLikeExecutor.class);
    private final SubstitutionFactory substitutionFactory;
    private final ImmutableUnificationTools unificationTools;
    private final TermFactory termFactory;

    protected SelfJoinLikeExecutor(SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, TermFactory termFactory) {
        this.substitutionFactory = substitutionFactory;
        this.unificationTools = unificationTools;
        this.termFactory = termFactory;
    }

    protected static ImmutableMultimap<RelationPredicate, ExtensionalDataNode> extractDataNodes(ImmutableList<QueryNode> siblings) {
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        for (QueryNode node : siblings) {
            if (!(node instanceof ExtensionalDataNode)) continue;
            ExtensionalDataNode dataNode = (ExtensionalDataNode)node;
            mapBuilder.put((Object)dataNode.getProjectionAtom().getPredicate(), (Object)dataNode);
        }
        return mapBuilder.build();
    }

    protected PredicateLevelProposal proposeForGroupingMap(ImmutableMultimap<ImmutableList<VariableOrGroundTerm>, ExtensionalDataNode> groupingMap) throws AtomUnificationException {
        ImmutableCollection dataNodeGroups = groupingMap.asMap().values();
        try {
            ImmutableSet unifyingSubstitutions = (ImmutableSet)dataNodeGroups.stream().filter(g -> g.size() > 1).map(redundantNodes -> {
                try {
                    return this.unifyRedundantNodes((Collection<ExtensionalDataNode>)redundantNodes);
                }
                catch (AtomUnificationException e) {
                    throw new AtomUnificationRuntimeException(e);
                }
            }).filter(s -> !s.isEmpty()).collect(ImmutableCollectors.toSet());
            ImmutableSet removableNodes = ImmutableSet.copyOf((Collection)dataNodeGroups.stream().filter(sameRowDataNodes -> sameRowDataNodes.size() > 1).reduce(new Dominance(), Dominance::update, (dom1, dom2) -> {
                throw new IllegalStateException("Cannot be run in parallel");
            }).getRemovalNodes());
            Optional isNotNullConjunction = this.termFactory.getConjunction(groupingMap.keys().stream().flatMap(Collection::stream).map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)));
            return new PredicateLevelProposal((ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>>)unifyingSubstitutions, (ImmutableCollection<ExtensionalDataNode>)removableNodes, isNotNullConjunction);
        }
        catch (AtomUnificationRuntimeException e) {
            throw e.checkedException;
        }
    }

    protected ImmutableSubstitution<VariableOrGroundTerm> unifyRedundantNodes(Collection<ExtensionalDataNode> redundantNodes) throws AtomUnificationException {
        ImmutableSubstitution<VariableOrGroundTerm> accumulatedSubstitution = this.substitutionFactory.getSubstitution();
        if (redundantNodes.size() < 2) {
            return accumulatedSubstitution;
        }
        ImmutableMap occurrenceVariableMap = ((ImmutableMultimap)redundantNodes.stream().flatMap(n -> n.getVariables().stream().map(v -> Maps.immutableEntry((Object)v, (Object)n))).collect(ImmutableCollectors.toMultimap())).asMap();
        ImmutableSet sharedVariables = (ImmutableSet)occurrenceVariableMap.entrySet().stream().filter(e -> ImmutableSet.copyOf((Collection)((Collection)e.getValue())).size() > 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
        ImmutableSet nonSharedVariables = Sets.difference((Set)occurrenceVariableMap.keySet(), (Set)sharedVariables).immutableCopy();
        Iterator<ExtensionalDataNode> nodeIterator = redundantNodes.iterator();
        ImmutableList.Builder nonSharedSubstitutionListBuilder = ImmutableList.builder();
        DataAtom accumulatedAtom = nodeIterator.next().getProjectionAtom();
        while (nodeIterator.hasNext()) {
            DataAtom newAtom = nodeIterator.next().getProjectionAtom();
            ImmutableSubstitution nonSharedSubstitution = accumulatedSubstitution.reduceDomainToIntersectionWith(nonSharedVariables);
            if (!nonSharedSubstitution.isEmpty()) {
                nonSharedSubstitutionListBuilder.add((Object)nonSharedSubstitution);
            }
            ImmutableSubstitution<VariableOrGroundTerm> substitutionToUnify = nonSharedSubstitution.isEmpty() ? accumulatedSubstitution : accumulatedSubstitution.reduceDomainToIntersectionWith(sharedVariables);
            accumulatedSubstitution = this.updateSubstitution(substitutionToUnify, accumulatedAtom, newAtom);
            accumulatedAtom = accumulatedSubstitution.applyToDataAtom(accumulatedAtom);
        }
        return Stream.concat(nonSharedSubstitutionListBuilder.build().stream(), Stream.of(accumulatedSubstitution)).reduce((v1, v2) -> v2.composeWith2(v1)).orElseThrow(() -> new MinorOntopInternalBugException("At least one substitution was expected"));
    }

    protected Optional<ImmutableSubstitution<VariableOrGroundTerm>> mergeSubstitutions(ImmutableList<ImmutableSubstitution<VariableOrGroundTerm>> substitutions, ImmutableMultimap<RelationPredicate, ExtensionalDataNode> initialDataNodeMap, ImmutableList<Variable> priorityVariables) throws AtomUnificationException {
        ImmutableMap occurrenceVariableMap = ((ImmutableMultimap)initialDataNodeMap.asMap().entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().flatMap(n -> n.getVariables().stream()).map(v -> Maps.immutableEntry((Object)v, e.getKey()))).collect(ImmutableCollectors.toMultimap())).asMap();
        ImmutableSet sharedVariables = (ImmutableSet)occurrenceVariableMap.entrySet().stream().filter(e -> ImmutableSet.copyOf((Collection)((Collection)e.getValue())).size() > 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
        ImmutableSet nonSharedVariables = Sets.difference((Set)occurrenceVariableMap.keySet(), (Set)sharedVariables).immutableCopy();
        ImmutableList.Builder nonSharedSubstitutionListBuilder = ImmutableList.builder();
        Optional optionalAccumulatedSubstitution = Optional.empty();
        for (ImmutableSubstitution substitution : substitutions) {
            if (substitution.isEmpty()) continue;
            if (optionalAccumulatedSubstitution.isPresent()) {
                ImmutableSubstitution substitutionToUnify;
                Optional optionalMGUS;
                ImmutableSubstitution accumulatedSubstitution = (ImmutableSubstitution)optionalAccumulatedSubstitution.get();
                ImmutableSubstitution nonSharedSubstitution = accumulatedSubstitution.reduceDomainToIntersectionWith(nonSharedVariables);
                if (!nonSharedSubstitution.isEmpty()) {
                    nonSharedSubstitutionListBuilder.add((Object)nonSharedSubstitution);
                }
                if ((optionalMGUS = this.unificationTools.computeAtomMGUS(substitutionToUnify = nonSharedSubstitution.isEmpty() ? accumulatedSubstitution : accumulatedSubstitution.reduceDomainToIntersectionWith(sharedVariables), substitution)).isPresent()) {
                    optionalAccumulatedSubstitution = optionalMGUS;
                    continue;
                }
                throw new AtomUnificationException();
            }
            optionalAccumulatedSubstitution = Optional.of(substitution);
        }
        return optionalAccumulatedSubstitution.map(s -> Stream.concat(nonSharedSubstitutionListBuilder.build().stream(), Stream.of(s)).reduce((v1, v2) -> v2.composeWith2(v1)).orElseThrow(() -> new MinorOntopInternalBugException("At least one substitution was expected"))).map(s -> s.orientate(priorityVariables));
    }

    protected ImmutableList<ImmutableSubstitution<VariableOrGroundTerm>> extractSubstitutions(ImmutableCollection<PredicateLevelProposal> predicateProposals) {
        ImmutableList.Builder substitutionListBuilder = ImmutableList.builder();
        for (PredicateLevelProposal proposal : predicateProposals) {
            substitutionListBuilder.addAll(proposal.getSubstitutions());
        }
        return substitutionListBuilder.build();
    }

    private ImmutableSubstitution<VariableOrGroundTerm> updateSubstitution(ImmutableSubstitution<VariableOrGroundTerm> accumulatedSubstitution, DataAtom accumulatedAtom, DataAtom newAtom) throws AtomUnificationException {
        Optional optionalSubstitution = this.unificationTools.computeAtomMGU(accumulatedAtom, newAtom);
        if (optionalSubstitution.isPresent()) {
            if (accumulatedSubstitution.isEmpty()) {
                return (ImmutableSubstitution)optionalSubstitution.get();
            }
            Optional optionalAccumulatedSubstitution = this.unificationTools.computeAtomMGUS(accumulatedSubstitution, (ImmutableSubstitution)optionalSubstitution.get());
            if (optionalAccumulatedSubstitution.isPresent()) {
                return (ImmutableSubstitution)optionalAccumulatedSubstitution.get();
            }
            throw new AtomUnificationException();
        }
        throw new AtomUnificationException();
    }

    protected static ImmutableList<VariableOrGroundTerm> extractArguments(DataAtom atom, ImmutableList<Integer> positions) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        int atomLength = atom.getArguments().size();
        for (Integer keyIndex : positions) {
            if (keyIndex > atomLength) {
                throw new RuntimeException("The key index does not respect the arity of the atom " + atom);
            }
            listBuilder.add((Object)atom.getTerm(keyIndex - 1));
        }
        return listBuilder.build();
    }

    protected <N extends JoinOrFilterNode> NodeCentricOptimizationResults<N> updateJoinNodeAndPropagateSubstitution(IntermediateQuery query, QueryTreeComponent treeComponent, N joinNode, ConcreteProposal proposal) throws EmptyQueryException {
        Optional optionalFilter = joinNode.getOptionalFilterCondition().map(f -> proposal.getOptionalIsNotNullExpression().map(f2 -> this.termFactory.getConjunction(f, new ImmutableExpression[]{f2})).orElse((ImmutableExpression)f)).map(Optional::of).orElseGet(proposal::getOptionalIsNotNullExpression);
        switch (treeComponent.getChildren(joinNode).size()) {
            case 0: {
                throw new IllegalStateException("Self-join elimination MUST not eliminate ALL the nodes");
            }
            case 1: {
                QueryNode uniqueChild = (QueryNode)treeComponent.getFirstChild(joinNode).get();
                if (optionalFilter.isPresent()) {
                    FilterNode filterNode = query.getFactory().createFilterNode((ImmutableExpression)optionalFilter.get());
                    treeComponent.replaceNode(joinNode, (QueryNode)filterNode);
                } else {
                    treeComponent.removeOrReplaceNodeByUniqueChild(joinNode);
                }
                NodeCentricOptimizationResults<QueryNode> propagationResults = SelfJoinLikeExecutor.propagateSubstitution(query, proposal.getOptionalSubstitution(), uniqueChild);
                return propagationResults.getNewNodeOrReplacingChild().map(child -> new NodeCentricOptimizationResultsImpl(query, Optional.of(child))).orElseGet(() -> new NodeCentricOptimizationResultsImpl(query, propagationResults.getOptionalNextSibling(), propagationResults.getOptionalClosestAncestor()));
            }
        }
        JoinOrFilterNode newJoinNode = optionalFilter.map(cond -> {
            FilterNode parentFilter = query.getFactory().createFilterNode(cond);
            treeComponent.insertParent((QueryNode)joinNode, (QueryNode)parentFilter);
            JoinLikeNode conditionLessJoinNode = ((JoinLikeNode)joinNode).changeOptionalFilterCondition(Optional.empty());
            treeComponent.replaceNode((QueryNode)joinNode, (QueryNode)conditionLessJoinNode);
            return conditionLessJoinNode;
        }).orElse(joinNode);
        return SelfJoinLikeExecutor.propagateSubstitution(query, proposal.getOptionalSubstitution(), newJoinNode);
    }

    private static <T extends QueryNode> NodeCentricOptimizationResults<T> propagateSubstitution(IntermediateQuery query, Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalSubstitution, T topNode) throws EmptyQueryException {
        if (optionalSubstitution.isPresent()) {
            SubstitutionPropagationProposalImpl<T> propagationProposal = new SubstitutionPropagationProposalImpl<T>(topNode, optionalSubstitution.get(), false);
            return (NodeCentricOptimizationResults)query.applyProposal(propagationProposal, true);
        }
        return new NodeCentricOptimizationResultsImpl<T>(query, topNode);
    }

    protected ImmutableList<Variable> prioritizeVariables(IntermediateQuery query, JoinLikeNode joinLikeNode) {
        return (ImmutableList)((Stream)this.extractAncestors(query, (QueryNode)joinLikeNode).stream().sequential()).flatMap(p -> this.extractPriorityVariables(query, p.parent, p.position)).distinct().collect(ImmutableCollectors.toList());
    }

    private ImmutableList<ParentAndChildPosition> extractAncestors(IntermediateQuery query, QueryNode node) {
        Optional optionalAncestor = query.getParent(node);
        QueryNode ancestorChild = node;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        while (optionalAncestor.isPresent()) {
            QueryNode ancestor = (QueryNode)optionalAncestor.get();
            listBuilder.add((Object)new ParentAndChildPosition(ancestor, query.getOptionalPosition(ancestor, ancestorChild)));
            optionalAncestor = query.getParent(ancestor);
            ancestorChild = ancestor;
        }
        return listBuilder.build();
    }

    private Stream<Variable> extractPriorityVariables(IntermediateQuery query, QueryNode node, Optional<BinaryOrderedOperatorNode.ArgumentPosition> childPosition) {
        if (node instanceof ExplicitVariableProjectionNode) {
            return ((ExplicitVariableProjectionNode)node).getVariables().stream();
        }
        if (node instanceof LeftJoinNode) {
            switch (childPosition.get()) {
                case RIGHT: {
                    return query.getChild(node, BinaryOrderedOperatorNode.ArgumentPosition.LEFT).map(c -> query.getVariables(c).stream()).orElseThrow(() -> new IllegalStateException("A LJ must have a left child"));
                }
            }
            return Stream.empty();
        }
        return Stream.empty();
    }

    private static class ParentAndChildPosition {
        public final QueryNode parent;
        public final Optional<BinaryOrderedOperatorNode.ArgumentPosition> position;

        private ParentAndChildPosition(QueryNode parent, Optional<BinaryOrderedOperatorNode.ArgumentPosition> position) {
            this.parent = parent;
            this.position = position;
        }
    }

    private static class Dominance {
        private final List<ExtensionalDataNode> locallyDominants;
        private final Set<ExtensionalDataNode> removalNodes;

        public Dominance() {
            this(Lists.newArrayList(), Sets.newHashSet());
        }

        private Dominance(List<ExtensionalDataNode> locallyDominants, Set<ExtensionalDataNode> removalNodes) {
            this.locallyDominants = locallyDominants;
            this.removalNodes = removalNodes;
        }

        public Dominance update(Collection<ExtensionalDataNode> sameRowDataNodes) {
            ExtensionalDataNode locallyDominantNode = sameRowDataNodes.stream().filter(this.locallyDominants::contains).findFirst().orElseGet(() -> (ExtensionalDataNode)sameRowDataNodes.stream().findFirst().orElseThrow(() -> new IllegalStateException("Should be at least one node")));
            this.locallyDominants.add(locallyDominantNode);
            sameRowDataNodes.stream().filter(n -> n != locallyDominantNode).forEach(this.removalNodes::add);
            return this;
        }

        private final ImmutableSet<ExtensionalDataNode> getRemovalNodes() {
            return ImmutableSet.copyOf(this.removalNodes);
        }
    }

    protected static class ConcreteProposal {
        private final Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalSubstitution;
        private final ImmutableCollection<DataNode> removedDataNodes;
        private final Optional<ImmutableExpression> optionalIsNotNullExpression;

        public ConcreteProposal(Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalSubstitution, ImmutableCollection<DataNode> removedDataNodes, Optional<ImmutableExpression> optionalIsNotNullExpression) {
            this.optionalSubstitution = optionalSubstitution;
            this.removedDataNodes = removedDataNodes;
            this.optionalIsNotNullExpression = optionalIsNotNullExpression;
        }

        public ImmutableCollection<DataNode> getDataNodesToRemove() {
            return this.removedDataNodes;
        }

        public Optional<ImmutableSubstitution<VariableOrGroundTerm>> getOptionalSubstitution() {
            return this.optionalSubstitution;
        }

        public boolean shouldOptimize() {
            return !this.removedDataNodes.isEmpty();
        }

        public Optional<ImmutableExpression> getOptionalIsNotNullExpression() {
            return this.optionalIsNotNullExpression;
        }
    }

    protected static class PredicateLevelProposal {
        private final ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>> substitutions;
        private final ImmutableCollection<ExtensionalDataNode> removedDataNodes;
        private final Optional<ImmutableExpression> isNotNullConjunction;

        public PredicateLevelProposal(ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>> substitutions, ImmutableCollection<ExtensionalDataNode> removedDataNodes, Optional<ImmutableExpression> isNotNullConjunction) {
            this.substitutions = substitutions;
            this.removedDataNodes = removedDataNodes;
            this.isNotNullConjunction = isNotNullConjunction;
        }

        public ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>> getSubstitutions() {
            return this.substitutions;
        }

        public ImmutableCollection<ExtensionalDataNode> getRemovedDataNodes() {
            return this.removedDataNodes;
        }

        public Optional<ImmutableExpression> getIsNotNullConjunction() {
            return this.isNotNullConjunction;
        }
    }

    private static final class AtomUnificationRuntimeException
    extends RuntimeException {
        public final AtomUnificationException checkedException;

        public AtomUnificationRuntimeException(AtomUnificationException e) {
            this.checkedException = e;
        }
    }

    protected static final class AtomUnificationException
    extends Exception {
        protected AtomUnificationException() {
        }
    }
}

