/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.exception.InvalidQueryOptimizationProposalException;
import it.unibz.inf.ontop.iq.executor.join.InnerJoinExecutor;
import it.unibz.inf.ontop.iq.executor.join.SelfJoinLikeExecutor;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.DataNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.JoinLikeNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.proposal.InnerJoinOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.impl.NodeCentricOptimizationResultsImpl;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

public abstract class RedundantSelfJoinExecutor
extends SelfJoinLikeExecutor
implements InnerJoinExecutor {
    private static final int MAX_ITERATIONS = 100;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    protected RedundantSelfJoinExecutor(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, TermFactory termFactory) {
        super(substitutionFactory, unificationTools, termFactory);
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
    }

    public NodeCentricOptimizationResults<InnerJoinNode> apply(InnerJoinOptimizationProposal highLevelProposal, IntermediateQuery query, QueryTreeComponent treeComponent) throws InvalidQueryOptimizationProposalException, EmptyQueryException {
        InnerJoinNode topJoinNode = (InnerJoinNode)highLevelProposal.getFocusNode();
        ImmutableMultimap<RelationPredicate, ExtensionalDataNode> initialMap = RedundantSelfJoinExecutor.extractDataNodes((ImmutableList<QueryNode>)query.getChildren((QueryNode)topJoinNode));
        int i = 0;
        while (!initialMap.isEmpty() && i++ < 100) {
            ImmutableList<Variable> priorityVariables = this.prioritizeVariables(query, (JoinLikeNode)topJoinNode);
            try {
                Optional<SelfJoinLikeExecutor.ConcreteProposal> optionalConcreteProposal = this.propose(topJoinNode, initialMap, priorityVariables, query);
                if (optionalConcreteProposal.isPresent()) {
                    SelfJoinLikeExecutor.ConcreteProposal concreteProposal = optionalConcreteProposal.get();
                    NodeCentricOptimizationResults<InnerJoinNode> result = this.applyOptimization(query, treeComponent, topJoinNode, concreteProposal);
                    if (result.getOptionalNewNode().isPresent()) {
                        int newSize;
                        int oldSize = initialMap.size();
                        if (oldSize == (newSize = (initialMap = RedundantSelfJoinExecutor.extractDataNodes((ImmutableList<QueryNode>)query.getChildren((QueryNode)result.getOptionalNewNode().get()))).size())) {
                            return result;
                        }
                        if (oldSize < newSize) {
                            throw new IllegalStateException("The number of data atoms was expected to decrease, not increase");
                        }
                        topJoinNode = result.getOptionalNewNode().get();
                        continue;
                    }
                    return result;
                }
                break;
            }
            catch (SelfJoinLikeExecutor.AtomUnificationException e) {
                return this.declareSubTreeAsEmpty(query, treeComponent, topJoinNode);
            }
        }
        if (i >= 100) {
            throw new IllegalStateException("Redundant self-join elimination loop has reached the max iteration threshold (100)");
        }
        return new NodeCentricOptimizationResultsImpl<InnerJoinNode>(query, topJoinNode);
    }

    private Optional<SelfJoinLikeExecutor.ConcreteProposal> propose(InnerJoinNode joinNode, ImmutableMultimap<RelationPredicate, ExtensionalDataNode> initialDataNodeMap, ImmutableList<Variable> priorityVariables, IntermediateQuery query) throws SelfJoinLikeExecutor.AtomUnificationException {
        ImmutableList.Builder proposalListBuilder = ImmutableList.builder();
        for (RelationPredicate predicate : initialDataNodeMap.keySet()) {
            ImmutableCollection initialNodes = initialDataNodeMap.get((Object)predicate);
            Optional<SelfJoinLikeExecutor.PredicateLevelProposal> predicateProposal = this.proposePerPredicate(joinNode, (ImmutableCollection<ExtensionalDataNode>)initialNodes, predicate, priorityVariables, query);
            predicateProposal.ifPresent(arg_0 -> ((ImmutableList.Builder)proposalListBuilder).add(arg_0));
        }
        return this.createConcreteProposal((ImmutableList<SelfJoinLikeExecutor.PredicateLevelProposal>)proposalListBuilder.build(), initialDataNodeMap, priorityVariables);
    }

    protected Optional<SelfJoinLikeExecutor.ConcreteProposal> createConcreteProposal(ImmutableList<SelfJoinLikeExecutor.PredicateLevelProposal> predicateProposals, ImmutableMultimap<RelationPredicate, ExtensionalDataNode> initialDataNodeMap, ImmutableList<Variable> priorityVariables) {
        Optional<ImmutableSubstitution<VariableOrGroundTerm>> optionalMergedSubstitution;
        try {
            optionalMergedSubstitution = this.mergeSubstitutions(this.extractSubstitutions((ImmutableCollection<SelfJoinLikeExecutor.PredicateLevelProposal>)predicateProposals), initialDataNodeMap, priorityVariables);
        }
        catch (SelfJoinLikeExecutor.AtomUnificationException e) {
            return Optional.empty();
        }
        ImmutableSet removedDataNodes = (ImmutableSet)predicateProposals.stream().flatMap(p -> p.getRemovedDataNodes().stream()).collect(ImmutableCollectors.toSet());
        if (removedDataNodes.isEmpty() && !optionalMergedSubstitution.isPresent()) {
            return Optional.empty();
        }
        Optional isNotConjunction = this.termFactory.getConjunction(predicateProposals.stream().map(SelfJoinLikeExecutor.PredicateLevelProposal::getIsNotNullConjunction).filter(Optional::isPresent).map(Optional::get).flatMap(ImmutableExpression::flattenAND).distinct());
        return Optional.of(new SelfJoinLikeExecutor.ConcreteProposal(optionalMergedSubstitution, (ImmutableCollection<DataNode>)removedDataNodes, isNotConjunction));
    }

    protected abstract Optional<SelfJoinLikeExecutor.PredicateLevelProposal> proposePerPredicate(InnerJoinNode var1, ImmutableCollection<ExtensionalDataNode> var2, RelationPredicate var3, ImmutableList<Variable> var4, IntermediateQuery var5) throws SelfJoinLikeExecutor.AtomUnificationException;

    private NodeCentricOptimizationResults<InnerJoinNode> applyOptimization(IntermediateQuery query, QueryTreeComponent treeComponent, InnerJoinNode topJoinNode, SelfJoinLikeExecutor.ConcreteProposal proposal) throws EmptyQueryException {
        proposal.getDataNodesToRemove().forEach(arg_0 -> ((QueryTreeComponent)treeComponent).removeSubTree(arg_0));
        return this.updateJoinNodeAndPropagateSubstitution(query, treeComponent, topJoinNode, proposal);
    }

    private NodeCentricOptimizationResults<InnerJoinNode> declareSubTreeAsEmpty(IntermediateQuery query, QueryTreeComponent treeComponent, InnerJoinNode topJoinNode) {
        EmptyNode emptyNode = this.iqFactory.createEmptyNode(query.getVariables((QueryNode)topJoinNode));
        treeComponent.replaceSubTree((QueryNode)topJoinNode, (QueryNode)emptyNode);
        return new NodeCentricOptimizationResultsImpl<InnerJoinNode>(query, Optional.of(emptyNode));
    }
}

