/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidQueryOptimizationProposalException;
import it.unibz.inf.ontop.iq.executor.join.InnerJoinExecutor;
import it.unibz.inf.ontop.iq.executor.join.JoinExtractionUtils;
import it.unibz.inf.ontop.iq.impl.QueryTreeComponent;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.proposal.InnerJoinOptimizationProposal;
import it.unibz.inf.ontop.iq.proposal.NodeCentricOptimizationResults;
import it.unibz.inf.ontop.iq.proposal.impl.NodeCentricOptimizationResultsImpl;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import java.util.Optional;

@Singleton
public class JoinBooleanExpressionExecutor
implements InnerJoinExecutor {
    private final IntermediateQueryFactory iqFactory;
    private final JoinExtractionUtils joinExtractionUtils;

    @Inject
    private JoinBooleanExpressionExecutor(IntermediateQueryFactory iqFactory, JoinExtractionUtils joinExtractionUtils) {
        this.iqFactory = iqFactory;
        this.joinExtractionUtils = joinExtractionUtils;
    }

    public NodeCentricOptimizationResults<InnerJoinNode> apply(InnerJoinOptimizationProposal proposal, IntermediateQuery query, QueryTreeComponent treeComponent) throws InvalidQueryOptimizationProposalException {
        Optional<ImmutableExpression> optionalAggregatedFilterCondition;
        InnerJoinNode originalTopJoinNode = (InnerJoinNode)proposal.getFocusNode();
        ImmutableList<JoinOrFilterNode> filterOrJoinNodes = JoinExtractionUtils.extractFilterAndInnerJoinNodes(originalTopJoinNode, query);
        Optional optionalParentNode = query.getParent((QueryNode)originalTopJoinNode);
        try {
            optionalAggregatedFilterCondition = this.joinExtractionUtils.extractFoldAndOptimizeBooleanExpressions(filterOrJoinNodes);
        }
        catch (JoinExtractionUtils.UnsatisfiableExpressionException e) {
            EmptyNode replacingEmptyNode = this.iqFactory.createEmptyNode(query.getVariables((QueryNode)originalTopJoinNode));
            treeComponent.replaceSubTree((QueryNode)originalTopJoinNode, (QueryNode)replacingEmptyNode);
            return new NodeCentricOptimizationResultsImpl<InnerJoinNode>(query, Optional.of(replacingEmptyNode));
        }
        if (filterOrJoinNodes.size() > 1 || !optionalAggregatedFilterCondition.equals(originalTopJoinNode.getOptionalFilterCondition())) {
            QueryNode parentNode;
            InnerJoinNode newJoinNode = this.iqFactory.createInnerJoinNode(optionalAggregatedFilterCondition);
            if (optionalParentNode.isPresent()) {
                parentNode = (QueryNode)optionalParentNode.get();
            } else {
                parentNode = this.iqFactory.createConstructionNode(query.getProjectionAtom().getVariables());
                treeComponent.insertParent((QueryNode)originalTopJoinNode, parentNode);
            }
            Optional optionalPosition = treeComponent.getOptionalPosition(parentNode, (QueryNode)originalTopJoinNode);
            treeComponent.replaceNodesByOneNode(ImmutableList.copyOf(filterOrJoinNodes), (QueryNode)newJoinNode, parentNode, optionalPosition);
            return new NodeCentricOptimizationResultsImpl<InnerJoinNode>(query, newJoinNode);
        }
        return new NodeCentricOptimizationResultsImpl<InnerJoinNode>(query, originalTopJoinNode);
    }
}

