/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.executor.join;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.executor.join.RedundantSelfJoinExecutor;
import it.unibz.inf.ontop.iq.executor.join.SelfJoinLikeExecutor;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.atom.RelationPredicate;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.impl.ImmutabilityTools;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.ProtoSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

@Singleton
public class FunctionalDependencyUnificationExecutor
extends RedundantSelfJoinExecutor {
    private final SubstitutionFactory substitutionFactory;
    private final ImmutableUnificationTools unificationTools;

    @Inject
    private FunctionalDependencyUnificationExecutor(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, ImmutableUnificationTools unificationTools, TermFactory termFactory) {
        super(iqFactory, substitutionFactory, unificationTools, termFactory);
        this.substitutionFactory = substitutionFactory;
        this.unificationTools = unificationTools;
    }

    @Override
    protected Optional<SelfJoinLikeExecutor.PredicateLevelProposal> proposePerPredicate(InnerJoinNode joinNode, ImmutableCollection<ExtensionalDataNode> initialNodes, RelationPredicate predicate, ImmutableList<Variable> priorityVariables, IntermediateQuery query) throws SelfJoinLikeExecutor.AtomUnificationException {
        if (initialNodes.size() < 2) {
            return Optional.empty();
        }
        RelationDefinition relation = predicate.getRelationDefinition();
        if (relation == null) {
            return Optional.empty();
        }
        ImmutableMap constraintNodeMap = (ImmutableMap)relation.getOtherFunctionalDependencies().stream().collect(ImmutableCollectors.toMap(c -> c, c -> this.groupDataNodesPerConstraint((FunctionalDependency)c, initialNodes)));
        ImmutableList<ImmutableSubstitution<VariableOrGroundTerm>> dependentUnifiers = this.extractDependentUnifiers(relation, (ImmutableMap<FunctionalDependency, ImmutableCollection<Collection<ExtensionalDataNode>>>)constraintNodeMap);
        Optional<ImmutableExpression> isNotNullConjunction = Optional.empty();
        return dependentUnifiers.isEmpty() ? Optional.empty() : Optional.of(new SelfJoinLikeExecutor.PredicateLevelProposal((ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>>)dependentUnifiers, (ImmutableCollection<ExtensionalDataNode>)ImmutableSet.of(), isNotNullConjunction));
    }

    private ImmutableList<ImmutableSubstitution<VariableOrGroundTerm>> extractDependentUnifiers(RelationDefinition databaseRelation, ImmutableMap<FunctionalDependency, ImmutableCollection<Collection<ExtensionalDataNode>>> constraintNodeMap) throws SelfJoinLikeExecutor.AtomUnificationException {
        ImmutableSet nullableIndexes = (ImmutableSet)databaseRelation.getAttributes().stream().filter(Attribute::canNull).map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
        ImmutableList.Builder dependentUnifierBuilder = ImmutableList.builder();
        for (Map.Entry constraintEntry : constraintNodeMap.entrySet()) {
            dependentUnifierBuilder.addAll(this.extractDependentUnifiers((FunctionalDependency)constraintEntry.getKey(), (ImmutableCollection<Collection<ExtensionalDataNode>>)((ImmutableCollection)constraintEntry.getValue()), (ImmutableSet<Integer>)nullableIndexes));
        }
        return dependentUnifierBuilder.build();
    }

    private ImmutableCollection<Collection<ExtensionalDataNode>> groupDataNodesPerConstraint(FunctionalDependency constraint, ImmutableCollection<ExtensionalDataNode> initialNodes) {
        ImmutableList constraintDeterminantIndexes = (ImmutableList)constraint.getDeterminants().stream().map(Attribute::getIndex).collect(ImmutableCollectors.toList());
        ImmutableMultimap nodeMultiMap = (ImmutableMultimap)initialNodes.stream().collect(ImmutableCollectors.toMultimap(n -> this.extractDeterminantArguments(n.getProjectionAtom(), (ImmutableList<Integer>)constraintDeterminantIndexes), n -> n));
        return nodeMultiMap.asMap().values();
    }

    private ImmutableList<VariableOrGroundTerm> extractDeterminantArguments(DataAtom dataAtom, ImmutableList<Integer> determinantIndexes) {
        ImmutableList arguments = dataAtom.getArguments();
        return (ImmutableList)determinantIndexes.stream().map(i -> (VariableOrGroundTerm)arguments.get(i - 1)).collect(ImmutableCollectors.toList());
    }

    private ImmutableCollection<ImmutableSubstitution<VariableOrGroundTerm>> extractDependentUnifiers(FunctionalDependency constraint, ImmutableCollection<Collection<ExtensionalDataNode>> dataNodeClusters, ImmutableSet<Integer> nullableIndexes) throws SelfJoinLikeExecutor.AtomUnificationException {
        ImmutableList dependentIndexes = (ImmutableList)constraint.getDependents().stream().map(d -> d.getIndex() - 1).collect(ImmutableCollectors.toList());
        ImmutableList.Builder substitutionCollectionBuilder = ImmutableList.builder();
        for (Collection cluster : dataNodeClusters) {
            substitutionCollectionBuilder.addAll(this.extractDependentUnifiersFromCluster((ImmutableList<Integer>)dependentIndexes, cluster, nullableIndexes));
        }
        return substitutionCollectionBuilder.build();
    }

    private Collection<ImmutableSubstitution<VariableOrGroundTerm>> extractDependentUnifiersFromCluster(ImmutableList<Integer> dependentIndexes, Collection<ExtensionalDataNode> cluster, ImmutableSet<Integer> nullableIndexes) throws SelfJoinLikeExecutor.AtomUnificationException {
        if (cluster.size() < 2) {
            return ImmutableList.of();
        }
        ExtensionalDataNode referenceDataNode = cluster.stream().findFirst().orElseGet(() -> (ExtensionalDataNode)cluster.iterator().next());
        ArrayList<ImmutableSubstitution<VariableOrGroundTerm>> substitutionCollection = new ArrayList<ImmutableSubstitution<VariableOrGroundTerm>>();
        for (ExtensionalDataNode currentDataNode : cluster) {
            if (currentDataNode == referenceDataNode) continue;
            this.unifyDependentTerms(referenceDataNode.getProjectionAtom(), currentDataNode.getProjectionAtom(), dependentIndexes, nullableIndexes).ifPresent(substitutionCollection::add);
        }
        return substitutionCollection;
    }

    private Optional<ImmutableSubstitution<VariableOrGroundTerm>> unifyDependentTerms(DataAtom leftAtom, DataAtom rightAtom, ImmutableList<Integer> dependentIndexes, ImmutableSet<Integer> nullableIndexes) throws SelfJoinLikeExecutor.AtomUnificationException {
        Optional<ImmutableSubstitution> currentUnifier = Optional.empty();
        for (Integer dependentIndex : dependentIndexes) {
            VariableOrGroundTerm leftArgument = leftAtom.getTerm(dependentIndex.intValue());
            VariableOrGroundTerm rightArgument = rightAtom.getTerm(dependentIndex.intValue());
            ImmutableSubstitution termUnifier = this.unificationTools.computeDirectedMGU((ImmutableTerm)rightArgument, (ImmutableTerm)leftArgument).map(ProtoSubstitution::getImmutableMap).map(map -> (ImmutableMap)map.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ImmutabilityTools.convertIntoVariableOrGroundTerm((ImmutableTerm)((ImmutableTerm)e.getValue()))))).map(arg_0 -> ((SubstitutionFactory)this.substitutionFactory).getSubstitution(arg_0)).orElseThrow(SelfJoinLikeExecutor.AtomUnificationException::new);
            ImmutableSubstitution candidateUnifier = currentUnifier.isPresent() ? (ImmutableSubstitution)this.unificationTools.computeAtomMGUS((ImmutableSubstitution)currentUnifier.get(), termUnifier).orElseThrow(SelfJoinLikeExecutor.AtomUnificationException::new) : termUnifier;
            currentUnifier = !nullableIndexes.contains((Object)dependentIndex) ? Optional.of(candidateUnifier) : currentUnifier;
        }
        return currentUnifier.filter(s -> !s.isEmpty());
    }

    private boolean isRemovable(ExtensionalDataNode node, ImmutableSet<Integer> independentIndexes, ImmutableSet<Variable> requiredAndCooccuringVariables) {
        ImmutableList arguments = node.getProjectionAtom().getArguments();
        return independentIndexes.stream().map(i -> (VariableOrGroundTerm)arguments.get(i - 1)).allMatch(t -> t instanceof Variable && !requiredAndCooccuringVariables.contains(t));
    }
}

