/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.datalog.impl;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;

public class OrderByLifter {
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private OrderByLifter(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    public IQTree liftOrderBy(IQTree iqTree) {
        QueryNode root = iqTree.getRootNode();
        if (root instanceof DistinctNode || root instanceof SliceNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)root, this.liftOrderBy(((UnaryIQTree)iqTree).getChild()));
        }
        if (root instanceof ConstructionNode) {
            IQTree child = this.liftOrderBy(((UnaryIQTree)iqTree).getChild());
            QueryNode childRoot = child.getRootNode();
            if (childRoot instanceof OrderByNode) {
                ImmutableSet projectedVars = ((ConstructionNode)root).getVariables();
                if (((OrderByNode)childRoot).getComparators().stream().flatMap(c -> c.getTerm().getVariableStream()).allMatch(v -> projectedVars.contains(v))) {
                    IQTree orderByChild = ((UnaryIQTree)child).getChild();
                    return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)childRoot, (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)root, orderByChild));
                }
            }
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)root, child);
        }
        return iqTree;
    }
}

