/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.owlapi;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFLiteralConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.spec.ontology.AnnotationAssertion;
import it.unibz.inf.ontop.spec.ontology.AnnotationProperty;
import it.unibz.inf.ontop.spec.ontology.ClassAssertion;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.DataPropertyAssertion;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.Datatype;
import it.unibz.inf.ontop.spec.ontology.InconsistentOntologyException;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyAssertion;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.OntologyBuilder;
import it.unibz.inf.ontop.spec.ontology.OntologyVocabularyCategory;
import it.unibz.inf.ontop.spec.ontology.impl.ClassImpl;
import it.unibz.inf.ontop.spec.ontology.impl.DataPropertyExpressionImpl;
import it.unibz.inf.ontop.spec.ontology.impl.DatatypeImpl;
import it.unibz.inf.ontop.spec.ontology.impl.OntologyBuilderImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.rdf.api.RDF;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLAPITranslatorOWL2QL {
    private static final Logger log = LoggerFactory.getLogger(OWLAPITranslatorOWL2QL.class);
    private static final String INCONSISTENT_ONTOLOGY = "The OWL 2 QL ontology is inconsistent due to axiom {}";
    private static final String INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE = "Inconsistency due to axiom ";
    private static final String NOT_SUPPORTED = "Axiom does not belong to OWL 2 QL: {}";
    private static final String NOT_SUPPORTED_EXT = "Axiom does not belong to OWL 2 QL: {} ({})";
    private static final boolean functionalityAxioms = true;
    private static final boolean minCardinalityClassExpressions = true;
    private static final boolean nestedQualifiedExistentials = true;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private static final Map<OWL2Datatype, Integer> DATATYPE_GROUP = ImmutableMap.builder().put((Object)OWL2Datatype.RDF_PLAIN_LITERAL, (Object)3).put((Object)OWL2Datatype.RDF_XML_LITERAL, (Object)1).put((Object)OWL2Datatype.RDFS_LITERAL, (Object)0).put((Object)OWL2Datatype.OWL_REAL, (Object)2).put((Object)OWL2Datatype.OWL_RATIONAL, (Object)2).put((Object)OWL2Datatype.XSD_DECIMAL, (Object)2).put((Object)OWL2Datatype.XSD_INTEGER, (Object)2).put((Object)OWL2Datatype.XSD_NON_NEGATIVE_INTEGER, (Object)2).put((Object)OWL2Datatype.XSD_STRING, (Object)3).put((Object)OWL2Datatype.XSD_NORMALIZED_STRING, (Object)3).put((Object)OWL2Datatype.XSD_TOKEN, (Object)3).put((Object)OWL2Datatype.XSD_NAME, (Object)3).put((Object)OWL2Datatype.XSD_NCNAME, (Object)3).put((Object)OWL2Datatype.XSD_NMTOKEN, (Object)3).put((Object)OWL2Datatype.XSD_HEX_BINARY, (Object)4).put((Object)OWL2Datatype.XSD_BASE_64_BINARY, (Object)5).put((Object)OWL2Datatype.XSD_ANY_URI, (Object)6).put((Object)OWL2Datatype.XSD_DATE_TIME, (Object)7).put((Object)OWL2Datatype.XSD_DATE_TIME_STAMP, (Object)7).put((Object)OWL2Datatype.XSD_INT, (Object)8).put((Object)OWL2Datatype.XSD_LONG, (Object)9).build();
    private static final Map<OWL2Datatype, Integer> DATATYPE_ORDER_IN_GROUP2 = ImmutableMap.of((Object)OWL2Datatype.OWL_REAL, (Object)0, (Object)OWL2Datatype.OWL_RATIONAL, (Object)1, (Object)OWL2Datatype.XSD_DECIMAL, (Object)2, (Object)OWL2Datatype.XSD_INTEGER, (Object)3, (Object)OWL2Datatype.XSD_NON_NEGATIVE_INTEGER, (Object)4);
    private static final Map<OWL2Datatype, Integer> DATATYPE_ORDER_IN_GROUP3 = ImmutableMap.builder().put((Object)OWL2Datatype.RDF_PLAIN_LITERAL, (Object)0).put((Object)OWL2Datatype.XSD_STRING, (Object)1).put((Object)OWL2Datatype.XSD_NORMALIZED_STRING, (Object)2).put((Object)OWL2Datatype.XSD_TOKEN, (Object)3).put((Object)OWL2Datatype.XSD_NMTOKEN, (Object)4).put((Object)OWL2Datatype.XSD_NAME, (Object)5).put((Object)OWL2Datatype.XSD_NCNAME, (Object)6).build();
    private static final Map<OWL2Datatype, Integer> DATATYPE_ORDER_IN_GROUP7 = ImmutableMap.of((Object)OWL2Datatype.XSD_DATE_TIME, (Object)0, (Object)OWL2Datatype.XSD_DATE_TIME_STAMP, (Object)1);

    @Inject
    private OWLAPITranslatorOWL2QL(TermFactory termFactory, RDF rdfFactory) {
        this.termFactory = termFactory;
        this.rdfFactory = rdfFactory;
    }

    public Ontology translateAndClassify(OWLOntology owl) {
        Set owls = owl.getOWLOntologyManager().getImportsClosure(owl);
        log.debug("Load ontologies called. Translating {} ontologies.", (Object)owls.size());
        OntologyBuilder builder = OntologyBuilderImpl.builder((RDF)this.rdfFactory);
        for (OWLOntology o : owls) {
            this.extractOntoloyVocabulary(o, builder);
        }
        for (OWLOntology o : owls) {
            OWLAxiomVisitorImpl visitor = new OWLAxiomVisitorImpl(o, builder);
            for (OWLAxiom axiom : o.getAxioms()) {
                axiom.accept((OWLAxiomVisitor)visitor);
            }
        }
        Ontology onto = builder.build();
        log.debug("Ontology loaded: {}", (Object)onto);
        return onto;
    }

    public ClassAssertion translate(OWLClassAssertionAxiom ax, OntologyVocabularyCategory<OClass> classes) throws TranslationException, InconsistentOntologyException {
        OWLClassExpression classExpression = ax.getClassExpression();
        if (!(classExpression instanceof OWLClass)) {
            throw new TranslationException("complex class expressions are not supported");
        }
        OClass concept = this.getOClass((OWLClass)classExpression, classes);
        IRIConstant c = this.getIndividual(ax.getIndividual());
        return OntologyBuilderImpl.createClassAssertion((OClass)concept, (ObjectConstant)c);
    }

    public ObjectPropertyAssertion translate(OWLObjectPropertyAssertionAxiom ax, OntologyVocabularyCategory<ObjectPropertyExpression> objectProperties) throws TranslationException, InconsistentOntologyException {
        IRIConstant c1 = this.getIndividual(ax.getSubject());
        IRIConstant c2 = this.getIndividual((OWLIndividual)ax.getObject());
        ObjectPropertyExpression ope = this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), objectProperties);
        return OntologyBuilderImpl.createObjectPropertyAssertion((ObjectPropertyExpression)ope, (ObjectConstant)c1, (ObjectConstant)c2);
    }

    public DataPropertyAssertion translate(OWLDataPropertyAssertionAxiom ax, OntologyVocabularyCategory<DataPropertyExpression> dataProperties) throws TranslationException, InconsistentOntologyException {
        IRIConstant c1 = this.getIndividual(ax.getSubject());
        RDFLiteralConstant c2 = this.getValueOfLiteral((OWLLiteral)ax.getObject());
        DataPropertyExpression dpe = this.getPropertyExpression((OWLDataPropertyExpression)ax.getProperty(), dataProperties);
        return OntologyBuilderImpl.createDataPropertyAssertion((DataPropertyExpression)dpe, (ObjectConstant)c1, (RDFLiteralConstant)c2);
    }

    public AnnotationAssertion translate(OWLAnnotationAssertionAxiom ax, OntologyVocabularyCategory<AnnotationProperty> annotationProperties) throws TranslationException, InconsistentOntologyException {
        IRIConstant c1 = this.getIndividual(ax.getSubject());
        Constant c2 = this.getValue(ax.getValue());
        AnnotationProperty ap = this.getPropertyExpression(ax.getProperty(), annotationProperties);
        return OntologyBuilderImpl.createAnnotationAssertion((AnnotationProperty)ap, (ObjectConstant)c1, (Constant)c2);
    }

    private org.apache.commons.rdf.api.IRI iri2iri(IRI iri) {
        return this.rdfFactory.createIRI(iri.toString());
    }

    private OClass getOClass(OWLClass clExpression, OntologyVocabularyCategory<OClass> voc) {
        return (OClass)voc.get(this.iri2iri(clExpression.getIRI()));
    }

    private ObjectPropertyExpression getPropertyExpression(OWLObjectPropertyExpression opeExpression, OntologyVocabularyCategory<ObjectPropertyExpression> voc) {
        if (opeExpression instanceof OWLObjectProperty) {
            return (ObjectPropertyExpression)voc.get(this.iri2iri(opeExpression.asOWLObjectProperty().getIRI()));
        }
        assert (opeExpression instanceof OWLObjectInverseOf);
        OWLObjectInverseOf aux = (OWLObjectInverseOf)opeExpression;
        return ((ObjectPropertyExpression)voc.get(this.iri2iri(aux.getInverse().asOWLObjectProperty().getIRI()))).getInverse();
    }

    private DataPropertyExpression getPropertyExpression(OWLDataPropertyExpression dpeExpression, OntologyVocabularyCategory<DataPropertyExpression> voc) {
        assert (dpeExpression instanceof OWLDataProperty);
        return (DataPropertyExpression)voc.get(this.iri2iri(dpeExpression.asOWLDataProperty().getIRI()));
    }

    private AnnotationProperty getPropertyExpression(OWLAnnotationProperty ap, OntologyVocabularyCategory<AnnotationProperty> voc) {
        return (AnnotationProperty)voc.get(this.iri2iri(ap.getIRI()));
    }

    private IRIConstant getIndividual(OWLIndividual ind) throws TranslationException {
        if (ind.isAnonymous()) {
            throw new TranslationException("Found anonymous individual, this feature is not supported:" + ind);
        }
        return this.termFactory.getConstantIRI(this.rdfFactory.createIRI(ind.asOWLNamedIndividual().getIRI().toString()));
    }

    private RDFLiteralConstant getValueOfLiteral(OWLLiteral object) {
        if (!object.getLang().isEmpty()) {
            return this.termFactory.getRDFLiteralConstant(object.getLiteral(), object.getLang());
        }
        return this.termFactory.getRDFLiteralConstant(object.getLiteral(), this.rdfFactory.createIRI(object.getDatatype().getIRI().toString()));
    }

    private IRIConstant getIndividual(OWLAnnotationSubject subject) throws TranslationException {
        if (subject instanceof IRI) {
            return this.termFactory.getConstantIRI(this.rdfFactory.createIRI(((IRI)((IRI)subject).asIRI().get()).toString()));
        }
        throw new TranslationException("Found anonymous individual, this feature is not supported:" + subject);
    }

    private Constant getValue(OWLAnnotationValue value) throws TranslationException {
        try {
            if (value instanceof IRI) {
                return this.termFactory.getConstantIRI(this.rdfFactory.createIRI(((IRI)value.asIRI().get()).toString()));
            }
            if (value instanceof OWLLiteral) {
                return this.getValueOfLiteral((OWLLiteral)value.asLiteral().get());
            }
            throw new TranslationException("Found anonymous individual, this feature is not supported:" + value);
        }
        catch (OWLRuntimeException ore) {
            throw new TranslationException(ore.getMessage());
        }
    }

    private static OWL2Datatype getIntersection(OWL2Datatype dt0, OWL2Datatype dt1) {
        Map<OWL2Datatype, Integer> linearOrder;
        if (dt0 == null || dt1 == null) {
            return null;
        }
        int g0 = DATATYPE_GROUP.get(dt0);
        int g1 = DATATYPE_GROUP.get(dt1);
        if (g0 == 0) {
            return dt1;
        }
        if (g1 == 0) {
            return dt0;
        }
        if (g0 != g1) {
            return null;
        }
        if (g0 == 2) {
            linearOrder = DATATYPE_ORDER_IN_GROUP2;
        } else if (g0 == 3) {
            linearOrder = DATATYPE_ORDER_IN_GROUP3;
        } else if (g0 == 7) {
            linearOrder = DATATYPE_ORDER_IN_GROUP7;
        } else {
            return dt0;
        }
        int o0 = linearOrder.get(dt0);
        int o1 = linearOrder.get(dt1);
        if (o0 > o1) {
            return dt0;
        }
        return dt1;
    }

    private Set<org.apache.commons.rdf.api.IRI> extractOntoloyVocabulary(OWLOntology owl, OntologyBuilder builder) {
        org.apache.commons.rdf.api.IRI iri;
        HashSet<org.apache.commons.rdf.api.IRI> punnedPredicates = new HashSet<org.apache.commons.rdf.api.IRI>();
        for (OWLClass entity : owl.getClassesInSignature()) {
            builder.declareClass(this.iri2iri(entity.getIRI()));
        }
        for (OWLObjectProperty prop : owl.getObjectPropertiesInSignature()) {
            iri = this.iri2iri(prop.getIRI());
            if (builder.dataProperties().contains(iri)) {
                punnedPredicates.add(iri);
                log.warn("Quest can become unstable with properties declared as both data and object. Offending property: " + iri);
                continue;
            }
            builder.declareObjectProperty(iri);
        }
        for (OWLObjectProperty prop : owl.getDataPropertiesInSignature()) {
            iri = this.iri2iri(prop.getIRI());
            if (builder.objectProperties().contains(iri)) {
                punnedPredicates.add(iri);
                log.warn("Quest can become unstable with properties declared as both data and object. Offending property: " + iri);
                continue;
            }
            builder.declareDataProperty(iri);
        }
        for (OWLObjectProperty prop : owl.getAnnotationPropertiesInSignature()) {
            builder.declareAnnotationProperty(this.iri2iri(prop.getIRI()));
        }
        return punnedPredicates;
    }

    private final class OWLAxiomVisitorImpl
    implements OWLAxiomVisitor {
        private final OntologyBuilder builder;
        private final OWLOntology currentOWLOntology;
        private final Map<OWLObjectPropertyExpression, Map<OWLClassExpression, ObjectSomeValuesFrom>> auxiliaryClassProperties = new HashMap<OWLObjectPropertyExpression, Map<OWLClassExpression, ObjectSomeValuesFrom>>();

        OWLAxiomVisitorImpl(OWLOntology owl, OntologyBuilder builder) {
            this.builder = builder;
            this.currentOWLOntology = owl;
        }

        public void visit(OWLSubClassOfAxiom ax) {
            try {
                ClassExpression subDescription = this.getSubclassExpression(ax.getSubClass());
                this.addSubClassAxioms(subDescription, ax.getSuperClass());
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLEquivalentClassesAxiom ax) {
            try {
                ClassExpression first;
                Iterator it = ax.getClassExpressions().iterator();
                ClassExpression previous = first = this.getSubclassExpression((OWLClassExpression)it.next());
                while (it.hasNext()) {
                    ClassExpression current = this.getSubclassExpression((OWLClassExpression)it.next());
                    this.builder.addSubClassOfAxiom(previous, current);
                    previous = current;
                }
                this.builder.addSubClassOfAxiom(previous, first);
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLDisjointClassesAxiom ax) {
            try {
                ClassExpression[] disjointProperties = new ClassExpression[ax.getClassExpressions().size()];
                int i = 0;
                for (OWLClassExpression ce : ax.getClassExpressions()) {
                    ClassExpression c = this.getSubclassExpression(ce);
                    disjointProperties[i++] = c;
                }
                this.builder.addDisjointClassesAxiom(disjointProperties);
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLClassAssertionAxiom ax) {
            try {
                OWLClassExpression classExpression = ax.getClassExpression();
                if (!(classExpression instanceof OWLClass)) {
                    throw new TranslationException("complex class expressions are not supported");
                }
                OClass concept = OWLAPITranslatorOWL2QL.this.getOClass((OWLClass)classExpression, (OntologyVocabularyCategory<OClass>)this.builder.classes());
                IRIConstant c = OWLAPITranslatorOWL2QL.this.getIndividual(ax.getIndividual());
                this.builder.addClassAssertion(concept, (ObjectConstant)c);
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLSubObjectPropertyOfAxiom ax) {
            try {
                ObjectPropertyExpression ope1 = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getSubProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                ObjectPropertyExpression ope2 = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getSuperProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.builder.addSubPropertyOfAxiom(ope1, ope2);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom ax) {
            try {
                ObjectPropertyExpression first;
                Iterator it = ax.getProperties().iterator();
                ObjectPropertyExpression previous = first = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)it.next(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                while (it.hasNext()) {
                    ObjectPropertyExpression current = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)it.next(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                    this.builder.addSubPropertyOfAxiom(previous, current);
                    previous = current;
                }
                this.builder.addSubPropertyOfAxiom(previous, first);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLDisjointObjectPropertiesAxiom ax) {
            try {
                ObjectPropertyExpression[] opes = new ObjectPropertyExpression[ax.getProperties().size()];
                int i = 0;
                for (OWLObjectPropertyExpression prop : ax.getProperties()) {
                    ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression(prop, (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                    opes[i++] = ope;
                }
                this.builder.addDisjointObjectPropertiesAxiom(opes);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLInverseObjectPropertiesAxiom ax) {
            try {
                ObjectPropertyExpression ope1 = OWLAPITranslatorOWL2QL.this.getPropertyExpression(ax.getFirstProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                ObjectPropertyExpression ope2 = OWLAPITranslatorOWL2QL.this.getPropertyExpression(ax.getSecondProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.builder.addSubPropertyOfAxiom(ope1, ope2.getInverse());
                this.builder.addSubPropertyOfAxiom(ope2, ope1.getInverse());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLObjectPropertyDomainAxiom ax) {
            try {
                ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.addSubClassAxioms((ClassExpression)ope.getDomain(), ax.getDomain());
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLObjectPropertyRangeAxiom ax) {
            try {
                ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.addSubClassAxioms((ClassExpression)ope.getRange(), (OWLClassExpression)ax.getRange());
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLReflexiveObjectPropertyAxiom ax) {
            try {
                ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.builder.addReflexiveObjectPropertyAxiom(ope);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom ax) {
            try {
                ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.builder.addIrreflexiveObjectPropertyAxiom(ope);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom ax) {
            try {
                ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.builder.addSubPropertyOfAxiom(ope, ope.getInverse());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom ax) {
            try {
                ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.builder.addDisjointObjectPropertiesAxiom(new ObjectPropertyExpression[]{ope, ope.getInverse()});
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLObjectPropertyAssertionAxiom ax) {
            try {
                IRIConstant c1 = OWLAPITranslatorOWL2QL.this.getIndividual(ax.getSubject());
                IRIConstant c2 = OWLAPITranslatorOWL2QL.this.getIndividual((OWLIndividual)ax.getObject());
                ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                this.builder.addObjectPropertyAssertion(ope, (ObjectConstant)c1, (ObjectConstant)c2);
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLSubDataPropertyOfAxiom ax) {
            try {
                DataPropertyExpression dpe1 = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLDataPropertyExpression)ax.getSubProperty(), (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
                DataPropertyExpression dpe2 = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLDataPropertyExpression)ax.getSuperProperty(), (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
                this.builder.addSubPropertyOfAxiom(dpe1, dpe2);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLEquivalentDataPropertiesAxiom ax) {
            try {
                DataPropertyExpression first;
                Iterator it = ax.getProperties().iterator();
                DataPropertyExpression previous = first = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLDataPropertyExpression)it.next(), (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
                while (it.hasNext()) {
                    DataPropertyExpression current = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLDataPropertyExpression)it.next(), (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
                    this.builder.addSubPropertyOfAxiom(previous, current);
                    previous = current;
                }
                this.builder.addSubPropertyOfAxiom(previous, first);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom ax) {
            try {
                DataPropertyExpression[] dpes = new DataPropertyExpression[ax.getProperties().size()];
                int i = 0;
                for (OWLDataPropertyExpression prop : ax.getProperties()) {
                    DataPropertyExpression dpe = OWLAPITranslatorOWL2QL.this.getPropertyExpression(prop, (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
                    dpes[i++] = dpe;
                }
                this.builder.addDisjointDataPropertiesAxiom(dpes);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLDataPropertyDomainAxiom ax) {
            try {
                DataPropertyExpression role = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLDataPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
                this.addSubClassAxioms((ClassExpression)role.getDomainRestriction(DatatypeImpl.rdfsLiteral), ax.getDomain());
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLDataPropertyRangeAxiom ax) {
            DataPropertyExpression dpe = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLDataPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
            try {
                OWL2Datatype owlDatatype = this.getCanonicalDatatype((OWLDataRange)ax.getRange());
                if (owlDatatype == null) {
                    this.builder.addSubPropertyOfAxiom(dpe, DataPropertyExpressionImpl.owlBottomDataProperty);
                } else {
                    Datatype datatype = this.builder.getDatatype(owlDatatype.getIRI().toString());
                    this.builder.addDataPropertyRangeAxiom(dpe.getRange(), datatype);
                }
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom ax) {
            try {
                IRIConstant c1 = OWLAPITranslatorOWL2QL.this.getIndividual(ax.getSubject());
                RDFLiteralConstant c2 = OWLAPITranslatorOWL2QL.this.getValueOfLiteral((OWLLiteral)ax.getObject());
                DataPropertyExpression dpe = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLDataPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
                this.builder.addDataPropertyAssertion(dpe, (ObjectConstant)c1, c2);
            }
            catch (InconsistentOntologyException e) {
                log.warn(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY, (Object)ax);
                throw new RuntimeException(OWLAPITranslatorOWL2QL.INCONSISTENT_ONTOLOGY_EXCEPTION_MESSAGE + ax);
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
        }

        public void visit(OWLDifferentIndividualsAxiom ax) {
        }

        public void visit(OWLDatatypeDefinitionAxiom ax) {
        }

        private OWL2Datatype getCanonicalDatatype(OWLDataRange dr) throws TranslationException {
            return this.getCanonicalDatatype(OWL2Datatype.RDFS_LITERAL, dr);
        }

        private OWL2Datatype getCanonicalDatatype(OWL2Datatype dt0, OWLDataRange dr) throws TranslationException {
            switch (dr.getDataRangeType()) {
                case DATATYPE: {
                    OWLDatatype dtype = dr.asOWLDatatype();
                    if (dtype.isBuiltIn()) {
                        OWL2Datatype dt1 = dtype.getBuiltInDatatype();
                        if (!DATATYPE_GROUP.containsKey(dt1)) {
                            throw new TranslationException("unsupported datatype: " + dt1);
                        }
                        return OWLAPITranslatorOWL2QL.getIntersection(dt0, dt1);
                    }
                    Set defs = this.currentOWLOntology.getDatatypeDefinitions(dtype);
                    if (defs == null) {
                        throw new TranslationException("undeclared datatype: " + dtype);
                    }
                    for (OWLDatatypeDefinitionAxiom def : defs) {
                        dt0 = this.getCanonicalDatatype(dt0, def.getDataRange());
                    }
                    return dt0;
                }
                case DATA_INTERSECTION_OF: {
                    for (OWLDataRange d : ((OWLDataIntersectionOf)dr).getOperands()) {
                        dt0 = this.getCanonicalDatatype(dt0, d);
                    }
                    return dt0;
                }
            }
            throw new TranslationException("unsupported OWLDataRange construct: " + dr);
        }

        private ClassExpression getSubclassExpression(OWLClassExpression owlCE) throws TranslationException {
            if (owlCE instanceof OWLClass) {
                return OWLAPITranslatorOWL2QL.this.getOClass((OWLClass)owlCE, (OntologyVocabularyCategory<OClass>)this.builder.classes());
            }
            if (owlCE instanceof OWLObjectSomeValuesFrom) {
                OWLObjectSomeValuesFrom someexp = (OWLObjectSomeValuesFrom)owlCE;
                if (!((OWLClassExpression)someexp.getFiller()).isOWLThing()) {
                    throw new TranslationException();
                }
                return OWLAPITranslatorOWL2QL.this.getPropertyExpression(someexp.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties()).getDomain();
            }
            if (owlCE instanceof OWLDataSomeValuesFrom) {
                OWLDataSomeValuesFrom someexp = (OWLDataSomeValuesFrom)owlCE;
                return this.getDataSomeValuesFrom(someexp.getProperty(), (OWLDataRange)someexp.getFiller());
            }
            if (owlCE instanceof OWLObjectMinCardinality) {
                OWLObjectMinCardinality someexp = (OWLObjectMinCardinality)owlCE;
                if (someexp.getCardinality() != 1 || !((OWLClassExpression)someexp.getFiller()).isOWLThing()) {
                    throw new TranslationException();
                }
                return OWLAPITranslatorOWL2QL.this.getPropertyExpression(someexp.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties()).getDomain();
            }
            if (owlCE instanceof OWLDataMinCardinality) {
                OWLDataMinCardinality someexp = (OWLDataMinCardinality)owlCE;
                if (someexp.getCardinality() != 1) {
                    throw new TranslationException();
                }
                return this.getDataSomeValuesFrom(someexp.getProperty(), (OWLDataRange)someexp.getFiller());
            }
            throw new TranslationException("unsupported construct " + owlCE);
        }

        private void addSubClassAxioms(ClassExpression ce1, OWLClassExpression owlCE2) throws TranslationException, InconsistentOntologyException {
            for (OWLClassExpression superClass : owlCE2.asConjunctSet()) {
                ClassExpression ce2;
                OWLObjectSomeValuesFrom someexp;
                if (superClass instanceof OWLClass) {
                    OClass ce22 = OWLAPITranslatorOWL2QL.this.getOClass((OWLClass)superClass, (OntologyVocabularyCategory<OClass>)this.builder.classes());
                    this.builder.addSubClassOfAxiom(ce1, (ClassExpression)ce22);
                    continue;
                }
                if (superClass instanceof OWLObjectSomeValuesFrom) {
                    someexp = (OWLObjectSomeValuesFrom)superClass;
                    this.addSubClassOfObjectSomeValuesFromAxiom(ce1, someexp.getProperty(), (OWLClassExpression)someexp.getFiller());
                    continue;
                }
                if (superClass instanceof OWLDataSomeValuesFrom) {
                    someexp = (OWLDataSomeValuesFrom)superClass;
                    ce2 = this.getDataSomeValuesFrom(someexp.getProperty(), (OWLDataRange)someexp.getFiller());
                    this.builder.addSubClassOfAxiom(ce1, ce2);
                    continue;
                }
                if (superClass instanceof OWLObjectComplementOf) {
                    OWLObjectComplementOf superC = (OWLObjectComplementOf)superClass;
                    ce2 = this.getSubclassExpression(superC.getOperand());
                    this.builder.addDisjointClassesAxiom(new ClassExpression[]{ce1, ce2});
                    continue;
                }
                if (superClass instanceof OWLObjectMinCardinality) {
                    someexp = (OWLObjectMinCardinality)superClass;
                    if (someexp.getCardinality() != 1) {
                        throw new TranslationException();
                    }
                    this.addSubClassOfObjectSomeValuesFromAxiom(ce1, someexp.getProperty(), (OWLClassExpression)someexp.getFiller());
                    continue;
                }
                if (superClass instanceof OWLDataMinCardinality) {
                    someexp = (OWLDataMinCardinality)superClass;
                    if (someexp.getCardinality() != 1) {
                        throw new TranslationException();
                    }
                    ce2 = this.getDataSomeValuesFrom(someexp.getProperty(), (OWLDataRange)someexp.getFiller());
                    this.builder.addSubClassOfAxiom(ce1, ce2);
                    continue;
                }
                throw new TranslationException("unsupported operation in " + superClass);
            }
        }

        private void addSubClassOfObjectSomeValuesFromAxiom(ClassExpression ce1, OWLObjectPropertyExpression owlOPE, OWLClassExpression owlCE) throws TranslationException, InconsistentOntologyException {
            if (owlOPE.isOWLBottomObjectProperty() || owlCE.isOWLNothing()) {
                this.builder.addSubClassOfAxiom(ce1, (ClassExpression)ClassImpl.owlNothing);
            } else if (owlCE.isOWLThing()) {
                if (!owlOPE.isOWLTopObjectProperty()) {
                    ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression(owlOPE, (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                    this.builder.addSubClassOfAxiom(ce1, (ClassExpression)ope.getDomain());
                }
            } else {
                ObjectSomeValuesFrom existsSA;
                Map<OWLClassExpression, ObjectSomeValuesFrom> entry = this.auxiliaryClassProperties.get(owlOPE);
                if (entry == null) {
                    entry = new HashMap<OWLClassExpression, ObjectSomeValuesFrom>();
                    this.auxiliaryClassProperties.put(owlOPE, entry);
                }
                if ((existsSA = entry.get(owlCE)) == null) {
                    ObjectPropertyExpression R = OWLAPITranslatorOWL2QL.this.getPropertyExpression(owlOPE, (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
                    ObjectPropertyExpression SA = this.builder.createAuxiliaryObjectProperty();
                    if (R.isInverse()) {
                        SA = SA.getInverse();
                    }
                    existsSA = SA.getDomain();
                    entry.put(owlCE, existsSA);
                    if (owlCE instanceof OWLClass) {
                        ClassExpression A = this.getSubclassExpression(owlCE);
                        this.builder.addSubClassOfAxiom((ClassExpression)SA.getRange(), A);
                    } else {
                        this.addSubClassAxioms((ClassExpression)SA.getRange(), owlCE);
                    }
                    this.builder.addSubPropertyOfAxiom(SA, R);
                }
                this.builder.addSubClassOfAxiom(ce1, (ClassExpression)existsSA);
            }
        }

        private ClassExpression getDataSomeValuesFrom(OWLDataPropertyExpression owlDPE, OWLDataRange owlDR) throws TranslationException {
            OWL2Datatype owlDatatype = this.getCanonicalDatatype(owlDR);
            if (owlDatatype == null) {
                return ClassImpl.owlNothing;
            }
            Datatype datatype = this.builder.getDatatype(owlDatatype.getIRI().toString());
            DataPropertyExpression dpe = OWLAPITranslatorOWL2QL.this.getPropertyExpression(owlDPE, (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
            return dpe.getDomainRestriction(datatype);
        }

        public void visit(OWLDisjointUnionAxiom ax) {
            log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED, (Object)ax);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom ax) {
            ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
            this.builder.addFunctionalObjectPropertyAxiom(ope);
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom ax) {
            ObjectPropertyExpression ope = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLObjectPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<ObjectPropertyExpression>)this.builder.objectProperties());
            this.builder.addFunctionalObjectPropertyAxiom(ope.getInverse());
        }

        public void visit(OWLTransitiveObjectPropertyAxiom ax) {
            log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED, (Object)ax);
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom ax) {
            log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED, (Object)ax);
        }

        public void visit(OWLFunctionalDataPropertyAxiom ax) {
            DataPropertyExpression dpe = OWLAPITranslatorOWL2QL.this.getPropertyExpression((OWLDataPropertyExpression)ax.getProperty(), (OntologyVocabularyCategory<DataPropertyExpression>)this.builder.dataProperties());
            this.builder.addFunctionalDataPropertyAxiom(dpe);
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom ax) {
            log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED, (Object)ax);
        }

        public void visit(OWLSameIndividualAxiom ax) {
            log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED, (Object)ax);
        }

        public void visit(OWLSubPropertyChainOfAxiom ax) {
            log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED, (Object)ax);
        }

        public void visit(OWLHasKeyAxiom ax) {
            log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED, (Object)ax);
        }

        public void visit(SWRLRule ax) {
            log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED, (Object)ax);
        }

        public void visit(OWLAnnotationAssertionAxiom ax) {
            try {
                IRIConstant c1 = OWLAPITranslatorOWL2QL.this.getIndividual(ax.getSubject());
                Constant c2 = OWLAPITranslatorOWL2QL.this.getValue(ax.getValue());
                AnnotationProperty ap = OWLAPITranslatorOWL2QL.this.getPropertyExpression(ax.getProperty(), (OntologyVocabularyCategory<AnnotationProperty>)this.builder.annotationProperties());
                this.builder.addAnnotationAssertion(ap, (ObjectConstant)c1, c2);
            }
            catch (TranslationException e) {
                log.warn(OWLAPITranslatorOWL2QL.NOT_SUPPORTED_EXT, (Object)ax, (Object)e.getMessage());
            }
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom ax) {
            AnnotationProperty ap1 = OWLAPITranslatorOWL2QL.this.getPropertyExpression(ax.getSubProperty(), (OntologyVocabularyCategory<AnnotationProperty>)this.builder.annotationProperties());
            AnnotationProperty ap2 = OWLAPITranslatorOWL2QL.this.getPropertyExpression(ax.getSuperProperty(), (OntologyVocabularyCategory<AnnotationProperty>)this.builder.annotationProperties());
        }

        public void visit(OWLAnnotationPropertyDomainAxiom ax) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom ax) {
        }

        public void visit(OWLDeclarationAxiom ax) {
        }
    }

    public static class TranslationException
    extends Exception {
        public TranslationException() {
        }

        public TranslationException(String msg) {
            super(msg);
        }
    }
}

