/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import it.unibz.inf.ontop.com.google.common.base.Objects;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import java.util.Optional;
import javax.annotation.Nullable;

public class RDFFactImpl
implements RDFFact {
    private final ObjectConstant subject;
    private final IRIConstant property;
    private final RDFConstant object;
    @Nullable
    private final ObjectConstant graph;
    private final ObjectConstant classOrProperty;

    private RDFFactImpl(ObjectConstant subject, IRIConstant property, RDFConstant object, ObjectConstant graph) {
        this.subject = subject;
        this.property = property;
        this.object = object;
        this.graph = graph;
        this.classOrProperty = RDFFactImpl.extractClassOrProperty(property, object);
    }

    private RDFFactImpl(ObjectConstant subject, IRIConstant property, RDFConstant object) {
        this.subject = subject;
        this.property = property;
        this.object = object;
        this.graph = null;
        this.classOrProperty = RDFFactImpl.extractClassOrProperty(property, object);
    }

    public static RDFFact createQuadFact(ObjectConstant subject, IRIConstant property, RDFConstant object, ObjectConstant graph) {
        return new RDFFactImpl(subject, property, object, graph);
    }

    public static RDFFact createTripleFact(ObjectConstant subject, IRIConstant property, RDFConstant object) {
        return new RDFFactImpl(subject, property, object);
    }

    private static ObjectConstant extractClassOrProperty(IRIConstant property, RDFConstant object) {
        if (property.getIRI().equals((Object)RDF.TYPE)) {
            if (object instanceof ObjectConstant) {
                return (ObjectConstant)object;
            }
            throw new IllegalArgumentException("The class must be an IRI or a b-node");
        }
        return property;
    }

    @Override
    public ObjectConstant getSubject() {
        return this.subject;
    }

    @Override
    public IRIConstant getProperty() {
        return this.property;
    }

    @Override
    public RDFConstant getObject() {
        return this.object;
    }

    @Override
    public Optional<ObjectConstant> getGraph() {
        return Optional.ofNullable(this.graph);
    }

    @Override
    public ObjectConstant getClassOrProperty() {
        return this.classOrProperty;
    }

    @Override
    public boolean isClassAssertion() {
        return !this.getClassOrProperty().equals(this.property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RDFFact)) {
            return false;
        }
        RDFFact rdfFact = (RDFFact)o;
        return Objects.equal((Object)this.getSubject(), (Object)rdfFact.getSubject()) && Objects.equal((Object)this.getProperty(), (Object)rdfFact.getProperty()) && Objects.equal((Object)this.getObject(), (Object)rdfFact.getObject()) && Objects.equal(this.getGraph(), rdfFact.getGraph()) && Objects.equal((Object)this.getClassOrProperty(), (Object)rdfFact.getClassOrProperty());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getSubject(), this.getProperty(), this.getObject(), this.getGraph(), this.getClassOrProperty()});
    }

    public String toString() {
        return "RDFFact{subject=" + this.subject + ", property=" + this.property + ", object=" + this.object + ", graph=" + this.graph + ", classOrProperty=" + this.classOrProperty + '}';
    }
}

