/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.model.vocabulary.RDF;
import it.unibz.inf.ontop.model.vocabulary.RDFS;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.spec.ontology.AnnotationProperty;
import it.unibz.inf.ontop.spec.ontology.BinaryAxiom;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataRangeExpression;
import it.unibz.inf.ontop.spec.ontology.Datatype;
import it.unibz.inf.ontop.spec.ontology.NaryAxiom;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.OntologyVocabularyCategory;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.spec.ontology.impl.ClassifiedTBoxImpl;
import it.unibz.inf.ontop.spec.ontology.impl.DatatypeImpl;
import java.util.Iterator;
import org.apache.commons.rdf.api.IRI;

public class OntologyImpl
implements Ontology {
    private final ImmutableSet<ObjectPropertyExpression> auxObjectProperties;
    private final ImmutableList<BinaryAxiom<ClassExpression>> classInclusions;
    private final ImmutableList<NaryAxiom<ClassExpression>> classDisjointness;
    private final ImmutableList<BinaryAxiom<ObjectPropertyExpression>> objectPropertyInclusions;
    private final ImmutableList<NaryAxiom<ObjectPropertyExpression>> objectPropertyDisjointness;
    private final ImmutableList<BinaryAxiom<DataPropertyExpression>> dataPropertyInclusions;
    private final ImmutableList<NaryAxiom<DataPropertyExpression>> dataPropertyDisjointness;
    private final ImmutableList<BinaryAxiom<DataRangeExpression>> subDataRangeAxioms;
    private final ImmutableSet<ObjectPropertyExpression> reflexiveObjectPropertyAxioms;
    private final ImmutableSet<ObjectPropertyExpression> irreflexiveObjectPropertyAxioms;
    private final ImmutableSet<ObjectPropertyExpression> functionalObjectPropertyAxioms;
    private final ImmutableSet<DataPropertyExpression> functionalDataPropertyAxioms;
    private final ImmutableSet<RDFFact> assertions;
    private static final String DATATYPE_NOT_FOUND = "Datatype not found: ";
    public static final ImmutableMap<String, Datatype> OWL2QLDatatypes = ImmutableMap.builder().put((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral", (Object)new DatatypeImpl(RDF.PLAINLITERAL)).put((Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", (Object)new DatatypeImpl(RDF.XMLLITERAL)).put((Object)"http://www.w3.org/2000/01/rdf-schema#Literal", (Object)new DatatypeImpl(RDFS.LITERAL)).put((Object)"http://www.w3.org/2002/07/owl#real", (Object)new DatatypeImpl(OWL.REAL)).put((Object)"http://www.w3.org/2002/07/owl#rational", (Object)new DatatypeImpl(OWL.RATIONAL)).put((Object)"http://www.w3.org/2001/XMLSchema#decimal", (Object)new DatatypeImpl(XSD.DECIMAL)).put((Object)"http://www.w3.org/2001/XMLSchema#integer", (Object)new DatatypeImpl(XSD.INTEGER)).put((Object)"http://www.w3.org/2001/XMLSchema#nonNegativeInteger", (Object)new DatatypeImpl(XSD.NON_NEGATIVE_INTEGER)).put((Object)"http://www.w3.org/2001/XMLSchema#string", (Object)new DatatypeImpl(XSD.STRING)).put((Object)"http://www.w3.org/2001/XMLSchema#normalizedString", (Object)new DatatypeImpl(XSD.NORMALIZEDSTRING)).put((Object)"http://www.w3.org/2001/XMLSchema#token", (Object)new DatatypeImpl(XSD.TOKEN)).put((Object)"http://www.w3.org/2001/XMLSchema#Name", (Object)new DatatypeImpl(XSD.NAME)).put((Object)"http://www.w3.org/2001/XMLSchema#NCName", (Object)new DatatypeImpl(XSD.NCNAME)).put((Object)"http://www.w3.org/2001/XMLSchema#NMTOKEN", (Object)new DatatypeImpl(XSD.NMTOKEN)).put((Object)"http://www.w3.org/2001/XMLSchema#hexBinary", (Object)new DatatypeImpl(XSD.HEXBINARY)).put((Object)"http://www.w3.org/2001/XMLSchema#base64Binary", (Object)new DatatypeImpl(XSD.BASE64BINARY)).put((Object)"http://www.w3.org/2001/XMLSchema#anyURI", (Object)new DatatypeImpl(XSD.ANYURI)).put((Object)"http://www.w3.org/2001/XMLSchema#dateTime", (Object)new DatatypeImpl(XSD.DATETIME)).put((Object)"http://www.w3.org/2001/XMLSchema#dateTimeStamp", (Object)new DatatypeImpl(XSD.DATETIMESTAMP)).put((Object)"http://www.w3.org/2001/XMLSchema#int", (Object)new DatatypeImpl(XSD.INT)).put((Object)"http://www.w3.org/2001/XMLSchema#long", (Object)new DatatypeImpl(XSD.LONG)).build();
    private static final String rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String rdfs = "http://www.w3.org/2000/01/rdf-schema#";
    private static final String owl = "http://www.w3.org/2002/07/owl#";
    private static final String xsd = "http://www.w3.org/2001/XMLSchema#";
    private final ImmutableOntologyVocabularyCategoryImpl<OClass> classes;
    private final ImmutableOntologyVocabularyCategoryImpl<ObjectPropertyExpression> objectProperties;
    private final ImmutableOntologyVocabularyCategoryImpl<DataPropertyExpression> dataProperties;
    private final ImmutableOntologyVocabularyCategoryImpl<AnnotationProperty> annotationProperties;
    private final UnclassifiedOntologyTBox unclassifiedTBox;
    private final ClassifiedTBox tbox;

    OntologyImpl(ImmutableOntologyVocabularyCategoryImpl<OClass> classes, ImmutableOntologyVocabularyCategoryImpl<ObjectPropertyExpression> objectProperties, ImmutableSet<ObjectPropertyExpression> auxObjectProperties, ImmutableOntologyVocabularyCategoryImpl<DataPropertyExpression> dataProperties, ImmutableOntologyVocabularyCategoryImpl<AnnotationProperty> annotationProperties, ImmutableList<BinaryAxiom<ClassExpression>> classInclusions, ImmutableList<NaryAxiom<ClassExpression>> classDisjointness, ImmutableList<BinaryAxiom<ObjectPropertyExpression>> objectPropertyInclusions, ImmutableList<NaryAxiom<ObjectPropertyExpression>> objectPropertyDisjointness, ImmutableList<BinaryAxiom<DataPropertyExpression>> dataPropertyInclusions, ImmutableList<NaryAxiom<DataPropertyExpression>> dataPropertyDisjointness, ImmutableList<BinaryAxiom<DataRangeExpression>> subDataRangeAxioms, ImmutableSet<ObjectPropertyExpression> reflexiveObjectPropertyAxioms, ImmutableSet<ObjectPropertyExpression> irreflexiveObjectPropertyAxioms, ImmutableSet<ObjectPropertyExpression> functionalObjectPropertyAxioms, ImmutableSet<DataPropertyExpression> functionalDataPropertyAxioms, ImmutableSet<RDFFact> assertions) {
        this.classes = classes;
        this.objectProperties = objectProperties;
        this.auxObjectProperties = auxObjectProperties;
        this.dataProperties = dataProperties;
        this.annotationProperties = annotationProperties;
        this.classInclusions = classInclusions;
        this.classDisjointness = classDisjointness;
        this.objectPropertyInclusions = objectPropertyInclusions;
        this.objectPropertyDisjointness = objectPropertyDisjointness;
        this.dataPropertyInclusions = dataPropertyInclusions;
        this.dataPropertyDisjointness = dataPropertyDisjointness;
        this.subDataRangeAxioms = subDataRangeAxioms;
        this.reflexiveObjectPropertyAxioms = reflexiveObjectPropertyAxioms;
        this.irreflexiveObjectPropertyAxioms = irreflexiveObjectPropertyAxioms;
        this.functionalObjectPropertyAxioms = functionalObjectPropertyAxioms;
        this.functionalDataPropertyAxioms = functionalDataPropertyAxioms;
        this.assertions = assertions;
        this.unclassifiedTBox = new UnclassifiedOntologyTBox();
        this.tbox = ClassifiedTBoxImpl.classify(this.unclassifiedTBox);
    }

    @Override
    public OntologyVocabularyCategory<AnnotationProperty> annotationProperties() {
        return this.annotationProperties;
    }

    @Override
    public Datatype getDatatype(String uri) {
        Datatype dt = (Datatype)OWL2QLDatatypes.get((Object)uri);
        if (dt == null) {
            throw new RuntimeException(DATATYPE_NOT_FOUND + uri);
        }
        return dt;
    }

    @Override
    public ClassifiedTBox tbox() {
        return this.tbox;
    }

    public UnclassifiedOntologyTBox unclassifiedTBox() {
        return this.unclassifiedTBox;
    }

    @Override
    public ImmutableSet<RDFFact> abox() {
        return this.assertions;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[Ontology info.").append(String.format(" Axioms: %d", this.classInclusions.size() + this.objectPropertyInclusions.size() + this.dataPropertyInclusions.size())).append(String.format(" Classes: %d", ((ImmutableOntologyVocabularyCategoryImpl)this.classes).map.size())).append(String.format(" Object Properties: %d", ((ImmutableOntologyVocabularyCategoryImpl)this.objectProperties).map.size())).append(String.format(" Data Properties: %d", ((ImmutableOntologyVocabularyCategoryImpl)this.dataProperties).map.size())).append(String.format(" Annotation Properties: %d]", ((ImmutableOntologyVocabularyCategoryImpl)this.annotationProperties).map.size()));
        return str.toString();
    }

    public final class UnclassifiedOntologyTBox {
        public OntologyVocabularyCategory<OClass> classes() {
            return OntologyImpl.this.classes;
        }

        public OntologyVocabularyCategory<ObjectPropertyExpression> objectProperties() {
            return OntologyImpl.this.objectProperties;
        }

        public OntologyVocabularyCategory<DataPropertyExpression> dataProperties() {
            return OntologyImpl.this.dataProperties;
        }

        public OntologyVocabularyCategory<AnnotationProperty> annotationProperties() {
            return OntologyImpl.this.annotationProperties;
        }

        public ImmutableList<BinaryAxiom<ClassExpression>> getSubClassAxioms() {
            return OntologyImpl.this.classInclusions;
        }

        public ImmutableList<BinaryAxiom<DataRangeExpression>> getSubDataRangeAxioms() {
            return OntologyImpl.this.subDataRangeAxioms;
        }

        public ImmutableList<BinaryAxiom<ObjectPropertyExpression>> getSubObjectPropertyAxioms() {
            return OntologyImpl.this.objectPropertyInclusions;
        }

        public ImmutableList<BinaryAxiom<DataPropertyExpression>> getSubDataPropertyAxioms() {
            return OntologyImpl.this.dataPropertyInclusions;
        }

        public ImmutableSet<ObjectPropertyExpression> getFunctionalObjectProperties() {
            return OntologyImpl.this.functionalObjectPropertyAxioms;
        }

        public ImmutableSet<DataPropertyExpression> getFunctionalDataProperties() {
            return OntologyImpl.this.functionalDataPropertyAxioms;
        }

        public ImmutableList<NaryAxiom<ClassExpression>> getDisjointClassesAxioms() {
            return OntologyImpl.this.classDisjointness;
        }

        public ImmutableList<NaryAxiom<ObjectPropertyExpression>> getDisjointObjectPropertiesAxioms() {
            return OntologyImpl.this.objectPropertyDisjointness;
        }

        public ImmutableList<NaryAxiom<DataPropertyExpression>> getDisjointDataPropertiesAxioms() {
            return OntologyImpl.this.dataPropertyDisjointness;
        }

        public ImmutableSet<ObjectPropertyExpression> getReflexiveObjectPropertyAxioms() {
            return OntologyImpl.this.reflexiveObjectPropertyAxioms;
        }

        public ImmutableSet<ObjectPropertyExpression> getIrreflexiveObjectPropertyAxioms() {
            return OntologyImpl.this.irreflexiveObjectPropertyAxioms;
        }

        public ImmutableSet<ObjectPropertyExpression> getAuxiliaryObjectProperties() {
            return OntologyImpl.this.auxObjectProperties;
        }
    }

    static final class ImmutableOntologyVocabularyCategoryImpl<T>
    implements OntologyVocabularyCategory<T> {
        private final ImmutableMap<IRI, T> map;
        private final String NOT_FOUND;

        ImmutableOntologyVocabularyCategoryImpl(ImmutableMap<IRI, T> map, String NOT_FOUND) {
            this.map = map;
            this.NOT_FOUND = NOT_FOUND;
        }

        @Override
        public T get(IRI iri) {
            Object oc = this.map.get((Object)iri);
            if (oc == null) {
                throw new RuntimeException(this.NOT_FOUND + iri);
            }
            return (T)oc;
        }

        @Override
        public boolean contains(IRI iri) {
            return this.map.containsKey((Object)iri);
        }

        @Override
        public Iterator<T> iterator() {
            return this.map.values().iterator();
        }
    }
}

