/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.InvalidPrefixWritingException;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractPrefixManager
implements PrefixManager {
    protected abstract Optional<String> getIriDefinition(String var1);

    protected abstract ImmutableList<Map.Entry<String, String>> getOrderedMap();

    protected static ImmutableList<Map.Entry<String, String>> orderMap(Map<String, String> map) {
        Comparator comparator = Map.Entry.comparingByValue().thenComparing(Map.Entry.comparingByKey());
        return (ImmutableList)map.entrySet().stream().sorted(comparator).collect(ImmutableCollectors.toList());
    }

    @Override
    public String getShortForm(String stringIri) {
        String fullIri = stringIri.startsWith("<") && stringIri.endsWith(">") ? stringIri.substring(1, stringIri.length() - 1) : stringIri;
        for (Map.Entry e : this.getOrderedMap()) {
            String iri = (String)e.getValue();
            if (!fullIri.startsWith(iri)) continue;
            return (String)e.getKey() + fullIri.substring(iri.length());
        }
        return stringIri;
    }

    @Override
    public String getExpandForm(String prefixedName) {
        int index = prefixedName.indexOf(":") + 1;
        if (index == 0) {
            throw new InvalidPrefixWritingException();
        }
        String prefix = prefixedName.substring(0, index);
        String iri = this.getIriDefinition(prefix).orElseThrow(() -> new InvalidPrefixWritingException("The prefix name is unknown: " + prefix));
        return iri + prefixedName.substring(index);
    }

    @Override
    public String getDefaultIriPrefix() {
        return this.getIriDefinition(":").orElseThrow(() -> new InvalidPrefixWritingException("No default prefix"));
    }
}

