/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.vocabulary.OntopInternal;
import it.unibz.inf.ontop.spec.mapping.impl.AbstractPrefixManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SimplePrefixManager
extends AbstractPrefixManager {
    private final ImmutableMap<String, String> uriToPrefixMap;
    private final ImmutableMap<String, String> prefixToURIMap;

    @Inject
    public SimplePrefixManager(@Assisted ImmutableMap<String, String> prefixToURIMap) {
        SimplePrefixManager.checkPrefixToURIMap(prefixToURIMap);
        HashMap<String, String> newPrefixToURIMap = new HashMap<String, String>((Map<String, String>)prefixToURIMap);
        newPrefixToURIMap.putAll(SimplePrefixManager.initKnownPrefixes());
        this.prefixToURIMap = ImmutableMap.copyOf(newPrefixToURIMap);
        this.uriToPrefixMap = SimplePrefixManager.reversePrefixToURI(newPrefixToURIMap);
    }

    private static ImmutableMap<String, String> reversePrefixToURI(Map<String, String> prefixToURIMap) {
        HashMap<String, String> uriToPrefixMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : prefixToURIMap.entrySet()) {
            uriToPrefixMap.put(entry.getValue(), entry.getKey());
        }
        return ImmutableMap.copyOf(uriToPrefixMap);
    }

    private static void checkPrefixToURIMap(Map<String, String> prefixToURIMap) {
        for (Map.Entry<String, String> entry : prefixToURIMap.entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            if (uri == null) {
                throw new NullPointerException("Prefix name must not be null");
            }
            if (prefix.endsWith(":")) continue;
            throw new IllegalArgumentException("Prefix names must end with a colon (:)");
        }
    }

    private static Map<String, String> initKnownPrefixes() {
        HashMap<String, String> prefixToURIMap = new HashMap<String, String>();
        prefixToURIMap.put(OntopInternal.PREFIX_RDF, "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        prefixToURIMap.put(OntopInternal.PREFIX_RDFS, "http://www.w3.org/2000/01/rdf-schema#");
        prefixToURIMap.put(OntopInternal.PREFIX_OWL, "http://www.w3.org/2002/07/owl#");
        prefixToURIMap.put(OntopInternal.PREFIX_XSD, "http://www.w3.org/2001/XMLSchema#");
        prefixToURIMap.put(OntopInternal.PREFIX_OBDA, "https://w3id.org/obda/vocabulary#");
        return prefixToURIMap;
    }

    @Override
    public String getURIDefinition(String prefix) {
        return (String)this.prefixToURIMap.get((Object)prefix);
    }

    @Override
    public Optional<String> getPrefix(String uri) {
        return Optional.ofNullable(this.uriToPrefixMap.get((Object)uri));
    }

    @Override
    public ImmutableMap<String, String> getPrefixMap() {
        return this.prefixToURIMap;
    }

    @Override
    public boolean contains(String prefix) {
        ImmutableSet prefixes = this.prefixToURIMap.keySet();
        return prefixes.contains(prefix);
    }

    @Override
    public List<String> getOrderedNamespaces() {
        ArrayList<String> namespaceList = new ArrayList<String>((Collection<String>)this.getPrefixMap().values());
        Collections.sort(namespaceList, Collections.reverseOrder());
        return namespaceList;
    }
}

