/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import it.unibz.inf.ontop.exception.InvalidPrefixWritingException;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import java.util.List;

public abstract class AbstractPrefixManager
implements PrefixManager {
    public abstract List<String> getOrderedNamespaces();

    @Override
    public String getShortForm(String uri) {
        return this.getShortForm(uri, false);
    }

    @Override
    public String getShortForm(String originalUri, boolean insideQuotes) {
        List<String> namespaceList = this.getOrderedNamespaces();
        String cleanUri = originalUri;
        if (originalUri.contains("<") && originalUri.contains(">")) {
            cleanUri = originalUri.replace("<", "").replace(">", "");
        }
        for (String prefixUriDefinition : namespaceList) {
            if (!cleanUri.startsWith(prefixUriDefinition)) continue;
            String prefix = this.getPrefix(prefixUriDefinition).orElseThrow(() -> new PrefixManagerException("A prefix is expected"));
            if (insideQuotes) {
                prefix = String.format("&%s;", this.removeColon(prefix));
            }
            return cleanUri.replace(prefixUriDefinition, prefix);
        }
        return originalUri;
    }

    @Override
    public String getExpandForm(String prefixedName) {
        return this.getExpandForm(prefixedName, false);
    }

    @Override
    public String getExpandForm(String prefixedName, boolean insideQuotes) {
        String prefix = "";
        String prefixPlaceHolder = "";
        try {
            if (prefixedName.contains("<\"") && prefixedName.contains("\">")) {
                prefixedName = prefixedName.replace("<\"", "").replace("\">", "");
            }
            if (insideQuotes) {
                int end;
                int start = prefixedName.indexOf("&");
                prefixPlaceHolder = prefixedName.substring(start, (end = prefixedName.indexOf(";")) + 1);
                prefix = prefixPlaceHolder.substring(1, prefixPlaceHolder.length() - 1);
                if (!prefix.equals(":")) {
                    prefix = prefix + ":";
                }
            } else {
                int index = prefixedName.indexOf(":");
                prefixPlaceHolder = prefixedName.substring(0, index);
                prefix = prefixPlaceHolder + ":";
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new InvalidPrefixWritingException();
        }
        String uri = this.getURIDefinition(prefix);
        if (uri == null) {
            throw new InvalidPrefixWritingException("The prefix name is unknown: " + prefix);
        }
        return prefixedName.replaceFirst(prefix, uri);
    }

    @Override
    public String getDefaultPrefix() {
        return (String)this.getPrefixMap().get((Object)":");
    }

    private String removeColon(String prefix) {
        if (prefix.equals(":")) {
            return prefix;
        }
        return prefix.replace(":", "");
    }

    private static class PrefixManagerException
    extends OntopInternalBugException {
        private PrefixManagerException(String msg) {
            super(msg);
        }
    }
}

