/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.exception.OBDASpecificationException;
import it.unibz.inf.ontop.injection.OntopModelConfiguration;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.OntopOBDAConfiguration;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.injection.impl.OntopModelConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopOBDAModule;
import it.unibz.inf.ontop.spec.OBDASpecification;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class OntopOBDAConfigurationImpl
extends OntopModelConfigurationImpl
implements OntopOBDAConfiguration {
    private final OntopOBDASettings settings;
    private final OntopOBDAOptions options;

    OntopOBDAConfigurationImpl(OntopOBDASettings settings, OntopOBDAOptions options) {
        super((OntopModelSettings)settings, options.modelOptions);
        this.settings = settings;
        this.options = options;
    }

    OntopOBDAConfigurationImpl(OntopOBDASettings settings, OntopOBDAOptions options, Supplier<Injector> injectorSupplier) {
        super((OntopModelSettings)settings, options.modelOptions, injectorSupplier);
        this.settings = settings;
        this.options = options;
    }

    @Override
    public OntopOBDASettings getSettings() {
        return this.settings;
    }

    @Override
    public final OBDASpecification loadSpecification() throws OBDASpecificationException {
        if (this.options.optionalSpecification.isPresent()) {
            return this.options.optionalSpecification.get();
        }
        return this.loadOBDASpecification();
    }

    protected abstract OBDASpecification loadOBDASpecification() throws OBDASpecificationException;

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopOBDAModule(this)));
    }

    @Override
    public SpecificationFactory getSpecificationFactory() {
        return (SpecificationFactory)this.getInjector().getInstance(SpecificationFactory.class);
    }

    static abstract class OntopOBDAConfigurationBuilderMixin<B extends OntopOBDAConfiguration.Builder<B>>
    implements OntopOBDAConfiguration.Builder<B> {
        private final DefaultOntopOBDABuilderFragment<B> localBuilderFragment = new DefaultOntopOBDABuilderFragment<OntopOBDAConfigurationBuilderMixin>(this, this::declareOBDASpecificationAssigned);
        private final OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B> modelBuilderFragment = new OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment((OntopModelConfiguration.Builder)this);

        OntopOBDAConfigurationBuilderMixin() {
        }

        @Override
        public B obdaSpecification(OBDASpecification specification) {
            return this.localBuilderFragment.obdaSpecification(specification);
        }

        @Override
        public B sameAsMappings(boolean enable) {
            return this.localBuilderFragment.sameAsMappings(enable);
        }

        final OntopOBDAOptions generateOBDAOptions() {
            return this.localBuilderFragment.generateOBDAOptions(this.modelBuilderFragment.generateModelOptions());
        }

        protected Properties generateProperties() {
            Properties properties = this.modelBuilderFragment.generateProperties();
            properties.putAll((Map<?, ?>)this.localBuilderFragment.generateProperties());
            return properties;
        }

        void declareOBDASpecificationAssigned() {
        }

        boolean isOBDASpecificationAssigned() {
            return this.localBuilderFragment.isOBDASpecificationAssigned();
        }
    }

    static class DefaultOntopOBDABuilderFragment<B extends OntopOBDAConfiguration.Builder<B>>
    implements OntopOBDAConfiguration.OntopOBDABuilderFragment<B> {
        private final B builder;
        private final Runnable declareSpecificationCB;
        private Optional<Boolean> sameAsMappings = Optional.empty();
        private Optional<OBDASpecification> specification = Optional.empty();

        DefaultOntopOBDABuilderFragment(B builder, Runnable declareSpecificationCB) {
            this.builder = builder;
            this.declareSpecificationCB = declareSpecificationCB;
        }

        @Override
        public B obdaSpecification(OBDASpecification specification) {
            this.declareSpecificationCB.run();
            this.specification = Optional.of(specification);
            return this.builder;
        }

        @Override
        public B sameAsMappings(boolean sameAsMappings) {
            this.sameAsMappings = Optional.of(sameAsMappings);
            return this.builder;
        }

        Properties generateProperties() {
            Properties p = new Properties();
            this.sameAsMappings.ifPresent(b -> p.put("ontop.sameAs", b));
            return p;
        }

        final OntopOBDAOptions generateOBDAOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions) {
            return new OntopOBDAOptions(modelOptions, this.specification);
        }

        boolean isOBDASpecificationAssigned() {
            return this.specification.isPresent();
        }
    }

    static class OntopOBDAOptions {
        final OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions;
        final Optional<OBDASpecification> optionalSpecification;

        private OntopOBDAOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions, Optional<OBDASpecification> optionalSpecification) {
            this.modelOptions = modelOptions;
            this.optionalSpecification = optionalSpecification;
        }
    }
}

