/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jgrapht.DirectedGraph;

public class GabowSCC<V, E> {
    private final DirectedGraph<V, E> graph;
    private Deque<VertexNumber<V>> stack = new ArrayDeque<VertexNumber<V>>();
    private List<Equivalences<V>> stronglyConnectedSets;
    private Map<V, VertexNumber<V>> vertexToVertexNumber;
    private Deque<Integer> B = new ArrayDeque<Integer>();
    private int c;

    public GabowSCC(DirectedGraph<V, E> directedGraph) {
        assert (directedGraph != null);
        this.graph = directedGraph;
        this.vertexToVertexNumber = null;
        this.stronglyConnectedSets = null;
    }

    public DirectedGraph<V, E> getGraph() {
        return this.graph;
    }

    public boolean isStronglyConnected() {
        return this.stronglyConnectedSets().size() == 1;
    }

    public List<Equivalences<V>> stronglyConnectedSets() {
        if (this.stronglyConnectedSets == null) {
            this.stronglyConnectedSets = new Vector<Equivalences<V>>();
            this.createVertexNumber();
            for (VertexNumber<V> data : this.vertexToVertexNumber.values()) {
                if (data.getNumber() != 0) continue;
                this.dfsVisit(this.graph, data);
            }
            this.vertexToVertexNumber = null;
            this.stack = null;
            this.B = null;
        }
        return this.stronglyConnectedSets;
    }

    private void createVertexNumber() {
        this.c = this.graph.vertexSet().size();
        this.vertexToVertexNumber = new HashMap<V, VertexNumber<V>>(this.c);
        for (Object vertex : this.graph.vertexSet()) {
            this.vertexToVertexNumber.put(vertex, new VertexNumber(vertex, 0));
        }
        this.stack = new ArrayDeque<VertexNumber<V>>(this.c);
        this.B = new ArrayDeque<Integer>(this.c);
    }

    private void dfsVisit(DirectedGraph<V, E> visitedGraph, VertexNumber<V> v) {
        this.stack.add(v);
        this.B.add(v.setNumber(this.stack.size() - 1));
        for (Object edge : visitedGraph.outgoingEdgesOf(v.getVertex())) {
            VertexNumber<V> w = this.vertexToVertexNumber.get(visitedGraph.getEdgeTarget(edge));
            if (w.getNumber() == 0) {
                this.dfsVisit(this.graph, w);
                continue;
            }
            while (w.getNumber() < this.B.getLast()) {
                this.B.removeLast();
            }
        }
        ImmutableSet.Builder L = new ImmutableSet.Builder();
        if (v.getNumber() == this.B.getLast().intValue()) {
            this.B.removeLast();
            ++this.c;
            while (v.getNumber() <= this.stack.size() - 1) {
                VertexNumber<V> r = this.stack.removeLast();
                L.add(r.getVertex());
                r.setNumber(this.c);
            }
            this.stronglyConnectedSets.add(new Equivalences(L.build()));
        }
    }

    private static final class VertexNumber<V> {
        V vertex;
        int number;

        private VertexNumber(V vertex, int number) {
            this.vertex = vertex;
            this.number = number;
        }

        int getNumber() {
            return this.number;
        }

        V getVertex() {
            return this.vertex;
        }

        Integer setNumber(int n) {
            this.number = n;
            return this.number;
        }
    }
}

