/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.SpecificationFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.spec.mapping.MappingMetadata;
import it.unibz.inf.ontop.spec.mapping.impl.NullableVariableInMappingException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

public class MappingImpl
implements Mapping {
    private final MappingMetadata metadata;
    private final ImmutableTable<RDFAtomPredicate, IRI, IQ> propertyDefinitions;
    private final ImmutableTable<RDFAtomPredicate, IRI, IQ> classDefinitions;
    private final SpecificationFactory specificationFactory;
    private final ImmutableSet<RDFAtomPredicate> rdfAtomPredicates;

    @AssistedInject
    private MappingImpl(@Assisted MappingMetadata metadata, @Assisted(value="propertyTable") ImmutableTable<RDFAtomPredicate, IRI, IQ> propertyTable, @Assisted(value="classTable") ImmutableTable<RDFAtomPredicate, IRI, IQ> classTable, OntopModelSettings settings, SpecificationFactory specificationFactory) {
        this.metadata = metadata;
        this.propertyDefinitions = propertyTable;
        this.classDefinitions = classTable;
        this.specificationFactory = specificationFactory;
        if (settings.isTestModeEnabled()) {
            for (IQ query : this.propertyDefinitions.values()) {
                MappingImpl.checkNullableVariables(query);
            }
            for (IQ query : this.classDefinitions.values()) {
                MappingImpl.checkNullableVariables(query);
            }
        }
        this.rdfAtomPredicates = Sets.union((Set)propertyTable.rowKeySet(), (Set)classTable.rowKeySet()).immutableCopy();
    }

    private static void checkNullableVariables(IQ query) throws NullableVariableInMappingException {
        VariableNullability variableNullability = query.getTree().getVariableNullability();
        if (!variableNullability.getNullableGroups().isEmpty()) {
            throw new NullableVariableInMappingException(query, (ImmutableSet<ImmutableSet<Variable>>)variableNullability.getNullableGroups());
        }
    }

    @Override
    public MappingMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Optional<IQ> getRDFPropertyDefinition(RDFAtomPredicate rdfAtomPredicate, IRI propertyIRI) {
        return Optional.ofNullable(this.propertyDefinitions.get((Object)rdfAtomPredicate, (Object)propertyIRI));
    }

    @Override
    public Optional<IQ> getRDFClassDefinition(RDFAtomPredicate rdfAtomPredicate, IRI classIRI) {
        return Optional.ofNullable(this.classDefinitions.get((Object)rdfAtomPredicate, (Object)classIRI));
    }

    @Override
    public ImmutableSet<IRI> getRDFProperties(RDFAtomPredicate rdfAtomPredicate) {
        return Optional.ofNullable(this.propertyDefinitions.rowMap().get((Object)rdfAtomPredicate)).map(m -> ImmutableSet.copyOf(m.keySet())).orElseGet(ImmutableSet::of);
    }

    @Override
    public ImmutableSet<IRI> getRDFClasses(RDFAtomPredicate rdfAtomPredicate) {
        return Optional.ofNullable(this.classDefinitions.rowMap().get((Object)rdfAtomPredicate)).map(m -> ImmutableSet.copyOf(m.keySet())).orElseGet(ImmutableSet::of);
    }

    @Override
    public ImmutableCollection<IQ> getQueries(RDFAtomPredicate rdfAtomPredicate) {
        return (ImmutableCollection)Stream.concat(this.classDefinitions.row((Object)rdfAtomPredicate).values().stream(), this.propertyDefinitions.row((Object)rdfAtomPredicate).values().stream()).collect(ImmutableCollectors.toList());
    }

    @Override
    public ImmutableSet<Table.Cell<RDFAtomPredicate, IRI, IQ>> getRDFPropertyQueries() {
        return this.propertyDefinitions.cellSet();
    }

    @Override
    public ImmutableSet<Table.Cell<RDFAtomPredicate, IRI, IQ>> getRDFClassQueries() {
        return this.classDefinitions.cellSet();
    }

    @Override
    public ImmutableSet<RDFAtomPredicate> getRDFAtomPredicates() {
        return this.rdfAtomPredicates;
    }

    @Override
    public Mapping update(ImmutableTable<RDFAtomPredicate, IRI, IQ> propertyUpdateTable, ImmutableTable<RDFAtomPredicate, IRI, IQ> classUpdateTable) {
        ImmutableTable<RDFAtomPredicate, IRI, IQ> newPropertyDefs = propertyUpdateTable.isEmpty() ? this.propertyDefinitions : this.updateDefinitions(this.propertyDefinitions, propertyUpdateTable);
        ImmutableTable<RDFAtomPredicate, IRI, IQ> newTripleClassDefs = classUpdateTable.isEmpty() ? this.classDefinitions : this.updateDefinitions(this.classDefinitions, classUpdateTable);
        return this.specificationFactory.createMapping(this.metadata, newPropertyDefs, newTripleClassDefs);
    }

    private ImmutableTable<RDFAtomPredicate, IRI, IQ> updateDefinitions(ImmutableTable<RDFAtomPredicate, IRI, IQ> currentTable, ImmutableTable<RDFAtomPredicate, IRI, IQ> updateTable) {
        return (ImmutableTable)Stream.concat(updateTable.cellSet().stream(), currentTable.cellSet().stream().filter(c -> !updateTable.contains(c.getRowKey(), c.getColumnKey()))).collect(ImmutableCollectors.toTable());
    }
}

