/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import it.unibz.inf.ontop.com.google.common.base.Joiner;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.substitution.impl.AbstractImmutableSubstitutionImpl;
import java.util.Map;

public class Var2VarSubstitutionImpl
extends AbstractImmutableSubstitutionImpl<Variable>
implements Var2VarSubstitution {
    private final ImmutableMap<Variable, Variable> map;

    protected Var2VarSubstitutionImpl(ImmutableMap<Variable, ? extends Variable> substitutionMap, AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(atomFactory, termFactory, substitutionFactory);
        this.map = substitutionMap;
    }

    @Override
    public Variable applyToVariable(Variable variable) {
        Variable r = (Variable)this.map.get((Object)variable);
        return r == null ? variable : r;
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> applyToTarget(ImmutableSubstitution<T> otherSubstitution) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry otherEntry : otherSubstitution.getImmutableMap().entrySet()) {
            ImmutableTerm newValue = this.applyToTerm((ImmutableTerm)otherEntry.getValue());
            if (((Variable)otherEntry.getKey()).equals(newValue)) continue;
            mapBuilder.put(otherEntry.getKey(), (Object)newValue);
        }
        return this.substitutionFactory.getSubstitution(mapBuilder.build());
    }

    @Override
    public Variable get(Variable var) {
        return (Variable)this.map.get((Object)var);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public String toString() {
        return Joiner.on((String)", ").withKeyValueSeparator("/").join(this.map);
    }

    @Override
    public ImmutableMap<Variable, Variable> getImmutableMap() {
        return this.map;
    }

    @Override
    public boolean isDefining(Variable variable) {
        return this.map.containsKey((Object)variable);
    }

    @Override
    public ImmutableSet<Variable> getDomain() {
        return this.map.keySet();
    }

    @Override
    protected ImmutableSubstitution<Variable> constructNewSubstitution(ImmutableMap<Variable, Variable> map) {
        return this.substitutionFactory.getVar2VarSubstitution(map);
    }

    @Override
    public NonGroundTerm applyToNonGroundTerm(NonGroundTerm term) {
        if (term instanceof Variable) {
            return this.applyToVariable((Variable)term);
        }
        return (NonGroundTerm)((Object)this.applyToFunctionalTerm((ImmutableFunctionalTerm)((Object)term)));
    }

    @Override
    public <T extends ImmutableTerm> T applyToTerm(T term) {
        return (T)super.apply(term);
    }
}

