/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.ConversionException;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.Var2VarSubstitutionImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class InjectiveVar2VarSubstitutionImpl
extends Var2VarSubstitutionImpl
implements InjectiveVar2VarSubstitution {
    protected InjectiveVar2VarSubstitutionImpl(ImmutableMap<Variable, Variable> substitutionMap, AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(substitutionMap, atomFactory, termFactory, substitutionFactory);
        if (!InjectiveVar2VarSubstitutionImpl.isInjective(substitutionMap)) {
            throw new IllegalArgumentException("Non-injective map given: " + substitutionMap);
        }
    }

    @Override
    public <T extends ImmutableTerm> ImmutableSubstitution<T> applyRenaming(ImmutableSubstitution<T> substitutionToRename) {
        if (this.isEmpty()) {
            return substitutionToRename;
        }
        ImmutableMap substitutionMap = substitutionToRename.getImmutableMap().entrySet().stream().map(e -> Maps.immutableEntry((Object)this.applyToVariable((Variable)e.getKey()), (Object)this.applyToTerm((ImmutableTerm)e.getValue()))).filter(e -> !((ImmutableTerm)e.getValue()).equals(e.getKey())).collect(ImmutableCollectors.toMap());
        return this.substitutionFactory.getSubstitution(substitutionMap);
    }

    @Override
    public DistinctVariableOnlyDataAtom applyToDistinctVariableOnlyDataAtom(DistinctVariableOnlyDataAtom dataAtom) throws ConversionException {
        ImmutableList<ImmutableTerm> newArguments = this.apply(dataAtom.getArguments());
        return this.atomFactory.getDistinctVariableOnlyDataAtom((AtomPredicate)dataAtom.getPredicate(), (ImmutableList<Variable>)newArguments);
    }

    @Override
    public Optional<InjectiveVar2VarSubstitution> composeWithAndPreserveInjectivity(InjectiveVar2VarSubstitution g, Set<Variable> variablesToExcludeFromTheDomain) {
        ImmutableSet<Variable> gDomain = g.getDomain();
        Stream<Map.Entry> gEntryStream = g.getImmutableMap().entrySet().stream().map(e1 -> Maps.immutableEntry(e1.getKey(), (Object)this.applyToVariable((Variable)e1.getValue())));
        Stream<Map.Entry> localEntryStream = this.getImmutableMap().entrySet().stream().filter(e -> !gDomain.contains(e.getKey()));
        ImmutableMap newMap = Stream.concat(gEntryStream, localEntryStream).filter(e -> !((Variable)e.getKey()).equals(e.getValue())).filter(e -> !variablesToExcludeFromTheDomain.contains(e.getKey())).collect(ImmutableCollectors.toMap());
        return Optional.of(newMap).filter(InjectiveVar2VarSubstitutionImpl::isInjective).map(this.substitutionFactory::getInjectiveVar2VarSubstitution);
    }

    @Override
    public InjectiveVar2VarSubstitution reduceDomainToIntersectionWith(ImmutableSet<Variable> restrictingDomain) {
        if (restrictingDomain.containsAll(this.getDomain())) {
            return this;
        }
        return this.substitutionFactory.getInjectiveVar2VarSubstitution(this.getImmutableMap().entrySet().stream().filter(e -> restrictingDomain.contains(e.getKey())).collect(ImmutableCollectors.toMap()));
    }

    private static boolean isInjective(ImmutableMap<Variable, ? extends VariableOrGroundTerm> substitutionMap) {
        ImmutableSet valueSet = ImmutableSet.copyOf((Collection)substitutionMap.values());
        return valueSet.size() == substitutionMap.keySet().size();
    }
}

