/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.substitution.ProtoSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;

public abstract class AbstractProtoSubstitution<T extends ImmutableTerm>
implements ProtoSubstitution<T> {
    protected final TermFactory termFactory;

    protected AbstractProtoSubstitution(TermFactory termFactory) {
        this.termFactory = termFactory;
    }

    @Override
    public ImmutableTerm apply(ImmutableTerm term) {
        if (term instanceof Constant) {
            return term;
        }
        if (term instanceof Variable) {
            return this.applyToVariable((Variable)term);
        }
        if (term instanceof ImmutableFunctionalTerm) {
            return this.applyToFunctionalTerm((ImmutableFunctionalTerm)term);
        }
        throw new IllegalArgumentException("Unexpected kind of term: " + term.getClass());
    }

    @Override
    public ImmutableFunctionalTerm applyToFunctionalTerm(ImmutableFunctionalTerm functionalTerm) {
        if (this.isEmpty()) {
            return functionalTerm;
        }
        ImmutableList<ImmutableTerm> subTerms = this.apply(functionalTerm.getTerms());
        FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
        return functionSymbol instanceof BooleanFunctionSymbol ? this.termFactory.getImmutableExpression((BooleanFunctionSymbol)functionSymbol, subTerms) : this.termFactory.getImmutableFunctionalTerm(functionSymbol, subTerms);
    }

    @Override
    public ImmutableExpression applyToBooleanExpression(ImmutableExpression booleanExpression) {
        if (this.isEmpty()) {
            return booleanExpression;
        }
        return this.termFactory.getImmutableExpression(booleanExpression.getFunctionSymbol(), this.apply(booleanExpression.getTerms()));
    }

    @Override
    public ImmutableList<ImmutableTerm> apply(ImmutableList<? extends ImmutableTerm> terms) {
        return (ImmutableList)terms.stream().map(this::apply).collect(ImmutableCollectors.toList());
    }
}

