/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.exception.ConversionException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.ProtoSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.Var2VarSubstitution;
import it.unibz.inf.ontop.substitution.impl.AbstractProtoSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public abstract class AbstractImmutableSubstitutionImpl<T extends ImmutableTerm>
extends AbstractProtoSubstitution<T>
implements ImmutableSubstitution<T> {
    final AtomFactory atomFactory;
    final SubstitutionFactory substitutionFactory;

    protected AbstractImmutableSubstitutionImpl(AtomFactory atomFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(termFactory);
        this.atomFactory = atomFactory;
        this.substitutionFactory = substitutionFactory;
    }

    @Override
    public <P extends AtomPredicate> DataAtom<P> applyToDataAtom(DataAtom<P> atom) throws ConversionException {
        ImmutableList<ImmutableTerm> newArguments = this.apply(atom.getArguments());
        if (!newArguments.stream().allMatch(t -> t instanceof VariableOrGroundTerm)) {
            throw new ConversionException("The substitution applied to a DataAtom has  produced some non-VariableOrGroundTerm arguments " + newArguments);
        }
        return this.atomFactory.getDataAtom(atom.getPredicate(), (ImmutableList<? extends VariableOrGroundTerm>)newArguments);
    }

    @Override
    public ImmutableMap<Integer, ? extends VariableOrGroundTerm> applyToArgumentMap(ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap) throws ConversionException {
        ImmutableMap<Integer, ImmutableTerm> newArgumentMap = argumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.apply((ImmutableTerm)e.getValue())));
        if (!newArgumentMap.values().stream().allMatch(t -> t instanceof VariableOrGroundTerm)) {
            throw new ConversionException("The substitution applied to an argument map has  produced some non-VariableOrGroundTerm arguments " + newArgumentMap);
        }
        return newArgumentMap;
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> composeWith(ImmutableSubstitution<? extends ImmutableTerm> f) {
        if (this.isEmpty()) {
            return f;
        }
        if (f.isEmpty()) {
            return this;
        }
        return this.substitutionFactory.getSubstitution(Stream.concat(f.getImmutableMap().entrySet().stream().map(e -> Maps.immutableEntry(e.getKey(), (Object)this.apply((ImmutableTerm)e.getValue()))), this.getImmutableMap().entrySet().stream()).filter(e -> !((Variable)e.getKey()).equals(e.getValue())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (vf, v) -> vf)));
    }

    @Override
    public ImmutableSubstitution<T> composeWith2(ImmutableSubstitution<? extends T> g) {
        return this.composeWith(g);
    }

    @Override
    public Optional<ImmutableSubstitution<T>> union(ImmutableSubstitution<T> otherSubstitution) {
        if (otherSubstitution.isEmpty()) {
            return Optional.of(this);
        }
        if (this.isEmpty()) {
            return Optional.of(otherSubstitution);
        }
        try {
            ImmutableMap<Variable, ImmutableTerm> map = Stream.of(this, otherSubstitution).map(ProtoSubstitution::getImmutableMap).map(ImmutableMap::entrySet).flatMap(Collection::stream).collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
                if (!v1.equals(v2)) {
                    throw new NotASubstitutionException();
                }
                return v1;
            }));
            return Optional.of(this.substitutionFactory.getSubstitution(map));
        }
        catch (NotASubstitutionException e) {
            return Optional.empty();
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ImmutableSubstitution) {
            return this.getImmutableMap().equals(((ImmutableSubstitution)other).getImmutableMap());
        }
        return false;
    }

    protected abstract ImmutableSubstitution<T> constructNewSubstitution(ImmutableMap<Variable, T> var1);

    @Override
    public ImmutableSubstitution<T> orientate(ImmutableList<Variable> priorityVariables) {
        if (priorityVariables.isEmpty() || this.isEmpty()) {
            return this;
        }
        ImmutableMap localMap = this.getImmutableMap();
        ImmutableSet<Variable> domain = this.getDomain();
        if (localMap.values().stream().flatMap(ImmutableTerm::getVariableStream).anyMatch(arg_0 -> domain.contains(arg_0))) {
            throw new UnsupportedOperationException("The orientate() method requires the domain and the range to be disjoint");
        }
        ImmutableMap<Variable, Variable> renamingMap = localMap.entrySet().stream().filter(e -> e.getValue() instanceof Variable).filter(e -> {
            int replacedVariableIndex = priorityVariables.indexOf(e.getKey());
            int targetVariableIndex = priorityVariables.indexOf(e.getValue());
            return replacedVariableIndex >= 0 && (targetVariableIndex < 0 || replacedVariableIndex < targetVariableIndex);
        }).collect(ImmutableCollectors.toMap(e -> (Variable)e.getValue(), Map.Entry::getKey, (v1, v2) -> priorityVariables.indexOf(v1) <= priorityVariables.indexOf(v2) ? v1 : v2));
        if (renamingMap.isEmpty()) {
            return this;
        }
        Var2VarSubstitution renamingSubstitution = this.substitutionFactory.getVar2VarSubstitution(renamingMap);
        ImmutableMap<Variable, ImmutableTerm> orientedMap = Stream.concat(localMap.entrySet().stream().filter(e -> !Optional.ofNullable(renamingMap.get(e.getValue())).filter(newValue -> newValue.equals(e.getKey())).isPresent()), renamingMap.entrySet().stream().map(e -> e)).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> renamingSubstitution.applyToTerm((ImmutableTerm)e.getValue())));
        return this.constructNewSubstitution(orientedMap);
    }

    @Override
    public ImmutableSubstitution<T> reduceDomainToIntersectionWith(ImmutableSet<Variable> restrictingDomain) {
        if (restrictingDomain.containsAll(this.getDomain())) {
            return this;
        }
        return this.substitutionFactory.getSubstitution(this.getImmutableMap().entrySet().stream().filter(e -> restrictingDomain.contains(e.getKey())).collect(ImmutableCollectors.toMap()));
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> simplifyValues(VariableNullability variableNullability) {
        return this.simplifyValues(Optional.of(variableNullability));
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> simplifyValues() {
        return this.simplifyValues(Optional.empty());
    }

    private ImmutableSubstitution<ImmutableTerm> simplifyValues(Optional<VariableNullability> variableNullability) {
        return this.substitutionFactory.getSubstitution(this.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> variableNullability.map(n -> ((ImmutableTerm)e.getValue()).simplify((VariableNullability)n)).orElseGet(() -> ((ImmutableTerm)e.getValue()).simplify()))));
    }

    @Override
    public <S extends ImmutableTerm> ImmutableSubstitution<S> getFragment(Class<S> type) {
        ImmutableMap<Variable, ImmutableTerm> newMap = this.getImmutableMap().entrySet().stream().filter(e -> type.isInstance(e.getValue())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (ImmutableTerm)type.cast(e.getValue())));
        return this.substitutionFactory.getSubstitution(newMap);
    }

    private static class NotASubstitutionException
    extends RuntimeException {
        private NotASubstitutionException() {
        }
    }
}

