/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.OntopInternalBugException;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.impl.TermTypeHierarchyImpl;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.Stream;

public class TermTypeAncestryImpl
extends TermTypeHierarchyImpl<TermType>
implements TermTypeAncestry {
    protected TermTypeAncestryImpl(TermType origin) {
        this((ImmutableList<TermType>)ImmutableList.of((Object)origin));
    }

    private TermTypeAncestryImpl(ImmutableList<TermType> newAncestors) {
        super(newAncestors);
    }

    @Override
    public TermType getClosestCommonAncestor(TermTypeAncestry otherAncestry) {
        return this.getClosestCommonTermType(otherAncestry).orElseThrow(() -> new DifferentTermTypeOriginException());
    }

    @Override
    public TermTypeAncestry newAncestry(TermType childType) {
        ImmutableList newAncestors = (ImmutableList)Stream.concat(Stream.of(childType), this.getTermTypes()).collect(ImmutableCollectors.toList());
        return new TermTypeAncestryImpl((ImmutableList<TermType>)newAncestors);
    }

    private static class DifferentTermTypeOriginException
    extends OntopInternalBugException {
        private DifferentTermTypeOriginException() {
            super("Internal bug: all all the term types must have the same origin");
        }
    }
}

