/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import java.util.Optional;

public class MockupDBTypeFactory
implements DBTypeFactory {
    private final NonStringNonNumberNonBooleanNonDatetimeDBTermType rootDBType;
    private final TermTypeAncestry rootAncestry;

    @AssistedInject
    private MockupDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        this.rootDBType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType("AbstractDBType", rootTermType.getAncestry(), true);
        this.rootAncestry = this.rootDBType.getAncestry();
    }

    @Override
    public DBTermType getDBStringType() {
        return this.getDBTermType("STRING");
    }

    @Override
    public DBTermType getDBLargeIntegerType() {
        return this.getDBTermType("LARGE_INT");
    }

    @Override
    public DBTermType getDBDecimalType() {
        return this.getDBTermType("DEC");
    }

    @Override
    public DBTermType getDBBooleanType() {
        return this.getDBTermType("BOOL");
    }

    @Override
    public DBTermType getDBDateType() {
        return this.getDBTermType("DATE");
    }

    @Override
    public DBTermType getDBTimeType() {
        return this.getDBTermType("TIME");
    }

    @Override
    public DBTermType getDBDateTimestampType() {
        return this.getDBTermType("TIMESTAMP");
    }

    @Override
    public DBTermType getDBDoubleType() {
        return this.getDBTermType("DOUBLE");
    }

    @Override
    public DBTermType getDBGeometryType() {
        return this.getDBTermType("GEOMETRY");
    }

    @Override
    public DBTermType getDBGeographyType() {
        return this.getDBTermType("GEOGRAPHY");
    }

    @Override
    public boolean supportsDBGeometryType() {
        return false;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return false;
    }

    @Override
    public DBTermType getDBHexBinaryType() {
        return this.getDBTermType("HEXBINARY");
    }

    @Override
    public DBTermType getAbstractRootDBType() {
        return this.rootDBType;
    }

    @Override
    public DBTermType getDBTermType(String typeName) {
        return new NonStringNonNumberNonBooleanNonDatetimeDBTermType(typeName, this.rootAncestry, false);
    }

    @Override
    public DBTermType getDBTermType(String typeName, int columnSize) {
        return new NonStringNonNumberNonBooleanNonDatetimeDBTermType(typeName, this.rootAncestry, false);
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "TRUE";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "FALSE";
    }

    @Override
    public String getNullLexicalValue() {
        return "NULL";
    }

    @Override
    public Optional<String> getDBNaNLexicalValue() {
        return Optional.of("NaN");
    }
}

