/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.impl;

import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import java.util.Collection;

public class GroundTermTools {
    public static VariableOrGroundTerm convertIntoVariableOrGroundTerm(ImmutableTerm term) {
        if (term instanceof Variable) {
            return (Variable)term;
        }
        if (term.isGround()) {
            return (GroundTerm)term;
        }
        throw new IllegalArgumentException("Not a variable nor a ground term: " + term);
    }

    public static boolean areGroundTerms(Collection<? extends ImmutableTerm> terms) {
        return terms.stream().allMatch(ImmutableTerm::isGround);
    }

    public static void checkNonGroundTermConstraint(NonGroundFunctionalTerm term) throws IllegalArgumentException {
        if (term.getVariables().isEmpty()) {
            throw new IllegalArgumentException("A NonGroundFunctionalTerm must contain at least one variable: " + term);
        }
    }
}

