/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl.geof;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBMathBinaryOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.AbstractGeofWKTFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.DistanceUnit;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeoUtils;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.WKTLiteralValue;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;

public class GeofBufferFunctionSymbolImpl
extends AbstractGeofWKTFunctionSymbolImpl {
    public GeofBufferFunctionSymbolImpl(@Nonnull IRI functionIRI, RDFDatatype wktLiteralType, RDFDatatype decimalType, ObjectRDFType iriType) {
        super("GEOF_BUFFER", functionIRI, (ImmutableList<TermType>)ImmutableList.of((Object)wktLiteralType, (Object)decimalType, (Object)iriType), wktLiteralType);
    }

    @Override
    protected ImmutableTerm computeDBTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory) {
        ImmutableTerm term = (ImmutableTerm)subLexicalTerms.get(0);
        WKTLiteralValue wktLiteralValue = GeoUtils.extractWKTLiteralValue(termFactory, term);
        DistanceUnit inputUnit = GeoUtils.getUnitFromSRID(wktLiteralValue.getSRID().getIRIString());
        ImmutableTerm distance = (ImmutableTerm)subLexicalTerms.get(1);
        DistanceUnit distanceUnit = DistanceUnit.findByIRI(((DBConstant)subLexicalTerms.get(2)).getValue());
        DBFunctionSymbolFactory dbFunctionSymbolFactory = termFactory.getDBFunctionSymbolFactory();
        DBTypeFactory dbTypeFactory = termFactory.getTypeFactory().getDBTypeFactory();
        DBMathBinaryOperator times = dbFunctionSymbolFactory.getDBMathBinaryOperator("*", dbTypeFactory.getDBDoubleType());
        ImmutableTerm geom = wktLiteralValue.getGeometry();
        if (inputUnit == DistanceUnit.DEGREE && distanceUnit == DistanceUnit.METRE) {
            if (dbTypeFactory.supportsDBGeographyType()) {
                return termFactory.getDBAsText(termFactory.getDBBuffer(termFactory.getDBCastFunctionalTerm(dbTypeFactory.getDBGeographyType(), geom), distance)).simplify();
            }
            double EARTH_MEAN_RADIUS_METER = 6370986.0;
            double ratio = 8.993235821438366E-6;
            DBConstant ratioConstant = termFactory.getDBConstant(String.valueOf(8.993235821438366E-6), dbTypeFactory.getDBDoubleType());
            ImmutableFunctionalTerm distanceInDegree = termFactory.getImmutableFunctionalTerm((FunctionSymbol)times, distance, ratioConstant);
            return termFactory.getDBAsText(termFactory.getDBBuffer(geom, distanceInDegree)).simplify();
        }
        if (inputUnit == DistanceUnit.DEGREE && distanceUnit == DistanceUnit.DEGREE) {
            return termFactory.getDBAsText(termFactory.getDBBuffer(geom, distance)).simplify();
        }
        if (inputUnit == DistanceUnit.DEGREE && distanceUnit == DistanceUnit.RADIAN) {
            double ratio = 57.29577951308232;
            DBConstant ratioConstant = termFactory.getDBConstant(String.valueOf(57.29577951308232), dbTypeFactory.getDBDoubleType());
            ImmutableFunctionalTerm distanceInDegree = termFactory.getImmutableFunctionalTerm((FunctionSymbol)times, distance, ratioConstant);
            return termFactory.getDBAsText(termFactory.getDBBuffer(geom, distanceInDegree)).simplify();
        }
        if (inputUnit == DistanceUnit.METRE && distanceUnit == DistanceUnit.METRE) {
            return termFactory.getDBAsText(termFactory.getDBBuffer(geom, distance)).simplify();
        }
        throw new IllegalArgumentException(String.format("Unsupported unit combination for geof:buffer. inputUnit=%s, outputUnit=%s ", new Object[]{inputUnit, distanceUnit}));
    }
}

