/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl.geof;

import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.DistanceUnit;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.WKTLiteralValue;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.simple.SimpleRDF;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.units.Unit;

public class GeoUtils {
    static final double EARTH_MEAN_RADIUS_METER = 6370986.0;
    private static final RDF rdfFactory = new SimpleRDF();
    public static final IRI defaultSRID = rdfFactory.createIRI("http://www.opengis.net/def/crs/OGC/1.3/CRS84");

    static Optional<ImmutableTerm> tryExtractGeometryFromConstant(ImmutableTerm immutableTerm, TermFactory termFactory) {
        return Optional.of(immutableTerm).filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).filter(v -> v.startsWith("<") && v.indexOf(">") > 0).map(v -> termFactory.getDBStringConstant(v.substring(v.indexOf(">") + 1).trim()));
    }

    static Optional<ImmutableTerm> tryExtractArgFromTemplate(ImmutableTerm term, int index) {
        return Optional.of(term).filter(t -> t instanceof NonGroundFunctionalTerm).map(t -> (NonGroundFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBConcatFunctionSymbol).map(t -> t.getTerm(index));
    }

    static Optional<IRI> tryExtractSRIDFromDbConstant(Optional<ImmutableTerm> immutableTerm) {
        return immutableTerm.filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).filter(v -> v.startsWith("<") && v.indexOf(">") > 0).map(v -> v.substring(1, v.indexOf(">"))).map(arg_0 -> ((RDF)rdfFactory).createIRI(arg_0));
    }

    static WKTLiteralValue extractWKTLiteralValue(TermFactory termFactory, ImmutableTerm wktLiteralTerm) {
        IRI srid = GeoUtils.tryExtractSRIDFromDbConstant(Optional.of(wktLiteralTerm)).orElseGet(() -> GeoUtils.tryExtractSRIDFromDbConstant(GeoUtils.tryExtractArgFromTemplate(wktLiteralTerm, 0)).orElse(defaultSRID));
        ImmutableTerm geometry = GeoUtils.tryExtractGeometryFromConstant(wktLiteralTerm, termFactory).orElseGet(() -> GeoUtils.tryExtractArgFromTemplate(wktLiteralTerm, 1).orElse(wktLiteralTerm));
        return new WKTLiteralValue(srid, geometry);
    }

    public static String toProj4jName(String sridIRIString) {
        String CRS_PREFIX = "http://www.opengis.net/def/crs/OGC/1.3/CRS";
        String EPSG_PREFIX = "http://www.opengis.net/def/crs/EPSG/0/";
        if (sridIRIString.startsWith("http://www.opengis.net/def/crs/OGC/1.3/CRS")) {
            return "CRS:" + sridIRIString.substring("http://www.opengis.net/def/crs/OGC/1.3/CRS".length());
        }
        if (sridIRIString.startsWith("http://www.opengis.net/def/crs/EPSG/0/")) {
            return "EPSG:" + sridIRIString.substring("http://www.opengis.net/def/crs/EPSG/0/".length());
        }
        throw new IllegalArgumentException("Unknown SRID IRI: " + sridIRIString);
    }

    public static DistanceUnit getUnitFromSRID(String sridIRIString) {
        String csName = GeoUtils.toProj4jName(sridIRIString);
        if (csName.equals("CRS:84")) {
            return DistanceUnit.DEGREE;
        }
        if (csName.startsWith("CRS:")) {
            throw new IllegalArgumentException("Unknown SRID IRI: " + sridIRIString);
        }
        CRSFactory csFactory = new CRSFactory();
        CoordinateReferenceSystem crs = csFactory.createFromName(csName);
        Unit proj4JUnit = crs.getProjection().getUnits();
        return DistanceUnit.findByName(proj4JUnit.name);
    }
}

