/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableBiMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.BooleanFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.util.Optional;
import java.util.stream.Stream;

public class LexicalEBVFunctionSymbolImpl
extends BooleanFunctionSymbolImpl {
    protected LexicalEBVFunctionSymbolImpl(DBTermType dbStringType, MetaRDFTermType metaRDFTermType, DBTermType dbBooleanTermType) {
        super("LEX_EBV", (ImmutableList<TermType>)ImmutableList.of((Object)dbStringType, (Object)metaRDFTermType), dbBooleanTermType);
    }

    @Override
    public boolean blocksNegation() {
        return true;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return true;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm lexicalTerm = (ImmutableTerm)newTerms.get(0);
        ImmutableTerm typeTerm = (ImmutableTerm)newTerms.get(1);
        if (typeTerm instanceof RDFTermTypeConstant) {
            RDFTermType rdfTermType = ((RDFTermTypeConstant)typeTerm).getRDFTermType();
            return this.computeEBV(lexicalTerm, rdfTermType, termFactory).simplify(variableNullability);
        }
        if (typeTerm instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTypeTerm = (ImmutableFunctionalTerm)typeTerm;
            FunctionSymbol functionSymbol = functionalTypeTerm.getFunctionSymbol();
            if (functionSymbol instanceof RDFTermTypeFunctionSymbol) {
                ImmutableBiMap<DBConstant, RDFTermTypeConstant> conversionMap = ((RDFTermTypeFunctionSymbol)functionalTypeTerm.getFunctionSymbol()).getConversionMap();
                ImmutableTerm magicNumberTerm = functionalTypeTerm.getTerm(0);
                return termFactory.getDisjunction(Stream.concat(conversionMap.entrySet().stream().map(e -> termFactory.getConjunction(termFactory.getStrictEquality(magicNumberTerm, (ImmutableTerm)e.getKey(), new ImmutableTerm[0]), termFactory.getImmutableExpression((BooleanFunctionSymbol)this, lexicalTerm, (ImmutableTerm)e.getValue()))), Stream.of(termFactory.getFalseOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)ImmutableList.of((Object)termFactory.getDBIsNull(magicNumberTerm)))))).orElseThrow(() -> new MinorOntopInternalBugException("Unexpected empty disjunction")).simplify(variableNullability);
            }
            if (functionSymbol instanceof DBIfElseNullFunctionSymbol) {
                ImmutableExpression condition = Optional.of(functionalTypeTerm.getTerm(0)).filter(t -> t instanceof ImmutableExpression).map(t -> (ImmutableExpression)t).orElseThrow(() -> new MinorOntopInternalBugException("The first argument of a IF_ELSE_NULL must be an expression"));
                return termFactory.getIfElseNull(condition, termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, lexicalTerm, functionalTypeTerm.getTerm(1))).simplify(variableNullability);
            }
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    private ImmutableTerm computeEBV(ImmutableTerm lexicalTerm, RDFTermType rdfTermType, TermFactory termFactory) {
        TypeFactory typeFactory = termFactory.getTypeFactory();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        RDFDatatype abstractNumeric = typeFactory.getAbstractOntopNumericDatatype();
        ConcreteNumericRDFDatatype xsdFloat = typeFactory.getXsdFloatDatatype();
        ConcreteNumericRDFDatatype xsdDouble = typeFactory.getXsdDoubleDatatype();
        RDFDatatype xsdBoolean = typeFactory.getXsdBooleanDatatype();
        if (rdfTermType.isA(xsdString)) {
            return this.computeStringEBV(lexicalTerm, termFactory);
        }
        if (rdfTermType.isA(xsdFloat) || rdfTermType.isA(xsdDouble)) {
            return this.computeFloatOrDoubleEBV(lexicalTerm, rdfTermType, termFactory);
        }
        if (rdfTermType.isA(abstractNumeric)) {
            return this.computeOtherNumericEBV(lexicalTerm, rdfTermType, termFactory);
        }
        if (rdfTermType.isA(xsdBoolean)) {
            return this.computeBooleanEBV(lexicalTerm, rdfTermType, termFactory);
        }
        return termFactory.getNullConstant();
    }

    private ImmutableTerm computeStringEBV(ImmutableTerm lexicalConstant, TermFactory termFactory) {
        return termFactory.getDBNot(termFactory.getDBIsStringEmpty(lexicalConstant));
    }

    private ImmutableExpression computeFloatOrDoubleEBV(ImmutableTerm lexicalConstant, RDFTermType rdfTermType, TermFactory termFactory) {
        ImmutableFunctionalTerm dbNumericTerm = termFactory.getConversionFromRDFLexical2DB(lexicalConstant, rdfTermType);
        ImmutableExpression standardNumericEBVCondition = this.computeOtherNumericEBV(lexicalConstant, rdfTermType, termFactory);
        return termFactory.getDoubleNaN().map(nan -> termFactory.getDBNonStrictNumericEquality(dbNumericTerm, (ImmutableTerm)nan)).map(notANumberCondition -> termFactory.getConjunction(standardNumericEBVCondition, termFactory.getDBNot((ImmutableExpression)notANumberCondition))).orElse(standardNumericEBVCondition);
    }

    private ImmutableExpression computeOtherNumericEBV(ImmutableTerm lexicalConstant, RDFTermType rdfTermType, TermFactory termFactory) {
        ImmutableFunctionalTerm dbNumericTerm = termFactory.getConversionFromRDFLexical2DB(lexicalConstant, rdfTermType);
        return termFactory.getDBNot(termFactory.getDBNonStrictNumericEquality(dbNumericTerm, termFactory.getDBIntegerConstant(0)));
    }

    private ImmutableTerm computeBooleanEBV(ImmutableTerm lexicalConstant, RDFTermType rdfTermType, TermFactory termFactory) {
        return termFactory.getConversionFromRDFLexical2DB(lexicalConstant, rdfTermType);
    }
}

