/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.request.DefinitionPushDownRequest;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.UnaryNumericSPARQLAggregationFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class AvgSPARQLFunctionSymbolImpl
extends UnaryNumericSPARQLAggregationFunctionSymbolImpl {
    private static final String DEFAULT_AGG_VAR_NAME = "avg1";

    protected AvgSPARQLFunctionSymbolImpl(RDFTermType rootRdfTermType, boolean isDistinct) {
        super("SP_AVG" + (isDistinct ? "_DISTINCT" : ""), "AVG", isDistinct, rootRdfTermType, DEFAULT_AGG_VAR_NAME);
    }

    @Override
    protected ImmutableFunctionalTerm createAggregate(ConcreteNumericRDFDatatype rdfType, ImmutableTerm dbTerm, TermFactory termFactory) {
        DBTermType dbType = rdfType.getClosestDBType(termFactory.getTypeFactory().getDBTypeFactory());
        return termFactory.getDBAvg(dbTerm, dbType, this.isDistinct());
    }

    @Override
    protected ConcreteNumericRDFDatatype inferTypeWhenNonEmpty(ConcreteNumericRDFDatatype inputNumericDatatype, TypeFactory typeFactory) {
        ConcreteNumericRDFDatatype propagatedOrSubstitutedType = inputNumericDatatype.getCommonPropagatedOrSubstitutedType(inputNumericDatatype);
        return propagatedOrSubstitutedType.equals(typeFactory.getXsdIntegerDatatype()) ? typeFactory.getXsdDecimalDatatype() : propagatedOrSubstitutedType;
    }

    @Override
    protected SPARQLAggregationFunctionSymbol.AggregationSimplification decomposeMultityped(ImmutableTerm subTerm, ImmutableSet<RDFTermType> subTermPossibleTypes, boolean hasGroupBy, VariableNullability variableNullability, VariableGenerator variableGenerator, TermFactory termFactory) {
        ImmutableTerm subTermLexicalTerm = this.extractLexicalTerm(subTerm, termFactory);
        ImmutableTerm subTermTypeTerm = this.extractRDFTermTypeTerm(subTerm, termFactory);
        ImmutableSet<RDFTermType> nonNumericTypes = this.extractNonNumericTypes(subTermPossibleTypes);
        ImmutableSet numericTypes = (ImmutableSet)subTermPossibleTypes.stream().filter(t -> t instanceof ConcreteNumericRDFDatatype).map(t -> (ConcreteNumericRDFDatatype)t).map(t -> t.getCommonPropagatedOrSubstitutedType((ConcreteNumericRDFDatatype)t)).collect(ImmutableCollectors.toSet());
        Optional<Variable> optionalNumSubVariable = numericTypes.isEmpty() ? Optional.empty() : Optional.of(variableGenerator.generateNewVariable("num1"));
        Optional<Variable> optionalIncompatibleSubVariable = nonNumericTypes.isEmpty() ? Optional.empty() : Optional.of(variableGenerator.generateNewVariable("nonNum1"));
        ImmutableMap<ConcreteNumericRDFDatatype, Variable> floatAndDoubleNumVariableMap = numericTypes.stream().filter(t -> t.getIRI().equals((Object)XSD.FLOAT) || t.getIRI().equals((Object)XSD.DOUBLE)).collect(ImmutableCollectors.toMap(t -> t, t -> variableGenerator.generateNewVariable("floatOrDouble1")));
        ImmutableSet<DefinitionPushDownRequest> pushDownRequests = this.computeRequests(subTermLexicalTerm, subTermTypeTerm, nonNumericTypes, optionalNumSubVariable, optionalIncompatibleSubVariable, floatAndDoubleNumVariableMap, variableNullability, termFactory);
        Optional<Variable> optionalNumAvgVariable = optionalNumSubVariable.map(v -> variableGenerator.generateNewVariable(DEFAULT_AGG_VAR_NAME));
        Optional<Variable> optionalIncompatibleCountVariable = optionalIncompatibleSubVariable.map(v -> variableGenerator.generateNewVariable("nonNumCount"));
        ImmutableMap<ConcreteNumericRDFDatatype, Variable> floatAndDoubleCountVariableMap = floatAndDoubleNumVariableMap.keySet().stream().collect(ImmutableCollectors.toMap(t -> t, t -> variableGenerator.generateNewVariable("count1")));
        ImmutableMap<Variable, ImmutableFunctionalTerm> substitutionMap = this.computeSubstitutionMap(optionalNumAvgVariable, optionalNumSubVariable, optionalIncompatibleCountVariable, optionalIncompatibleSubVariable, floatAndDoubleNumVariableMap, floatAndDoubleCountVariableMap, termFactory);
        ImmutableFunctionalTerm liftableTerm = this.computeLiftableTerm(optionalNumAvgVariable, floatAndDoubleCountVariableMap, optionalIncompatibleCountVariable, termFactory);
        return SPARQLAggregationFunctionSymbol.AggregationSimplification.create(termFactory.getFunctionalTermDecomposition(liftableTerm, substitutionMap), pushDownRequests);
    }

    private ImmutableSet<DefinitionPushDownRequest> computeRequests(ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, ImmutableSet<RDFTermType> nonNumericTypes, Optional<Variable> optionalNumSubVariable, Optional<Variable> optionalIncompatibleSubVariable, ImmutableMap<ConcreteNumericRDFDatatype, Variable> floatAndDoubleNumVariableMap, VariableNullability variableNullability, TermFactory termFactory) {
        Optional<DefinitionPushDownRequest> numericRequest = optionalNumSubVariable.map(v -> this.createNumericForFloatingAggregateRequest((Variable)v, subTermLexicalTerm, subTermTypeTerm, variableNullability, termFactory));
        Optional<DefinitionPushDownRequest> incompatibleTypeRequest = optionalIncompatibleSubVariable.map(v -> this.createNonNumericRequest(subTermTypeTerm, (Variable)v, nonNumericTypes, termFactory));
        Stream<DefinitionPushDownRequest> floatAndDoubleRequestStream = floatAndDoubleNumVariableMap.entrySet().stream().map(e -> this.createNumericForCountRequest((Variable)e.getValue(), (ConcreteNumericRDFDatatype)e.getKey(), subTermLexicalTerm, subTermTypeTerm, variableNullability, termFactory));
        return (ImmutableSet)Stream.concat(floatAndDoubleRequestStream, Stream.of(numericRequest, incompatibleTypeRequest).filter(Optional::isPresent).map(Optional::get)).collect(ImmutableCollectors.toSet());
    }

    private DefinitionPushDownRequest createNumericForFloatingAggregateRequest(Variable numericVariable, ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, VariableNullability variableNullability, TermFactory termFactory) {
        TypeFactory typeFactory = termFactory.getTypeFactory();
        ImmutableTerm decimalDefinition = termFactory.getConversionFromRDFLexical2DB(subTermLexicalTerm, typeFactory.getXsdDecimalDatatype()).simplify(variableNullability);
        ImmutableExpression condition = termFactory.getIsAExpression(subTermTypeTerm, typeFactory.getAbstractOntopNumericDatatype());
        return DefinitionPushDownRequest.create(numericVariable, decimalDefinition, condition);
    }

    private DefinitionPushDownRequest createNumericForCountRequest(Variable numericVariable, ConcreteNumericRDFDatatype numericType, ImmutableTerm subTermLexicalTerm, ImmutableTerm subTermTypeTerm, VariableNullability variableNullability, TermFactory termFactory) {
        ImmutableTerm decimalDefinition = termFactory.getConversionFromRDFLexical2DB(subTermLexicalTerm, numericType).simplify(variableNullability);
        ImmutableExpression condition = termFactory.getIsAExpression(subTermTypeTerm, numericType);
        return DefinitionPushDownRequest.create(numericVariable, decimalDefinition, condition);
    }

    private ImmutableMap<Variable, ImmutableFunctionalTerm> computeSubstitutionMap(Optional<Variable> optionalNumAvgVariable, Optional<Variable> optionalNumSubVariable, Optional<Variable> optionalIncompatibleCountVariable, Optional<Variable> optionalIncompatibleSubVariable, ImmutableMap<ConcreteNumericRDFDatatype, Variable> floatAndDoubleNumVariableMap, ImmutableMap<ConcreteNumericRDFDatatype, Variable> floatAndDoubleCountVariableMap, TermFactory termFactory) {
        ConcreteNumericRDFDatatype xsdDecimal = termFactory.getTypeFactory().getXsdDecimalDatatype();
        Optional<Map.Entry> avgEntryStream = optionalNumAvgVariable.map(v -> Maps.immutableEntry((Object)v, (Object)this.createAggregate(xsdDecimal, (ImmutableTerm)optionalNumSubVariable.get(), termFactory)));
        Optional<Map.Entry> incompatibleEntry = optionalIncompatibleCountVariable.map(v -> Maps.immutableEntry((Object)v, (Object)termFactory.getDBCount((ImmutableTerm)optionalIncompatibleSubVariable.get(), false)));
        Stream<Map.Entry> floatDoubleCountStream = floatAndDoubleCountVariableMap.entrySet().stream().map(e -> Maps.immutableEntry(e.getValue(), (Object)termFactory.getDBCount((ImmutableTerm)floatAndDoubleNumVariableMap.get(e.getKey()), false)));
        return Stream.concat(floatDoubleCountStream, Stream.of(avgEntryStream, incompatibleEntry).filter(Optional::isPresent).map(Optional::get)).collect(ImmutableCollectors.toMap());
    }

    private ImmutableFunctionalTerm computeLiftableTerm(Optional<Variable> optionalNumAvgVariable, ImmutableMap<ConcreteNumericRDFDatatype, Variable> floatAndDoubleCountVariableMap, Optional<Variable> optionalIncompatibleCountVariable, TermFactory termFactory) {
        Optional<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> incompatibleWhenPair = optionalIncompatibleCountVariable.map(v -> termFactory.getDBNumericInequality(InequalityLabel.GT, (ImmutableTerm)v, termFactory.getDBIntegerConstant(0))).map(c -> Maps.immutableEntry((Object)c, (Object)termFactory.getNullConstant()));
        ImmutableTerm lexicalTerm = this.computeLexicalTerm(optionalNumAvgVariable, incompatibleWhenPair, termFactory);
        ImmutableTerm typeTerm = this.computeTypeTerm(optionalNumAvgVariable, floatAndDoubleCountVariableMap, incompatibleWhenPair, termFactory);
        return termFactory.getRDFFunctionalTerm(lexicalTerm, typeTerm);
    }

    private ImmutableTerm computeLexicalTerm(Optional<Variable> optionalFloatingAggVariable, Optional<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> incompatibleWhenPair, TermFactory termFactory) {
        ConcreteNumericRDFDatatype xsdDecimal = termFactory.getTypeFactory().getXsdDecimalDatatype();
        Stream<Map.Entry> whenPairs = Stream.of(incompatibleWhenPair, optionalFloatingAggVariable.map(v -> Maps.immutableEntry((Object)termFactory.getDBIsNotNull((ImmutableTerm)v), (Object)termFactory.getConversion2RDFLexical((ImmutableTerm)v, xsdDecimal)))).filter(Optional::isPresent).map(Optional::get);
        return termFactory.getDBCase(whenPairs, termFactory.getDBStringConstant("0"), true);
    }

    private ImmutableTerm computeTypeTerm(Optional<Variable> optionalNumAvgVariable, ImmutableMap<ConcreteNumericRDFDatatype, Variable> floatAndDoubleCountVariableMap, Optional<Map.Entry<ImmutableExpression, ? extends ImmutableTerm>> incompatibleWhenPair, TermFactory termFactory) {
        ImmutableList orderedTypes = (ImmutableList)floatAndDoubleCountVariableMap.keySet().stream().sorted((t1, t2) -> t1.getCommonPropagatedOrSubstitutedType((ConcreteNumericRDFDatatype)t2).equals(t2) ? 1 : -1).collect(ImmutableCollectors.toList());
        Stream<Map.Entry> floatDoubleWhenPairs = orderedTypes.stream().map(t -> Maps.immutableEntry((Object)termFactory.getDBNumericInequality(InequalityLabel.GT, (ImmutableTerm)floatAndDoubleCountVariableMap.get(t), termFactory.getDBIntegerConstant(0)), (Object)termFactory.getRDFTermTypeConstant((RDFTermType)t)));
        Optional<Map.Entry> decimalEntry = optionalNumAvgVariable.map(v -> Maps.immutableEntry((Object)termFactory.getDBIsNotNull((ImmutableTerm)v), (Object)termFactory.getRDFTermTypeConstant(termFactory.getTypeFactory().getXsdDecimalDatatype())));
        Stream<Map.Entry> whenPairs = Stream.concat(Stream.concat(incompatibleWhenPair.map(Stream::of).orElseGet(Stream::empty), floatDoubleWhenPairs), decimalEntry.map(Stream::of).orElseGet(Stream::empty));
        return termFactory.getDBCase(whenPairs, termFactory.getRDFTermTypeConstant(termFactory.getTypeFactory().getXsdIntegerDatatype()), true);
    }

    @Override
    public Constant evaluateEmptyBag(TermFactory termFactory) {
        return termFactory.getRDFLiteralConstant("0", XSD.INTEGER);
    }
}

