/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.template.impl.TemplateParser;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class SafeSeparatorFragment {
    private final String fragment;
    private final ImmutableList<Template.Component> components;
    private final char separator;
    private final int firstPlaceholderIndex;
    private static final Pattern TO_BE_ESCAPED = Pattern.compile("[<(\\[{\\\\^=$!|\\]})?*+.>]");
    protected static final ImmutableSet<Character> SOME_SAFE_SEPARATORS = ImmutableSet.of((Object)Character.valueOf('!'), (Object)Character.valueOf('$'), (Object)Character.valueOf('&'), (Object)Character.valueOf('\''), (Object)Character.valueOf('('), (Object)Character.valueOf(')'), (Object[])new Character[]{Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('#'), Character.valueOf('/')});
    public static final String NOT_A_SAFE_SEPARATOR_REGEX = "[^" + SOME_SAFE_SEPARATORS.stream().map(Object::toString).map(SafeSeparatorFragment::makeRegexSafe).collect(Collectors.joining()) + "]*";
    @Nullable
    private Pattern pattern;

    private SafeSeparatorFragment(String fragment, char separator, int firstPlaceholderIndex) {
        this.fragment = fragment;
        this.separator = separator;
        this.firstPlaceholderIndex = firstPlaceholderIndex;
        this.components = TemplateParser.getComponents(fragment, true);
    }

    private SafeSeparatorFragment(String fragment, char separator) {
        this(fragment, separator, fragment.indexOf(123));
    }

    public String getFragment() {
        return this.fragment;
    }

    public char getSeparator() {
        return this.separator;
    }

    public ImmutableList<Template.Component> getComponents() {
        return this.components;
    }

    public String toString() {
        return this.fragment + (this.separator != '\u0000' ? Character.valueOf(this.separator) : "") + (this.firstPlaceholderIndex != -1 ? "P" : "");
    }

    public static ImmutableList<SafeSeparatorFragment> split(String s) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int start = 0;
        int end = SafeSeparatorFragment.firstIndexOfSafeSeparator(s, start);
        while (end != -1) {
            int next_end = end;
            while ((next_end = SafeSeparatorFragment.firstIndexOfSafeSeparator(s, next_end + 1)) == end + 1) {
                end = next_end;
            }
            builder.add((Object)new SafeSeparatorFragment(s.substring(start, end), s.charAt(end)));
            start = end + 1;
            end = next_end;
        }
        if (start < s.length()) {
            builder.add((Object)new SafeSeparatorFragment(s.substring(start), '\u0000'));
        }
        return builder.build();
    }

    private static int firstIndexOfSafeSeparator(String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            if (!SOME_SAFE_SEPARATORS.contains((Object)Character.valueOf(s.charAt(i)))) continue;
            return i;
        }
        return -1;
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            int end;
            StringBuilder patternString = new StringBuilder();
            int start = 0;
            while ((end = this.fragment.indexOf(123, start)) != -1) {
                patternString.append(SafeSeparatorFragment.makeRegexSafe(this.fragment.substring(start, end))).append(NOT_A_SAFE_SEPARATOR_REGEX);
                start = end + 2;
            }
            if (start < this.fragment.length()) {
                patternString.append(SafeSeparatorFragment.makeRegexSafe(this.fragment.substring(start)));
            }
            this.pattern = Pattern.compile("^" + patternString + "$");
        }
        return this.pattern;
    }

    private int getPrefixLength() {
        return this.firstPlaceholderIndex != -1 ? this.firstPlaceholderIndex : this.fragment.length();
    }

    private static boolean matchFragments(SafeSeparatorFragment subTemplate1, SafeSeparatorFragment subTemplate2) {
        boolean equal = subTemplate1.fragment.equals(subTemplate2.fragment);
        if (equal) {
            return true;
        }
        if (subTemplate1.firstPlaceholderIndex == -1 && subTemplate2.firstPlaceholderIndex == -1) {
            return equal;
        }
        int prefix = Math.min(subTemplate1.getPrefixLength(), subTemplate2.getPrefixLength());
        if (!subTemplate1.fragment.substring(0, prefix).equals(subTemplate2.fragment.substring(0, prefix))) {
            return false;
        }
        return subTemplate1.firstPlaceholderIndex != -1 && subTemplate1.getPattern().matcher(subTemplate2.fragment).find() || subTemplate2.firstPlaceholderIndex != -1 && subTemplate2.getPattern().matcher(subTemplate1.fragment).find();
    }

    public static boolean areCompatible(ImmutableList<SafeSeparatorFragment> fragments1, ImmutableList<SafeSeparatorFragment> fragments2) {
        if (fragments1 == fragments2) {
            return true;
        }
        return fragments1.size() == fragments2.size() && IntStream.range(0, fragments1.size()).allMatch(i -> ((SafeSeparatorFragment)fragments1.get(i)).getSeparator() == ((SafeSeparatorFragment)fragments2.get(i)).getSeparator()) && IntStream.range(0, fragments1.size()).allMatch(i -> SafeSeparatorFragment.matchFragments((SafeSeparatorFragment)fragments1.get(i), (SafeSeparatorFragment)fragments2.get(i)));
    }

    public static String makeRegexSafe(String s) {
        return TO_BE_ESCAPED.matcher(s).replaceAll("\\\\$0");
    }
}

