/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.UnmodifiableIterator;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.template.impl.TemplateParser;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.ObjectStringTemplateFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractEncodeURIorIRIFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.SafeSeparatorFragment;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class ObjectStringTemplateFunctionSymbolImpl
extends FunctionSymbolImpl
implements ObjectStringTemplateFunctionSymbol {
    private final DBTermType lexicalType;
    private final boolean isInjective;
    private final ImmutableList<Template.Component> components;
    private final ImmutableList<SafeSeparatorFragment> safeSeparatorFragments;
    private final AbstractEncodeURIorIRIFunctionSymbol.IRISafeEnDecoder enDecoder;
    @Nullable
    private Pattern injectivePattern;

    protected ObjectStringTemplateFunctionSymbolImpl(ImmutableList<Template.Component> components, TypeFactory typeFactory) {
        super(ObjectStringTemplateFunctionSymbolImpl.getTemplateString(components), ObjectStringTemplateFunctionSymbolImpl.createBaseTypes(components, typeFactory));
        this.lexicalType = typeFactory.getDBTypeFactory().getDBStringType();
        this.components = components;
        this.safeSeparatorFragments = SafeSeparatorFragment.split(TemplateParser.getEncodedTemplateString(components));
        this.isInjective = this.atMostOnePlaceholderPerSeparator(this.safeSeparatorFragments);
        this.enDecoder = new AbstractEncodeURIorIRIFunctionSymbol.IRISafeEnDecoder();
    }

    private boolean atMostOnePlaceholderPerSeparator(ImmutableList<SafeSeparatorFragment> safeSeparatorFragments) {
        return safeSeparatorFragments.stream().map(SafeSeparatorFragment::getComponents).allMatch(this::atMostOnePlaceholder);
    }

    private boolean atMostOnePlaceholder(ImmutableList<Template.Component> components) {
        return components.stream().filter(Template.Component::isColumnNameReference).count() <= 1L;
    }

    private static String getTemplateString(ImmutableList<Template.Component> components) {
        return components.stream().map(c -> c.isColumnNameReference() ? "{}" : c.getComponent()).collect(Collectors.joining());
    }

    private static ImmutableList<TermType> createBaseTypes(ImmutableList<Template.Component> components, TypeFactory typeFactory) {
        RDFDatatype stringType = typeFactory.getXsdStringDatatype();
        return (ImmutableList)components.stream().filter(Template.Component::isColumnNameReference).map(c -> stringType).collect(ImmutableCollectors.toList());
    }

    @Override
    public String getTemplate() {
        return this.getName();
    }

    @Override
    public ImmutableList<Template.Component> getTemplateComponents() {
        return this.components;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        if (terms.stream().filter(t -> t instanceof Constant).anyMatch(t -> ((Constant)t).isNull())) {
            return Optional.empty();
        }
        return Optional.of(TermTypeInference.declareTermType(this.lexicalType));
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (newTerms.stream().allMatch(t -> t instanceof DBConstant)) {
            String value = this.components.stream().map(c -> c.isColumnNameReference() ? ObjectStringTemplateFunctionSymbolImpl.encodeParameter((DBConstant)newTerms.get(c.getIndex()), termFactory, variableNullability) : c.getComponent()).collect(Collectors.joining());
            return termFactory.getDBConstant(value, this.lexicalType);
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this, newTerms);
    }

    private static String encodeParameter(DBConstant constant, TermFactory termFactory, VariableNullability variableNullability) {
        return Optional.of(constant).map(termFactory::getR2RMLIRISafeEncodeFunctionalTerm).map(t -> t.simplify(variableNullability)).filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).orElseThrow(() -> new MinorOntopInternalBugException("Was expecting the getR2RMLIRISafeEncodeFunctionalTerm to simplify itself to a DBConstant when receiving a DBConstant"));
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return this.isInjective;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    protected boolean tolerateNulls() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ImmutableList termsToConcatenate = (ImmutableList)this.components.stream().map(c -> c.isColumnNameReference() ? termFactory.getR2RMLIRISafeEncodeFunctionalTerm((ImmutableTerm)terms.get(c.getIndex())).simplify() : termFactory.getDBStringConstant(c.getComponent())).collect(ImmutableCollectors.toList());
        DBConstant concatTerm = termsToConcatenate.isEmpty() ? termFactory.getDBStringConstant("") : (termsToConcatenate.size() == 1 ? (ImmutableTerm)termsToConcatenate.get(0) : termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)termsToConcatenate).simplify());
        return termConverter.apply(concatTerm);
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithFunctionalTerm(ImmutableList<? extends ImmutableTerm> terms, ImmutableFunctionalTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        FunctionSymbol otherFunctionSymbol = otherTerm.getFunctionSymbol();
        if (otherFunctionSymbol instanceof ObjectStringTemplateFunctionSymbolImpl) {
            ObjectStringTemplateFunctionSymbolImpl other = (ObjectStringTemplateFunctionSymbolImpl)otherFunctionSymbol;
            if (!SafeSeparatorFragment.areCompatible(this.safeSeparatorFragments, other.safeSeparatorFragments)) {
                return IncrementalEvaluation.declareIsFalse();
            }
            if (!other.equals(this)) {
                return this.tryToSimplifyCompatibleTemplates(other, terms, otherTerm, termFactory, variableNullability);
            }
        }
        return super.evaluateStrictEqWithFunctionalTerm(terms, otherTerm, termFactory, variableNullability);
    }

    private IncrementalEvaluation tryToSimplifyCompatibleTemplates(ObjectStringTemplateFunctionSymbolImpl other, ImmutableList<? extends ImmutableTerm> subTerms, ImmutableFunctionalTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        UnmodifiableIterator subTermIterator = subTerms.iterator();
        UnmodifiableIterator otherSubTermIterator = otherTerm.getTerms().iterator();
        Stream<ImmutableExpression> expressionStream = IntStream.range(0, this.safeSeparatorFragments.size()).mapToObj(i -> this.convertToEquality((SafeSeparatorFragment)this.safeSeparatorFragments.get(i), (UnmodifiableIterator<? extends ImmutableTerm>)subTermIterator, (SafeSeparatorFragment)other.safeSeparatorFragments.get(i), (UnmodifiableIterator<? extends ImmutableTerm>)otherSubTermIterator, termFactory)).filter(Optional::isPresent).map(Optional::get);
        Optional<ImmutableExpression> expression = termFactory.getConjunction(expressionStream);
        if (expression.isPresent()) {
            ImmutableExpression nonNull = termFactory.getConjunction(Stream.concat(subTerms.stream(), otherTerm.getTerms().stream()).map(termFactory::getDBIsNotNull)).get();
            ImmutableExpression ifElseNull = termFactory.getBooleanIfElseNull(nonNull, expression.get());
            return ifElseNull.evaluate(variableNullability, true);
        }
        return IncrementalEvaluation.declareIsTrue();
    }

    private Optional<ImmutableExpression> convertToEquality(SafeSeparatorFragment safeSeparatorFragment, UnmodifiableIterator<? extends ImmutableTerm> subTermIterator, SafeSeparatorFragment otherSafeSeparatorFragment, UnmodifiableIterator<? extends ImmutableTerm> otherSubTermIterator, TermFactory termFactory) {
        ImmutableList<Template.Component> components = safeSeparatorFragment.getComponents();
        ImmutableList<Template.Component> otherComponents = otherSafeSeparatorFragment.getComponents();
        if (!((Template.Component)components.get(0)).isColumnNameReference() && !((Template.Component)otherComponents.get(0)).isColumnNameReference()) {
            String otherFirst;
            String first = ((Template.Component)components.get(0)).getComponent();
            if (first.startsWith(otherFirst = ((Template.Component)otherComponents.get(0)).getComponent())) {
                components = Template.replaceFirst(components, first.substring(otherFirst.length()));
                otherComponents = Template.replaceFirst(otherComponents, "");
            } else if (otherFirst.startsWith(first)) {
                components = Template.replaceFirst(components, "");
                otherComponents = Template.replaceFirst(otherComponents, otherFirst.substring(first.length()));
            } else {
                return Optional.of(termFactory.getIsTrue(termFactory.getDBBooleanConstant(false)));
            }
            if (components.isEmpty() && otherComponents.isEmpty()) {
                return Optional.empty();
            }
        }
        if (!((Template.Component)components.get(components.size() - 1)).isColumnNameReference() && !((Template.Component)otherComponents.get(otherComponents.size() - 1)).isColumnNameReference()) {
            String otherLast;
            String last = ((Template.Component)components.get(components.size() - 1)).getComponent();
            if (last.endsWith(otherLast = ((Template.Component)otherComponents.get(otherComponents.size() - 1)).getComponent())) {
                components = Template.replaceLast(components, last.substring(0, last.length() - otherLast.length()));
                otherComponents = Template.replaceLast(otherComponents, "");
            } else if (otherLast.endsWith(last)) {
                components = Template.replaceLast(components, "");
                otherComponents = Template.replaceLast(otherComponents, otherLast.substring(0, otherLast.length() - last.length()));
            } else {
                return Optional.of(termFactory.getIsTrue(termFactory.getDBBooleanConstant(false)));
            }
            if (components.isEmpty() && otherComponents.isEmpty()) {
                return Optional.empty();
            }
        }
        return Optional.of(termFactory.getStrictEquality(this.convertIntoTerm(components, subTermIterator, termFactory), this.convertIntoTerm(otherComponents, otherSubTermIterator, termFactory), new ImmutableTerm[0]));
    }

    private ImmutableTerm convertIntoTerm(ImmutableList<Template.Component> components, UnmodifiableIterator<? extends ImmutableTerm> subTermIterator, TermFactory termFactory) {
        ImmutableList args = (ImmutableList)components.stream().map(c -> c.isColumnNameReference() ? (ImmutableTerm)subTermIterator.next() : termFactory.getDBStringConstant(this.enDecoder.decode(c.getComponent()))).collect(ImmutableCollectors.toList());
        return args.size() == 1 ? (ImmutableTerm)args.get(0) : termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)args);
    }

    private Pattern getPattern() {
        if (this.injectivePattern == null) {
            String patternString = this.components.stream().map(c -> c.isColumnNameReference() ? "(" + SafeSeparatorFragment.NOT_A_SAFE_SEPARATOR_REGEX + ")" : SafeSeparatorFragment.makeRegexSafe(c.getComponent())).collect(Collectors.joining());
            this.injectivePattern = Pattern.compile("^" + patternString + "$");
        }
        return this.injectivePattern;
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        String otherValue = otherTerm.getValue();
        if (this.isInjective(terms, variableNullability, termFactory)) {
            Matcher matcher = this.getPattern().matcher(otherTerm.getValue());
            if (matcher.find()) {
                ImmutableExpression newExpression = termFactory.getConjunction(IntStream.range(0, this.getArity()).mapToObj(i -> termFactory.getStrictEquality(termFactory.getR2RMLIRISafeEncodeFunctionalTerm((ImmutableTerm)terms.get(i)), termFactory.getDBStringConstant(matcher.group(i + 1)), new ImmutableTerm[0]))).orElseThrow(() -> new MinorOntopInternalBugException("An ObjectStringTemplateFunctionSymbolImpl is expected to have a non-null arity"));
                return newExpression.evaluate(variableNullability, true);
            }
            return IncrementalEvaluation.declareIsFalse();
        }
        if (!SafeSeparatorFragment.areCompatible(this.safeSeparatorFragments, SafeSeparatorFragment.split(otherValue))) {
            return IncrementalEvaluation.declareIsFalse();
        }
        return super.evaluateStrictEqWithNonNullConstant(terms, otherTerm, termFactory, variableNullability);
    }

    @Override
    public boolean isPreferringToBePostProcessedOverBeingBlocked() {
        return true;
    }
}

