/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractDBTypeConversionFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultSimpleDBCastFunctionSymbol
extends AbstractDBTypeConversionFunctionSymbolImpl {
    @Nullable
    private final DBTermType inputType;
    private final DBFunctionSymbolSerializer serializer;

    protected DefaultSimpleDBCastFunctionSymbol(@Nonnull DBTermType inputBaseType, DBTermType targetType, DBFunctionSymbolSerializer serializer) {
        super(inputBaseType.isAbstract() ? "to" + targetType : inputBaseType + "To" + targetType, inputBaseType, targetType);
        this.inputType = inputBaseType.isAbstract() ? null : inputBaseType;
        this.serializer = serializer;
    }

    @Override
    protected DBConstant convertDBConstant(DBConstant constant, TermFactory termFactory) {
        return termFactory.getDBConstant(constant.getValue(), this.getTargetType());
    }

    @Override
    protected ImmutableTerm buildTermFromFunctionalTerm(ImmutableFunctionalTerm subTerm, TermFactory termFactory, VariableNullability variableNullability) {
        if (this.inputType != null && this.inputType.equals(this.getTargetType())) {
            return subTerm;
        }
        if (subTerm.getFunctionSymbol() instanceof DBTypeConversionFunctionSymbol) {
            DBTypeConversionFunctionSymbol functionSymbol = (DBTypeConversionFunctionSymbol)subTerm.getFunctionSymbol();
            ImmutableTerm subSubTerm = subTerm.getTerm(0);
            DBTermType targetType = this.getTargetType();
            if (functionSymbol.isSimple()) {
                return functionSymbol.getInputType().map(input -> input.equals(targetType) ? subSubTerm : termFactory.getDBCastFunctionalTerm((DBTermType)input, targetType, subSubTerm)).orElseGet(() -> termFactory.getDBCastFunctionalTerm(targetType, subSubTerm));
            }
        }
        return super.buildTermFromFunctionalTerm(subTerm, termFactory, variableNullability);
    }

    @Override
    protected ImmutableTerm buildFromVariable(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        if (this.inputType != null && this.inputType.equals(this.getTargetType())) {
            return (ImmutableTerm)newTerms.get(0);
        }
        return super.buildFromVariable(newTerms, termFactory, variableNullability);
    }

    @Override
    public Optional<DBTermType> getInputType() {
        return Optional.ofNullable(this.inputType);
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return this.getInputType().isPresent();
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return this.getInputType().isPresent();
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializer.getNativeDBString(terms, termConverter, termFactory);
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        if (this.inputType != null && otherTerm.getType() instanceof DBTermType && this.inputType.areEqualitiesStrict()) {
            return this.perform2ndStepEvaluationStrictEqWithConstant(terms, otherTerm.getValue(), termFactory, variableNullability);
        }
        return IncrementalEvaluation.declareSameExpression();
    }

    protected IncrementalEvaluation perform2ndStepEvaluationStrictEqWithConstant(ImmutableList<? extends ImmutableTerm> terms, String otherLexicalValue, TermFactory termFactory, VariableNullability variableNullability) {
        assert (this.inputType != null);
        Optional<Boolean> isValid = this.inputType.isValidLexicalValue(otherLexicalValue);
        if (!isValid.isPresent()) {
            return IncrementalEvaluation.declareSameExpression();
        }
        if (isValid.get().booleanValue()) {
            ImmutableExpression newEquality = termFactory.getStrictEquality((ImmutableTerm)terms.get(0), termFactory.getDBConstant(otherLexicalValue, this.inputType), new ImmutableTerm[0]);
            return newEquality.evaluate(variableNullability, true);
        }
        ImmutableExpression newExpression = termFactory.getBooleanIfElseNull(termFactory.getDBIsNotNull((ImmutableTerm)terms.get(0)), termFactory.getIsTrue(termFactory.getDBBooleanConstant(false)));
        return newExpression.evaluate(variableNullability, true);
    }
}

