/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBOrFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractDBBooleanConnectorFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultDBOrFunctionSymbol
extends AbstractDBBooleanConnectorFunctionSymbol
implements DBOrFunctionSymbol {
    private final String argumentSeparator;

    protected DefaultDBOrFunctionSymbol(String nameInDialect, int arity, DBTermType dbBooleanTermType) {
        super(nameInDialect, arity, dbBooleanTermType);
        if (arity < 2) {
            throw new IllegalArgumentException("Arity must be >= 2");
        }
        this.argumentSeparator = String.format(" %s ", nameInDialect);
    }

    @Override
    protected ImmutableList<ImmutableTerm> simplify2VLInteractions(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return newTerms;
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableList<ImmutableTerm> simplifiedTerms = this.simplifyInteractions(newTerms, termFactory, variableNullability);
        return DefaultDBOrFunctionSymbol.computeNewDisjunction(simplifiedTerms, termFactory);
    }

    public static ImmutableTerm computeNewDisjunction(ImmutableList<ImmutableTerm> evaluatedTerms, TermFactory termFactory) {
        DBConstant trueValue = termFactory.getDBBooleanConstant(true);
        if (evaluatedTerms.stream().anyMatch(trueValue::equals)) {
            return trueValue;
        }
        Optional<ImmutableTerm> optionalNull = evaluatedTerms.stream().filter(t -> t instanceof Constant && ((Constant)t).isNull()).findFirst();
        ImmutableList others = (ImmutableList)evaluatedTerms.stream().map(t -> t instanceof Variable ? termFactory.getIsTrue((Variable)t) : t).filter(t -> t instanceof ImmutableExpression).map(t -> (ImmutableExpression)t).flatMap(t -> t.getFunctionSymbol() instanceof DBOrFunctionSymbol ? t.getTerms().stream().map(s -> (ImmutableExpression)s) : Stream.of(t)).distinct().collect(ImmutableCollectors.toList());
        return others.isEmpty() ? optionalNull.orElseGet(() -> termFactory.getDBBooleanConstant(false)) : optionalNull.map(n -> termFactory.getTrueOrNullFunctionalTerm((ImmutableList<ImmutableExpression>)others)).orElseGet(() -> others.size() == 1 ? (ImmutableTerm)others.get(0) : termFactory.getDisjunction((ImmutableList<ImmutableExpression>)others));
    }

    protected ImmutableList<ImmutableTerm> simplifyInteractions(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return this.simplifyIsNullOrIsNotNull(newTerms, termFactory, variableNullability, false);
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.inBrackets(terms.stream().map(termConverter::apply).collect(Collectors.joining(this.argumentSeparator)));
    }

    @Override
    public boolean blocksNegation() {
        return false;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        return termFactory.getConjunction((ImmutableList<ImmutableExpression>)((ImmutableList)subTerms.stream().map(t -> (ImmutableExpression)t).map(t -> t.negate(termFactory)).collect(ImmutableCollectors.toList())));
    }
}

