/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import java.util.function.Function;
import org.apache.commons.rdf.api.IRI;
import org.eclipse.rdf4j.common.net.ParsedIRI;

public class DBIriStringResolverFunctionSymbolImpl
extends AbstractTypedDBFunctionSymbol {
    protected final IRI baseIRI;
    protected final String iriPrefixRegex;

    protected DBIriStringResolverFunctionSymbolImpl(IRI baseIRI, String iriPrefixRegex, DBTermType rootDBType, DBTermType dbStringType) {
        super("IRI_RESOLVE_" + baseIRI, (ImmutableList<TermType>)ImmutableList.of((Object)rootDBType), dbStringType);
        this.baseIRI = baseIRI;
        this.iriPrefixRegex = iriPrefixRegex;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        if (newTerm instanceof DBConstant) {
            boolean isAbsoluteIRI;
            String arg = ((DBConstant)newTerm).getValue();
            try {
                isAbsoluteIRI = ParsedIRI.create((String)arg).isAbsolute();
            }
            catch (IllegalArgumentException e) {
                isAbsoluteIRI = false;
            }
            return termFactory.getDBStringConstant(isAbsoluteIRI ? arg : this.baseIRI.getIRIString() + arg);
        }
        return super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability);
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        ImmutableTerm argLexical = (ImmutableTerm)terms.get(0);
        ImmutableFunctionalTerm functionalTerm = termFactory.getIfThenElse(termFactory.getDBRegexpMatches((ImmutableList<ImmutableTerm>)ImmutableList.of((Object)argLexical, (Object)termFactory.getDBStringConstant(this.iriPrefixRegex))), argLexical, termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)ImmutableList.of((Object)termFactory.getDBStringConstant(this.baseIRI.toString()), (Object)argLexical)));
        return termConverter.apply(functionalTerm.simplify());
    }

    @Override
    protected boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }
}

