/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBBooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultDBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import java.util.Optional;

public class BooleanDBIfElseNullFunctionSymbolImpl
extends DefaultDBIfElseNullFunctionSymbol
implements DBBooleanFunctionSymbol {
    protected BooleanDBIfElseNullFunctionSymbolImpl(DBTermType dbBooleanType) {
        super("BOOL_IF_ELSE_NULL", dbBooleanType, dbBooleanType);
    }

    @Override
    public boolean blocksNegation() {
        return false;
    }

    @Override
    public ImmutableExpression negate(ImmutableList<? extends ImmutableTerm> subTerms, TermFactory termFactory) {
        ImmutableExpression thenCondition = Optional.of(subTerms.get(1)).filter(t -> t instanceof ImmutableExpression).map(t -> termFactory.getDBNot((ImmutableExpression)t)).orElseThrow(() -> new MinorOntopInternalBugException("BooleanDBIfElseNullFunctionSymbol was expecting its second sub-term to be an expression"));
        return termFactory.getImmutableExpression((BooleanFunctionSymbol)this, (ImmutableTerm)subTerms.get(0), thenCondition);
    }

    @Override
    protected ImmutableTerm simplify(ImmutableExpression newCondition, ImmutableTerm newThenValue, TermFactory termFactory, VariableNullability variableNullability) {
        if (this.canBeReplacedByValue(newCondition, newThenValue, termFactory)) {
            return newThenValue;
        }
        if (newThenValue instanceof ImmutableExpression) {
            return termFactory.getImmutableExpression((BooleanFunctionSymbol)this, newCondition, newThenValue);
        }
        if (newThenValue instanceof DBConstant) {
            return termFactory.getConjunction(newCondition, termFactory.getIsTrue((DBConstant)newThenValue)).simplify(variableNullability);
        }
        if (newThenValue.isNull()) {
            return newThenValue;
        }
        throw new MinorOntopInternalBugException("Unexpected new \"then\" value for a boolean IF_ELSE_NULL: " + newThenValue);
    }

    @Override
    public ImmutableTerm simplify2VL(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableTerm thenValue = (ImmutableTerm)terms.get(1);
        ImmutableExpression thenExpression = thenValue instanceof ImmutableExpression ? (ImmutableExpression)thenValue : termFactory.getIsTrue(Optional.of(thenValue).filter(v -> v instanceof NonFunctionalTerm).map(v -> (NonFunctionalTerm)v).orElseThrow(() -> new MinorOntopInternalBugException("Was an expected an immutable expression or non functional term as a then condition")));
        return termFactory.getConjunction((ImmutableExpression)terms.get(0), thenExpression).simplify2VL(variableNullability);
    }
}

