/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import io.mikael.urlbuilder.util.Decoder;
import io.mikael.urlbuilder.util.Encoder;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.NonNullConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.R2RMLIRISafeEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class AbstractEncodeURIorIRIFunctionSymbol
extends AbstractTypedDBFunctionSymbol {
    private final EnDecoder enDecoder;

    protected AbstractEncodeURIorIRIFunctionSymbol(DBTermType dbStringType, boolean preserveInternationalChars) {
        super(preserveInternationalChars ? "R2RMLIRISafeEncode" : "DB_ENCODE_FOR_URI", (ImmutableList<TermType>)ImmutableList.of((Object)dbStringType), dbStringType);
        this.enDecoder = preserveInternationalChars ? new IRISafeEnDecoder() : new EnDecoderForURI();
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        FunctionSymbol functionSymbol;
        ImmutableTerm newTerm = (ImmutableTerm)newTerms.get(0);
        if (newTerm instanceof DBConstant) {
            return this.encodeConstant((DBConstant)newTerm, termFactory);
        }
        if (newTerm instanceof ImmutableFunctionalTerm && (functionSymbol = ((ImmutableFunctionalTerm)newTerm).getFunctionSymbol()) instanceof DBTypeConversionFunctionSymbol && ((DBTypeConversionFunctionSymbol)functionSymbol).getInputType().filter(t -> !t.isNeedingIRISafeEncoding()).isPresent()) {
            return newTerm;
        }
        return super.buildTermAfterEvaluation(newTerms, termFactory, variableNullability);
    }

    private DBConstant encodeConstant(DBConstant constant, TermFactory termFactory) {
        return termFactory.getDBStringConstant(this.enDecoder.encode(constant.getValue()));
    }

    @Override
    protected boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return true;
    }

    @Override
    protected IncrementalEvaluation evaluateStrictEqWithNonNullConstant(ImmutableList<? extends ImmutableTerm> terms, NonNullConstant otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        DBConstant decodedConstant = termFactory.getDBStringConstant(this.enDecoder.decode(otherTerm.getValue()));
        ImmutableExpression newExpression = termFactory.getStrictEquality((ImmutableTerm)terms.get(0), decodedConstant, new ImmutableTerm[0]);
        return newExpression.evaluate(variableNullability, true);
    }

    protected static class IRISafeEnDecoder
    implements EnDecoder {
        protected IRISafeEnDecoder() {
        }

        @Override
        public String encode(String value) {
            return R2RMLIRISafeEncoder.encode(value);
        }

        @Override
        public String decode(String value) {
            return R2RMLIRISafeEncoder.decode(value);
        }
    }

    protected static class EnDecoderForURI
    implements EnDecoder {
        private final Encoder uriEncoder;
        private final Decoder uriDecoder;

        protected EnDecoderForURI() {
            Charset charset = StandardCharsets.UTF_8;
            this.uriEncoder = new Encoder(charset);
            this.uriDecoder = new Decoder(charset);
        }

        @Override
        public String encode(String value) {
            return this.uriEncoder.encodeQueryElement(value);
        }

        @Override
        public String decode(String value) {
            return this.uriDecoder.urlDecode(value, true);
        }
    }

    static interface EnDecoder {
        public String encode(String var1);

        public String decode(String var1);
    }
}

