/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.template.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableBiMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.model.template.Template;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.StringUtils;
import java.util.stream.Collectors;

public class TemplateParser {
    private static final ImmutableBiMap<Character, String> ESCAPE = ImmutableBiMap.of((Object)Character.valueOf('\\'), (Object)"\\\\", (Object)Character.valueOf('}'), (Object)"\\}", (Object)Character.valueOf('{'), (Object)"\\{");

    private static String decode(String s) {
        return StringUtils.decode(s, '\\', 2, (ImmutableMap<String, Character>)ESCAPE.inverse(), code -> {});
    }

    private static String encode(String s) {
        return StringUtils.encode(s, ESCAPE);
    }

    public static String termToTemplateComponentString(ImmutableTerm term) {
        if (term instanceof Variable) {
            return "{" + TemplateParser.encode(((Variable)term).getName()) + "}";
        }
        if (term instanceof Constant) {
            return TemplateParser.encode(((Constant)term).getValue());
        }
        throw new IllegalArgumentException("Unexpected term type (only Constant and Variable are allowed):" + term);
    }

    public static String getEncodedTemplateString(ImmutableList<Template.Component> components) {
        return components.stream().map(c -> c.isColumnNameReference() ? "{}" : TemplateParser.encode(c.getComponent())).collect(Collectors.joining());
    }

    public static ImmutableList<Template.Component> getComponents(String template, boolean emptyPlaceholders) {
        Template.Builder builder = Template.builder();
        boolean escape = false;
        boolean insideCurlyBracket = false;
        int currentStart = 0;
        block5: for (int i = 0; i < template.length(); ++i) {
            if (escape) {
                escape = false;
                continue;
            }
            switch (template.charAt(i)) {
                case '{': {
                    if (insideCurlyBracket) {
                        throw new IllegalArgumentException("Nested curly brackets are not allowed");
                    }
                    if (i > currentStart) {
                        builder.addSeparator(TemplateParser.decode(template.substring(currentStart, i)));
                    }
                    currentStart = i + 1;
                    insideCurlyBracket = true;
                    continue block5;
                }
                case '}': {
                    if (!insideCurlyBracket) {
                        throw new IllegalArgumentException("No matching opening curly bracket");
                    }
                    if (i == currentStart != emptyPlaceholders) {
                        throw new IllegalArgumentException("Empty column reference");
                    }
                    builder.addColumn(TemplateParser.decode(template.substring(currentStart, i)));
                    currentStart = i + 1;
                    insideCurlyBracket = false;
                    continue block5;
                }
                case '\\': {
                    escape = true;
                }
            }
        }
        if (escape) {
            throw new IllegalArgumentException("Incomplete escape");
        }
        if (currentStart != template.length()) {
            if (insideCurlyBracket) {
                throw new IllegalArgumentException("No matching closing curly bracket");
            }
            builder.addSeparator(TemplateParser.decode(template.substring(currentStart)));
        }
        return builder.build();
    }
}

