/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.template;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import java.util.Objects;
import javax.annotation.Nullable;

public class Template {
    public static ImmutableList<Component> of(String prefix, int index) {
        if (index != 0) {
            throw new IllegalArgumentException("Index should be 0");
        }
        return ImmutableList.of((Object)new Component(prefix), (Object)new Component(index, ""));
    }

    public static ImmutableList<Component> of(String prefix, int index0, String separator, int index1) {
        if (index0 != 0) {
            throw new IllegalArgumentException("Index should be 0");
        }
        if (index1 != 1) {
            throw new IllegalArgumentException("Index should be 1");
        }
        return ImmutableList.of((Object)new Component(prefix), (Object)new Component(index0, ""), (Object)new Component(separator), (Object)new Component(index1, ""));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ImmutableList<Component> replaceFirst(ImmutableList<Component> components, String prefix) {
        if (prefix.isEmpty()) {
            return components.subList(1, components.size());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new Component(prefix));
        builder.addAll((Iterable)components.subList(1, components.size()));
        return builder.build();
    }

    public static ImmutableList<Component> replaceLast(ImmutableList<Component> components, String suffix) {
        if (suffix.isEmpty()) {
            return components.subList(0, components.size() - 1);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)components.subList(0, components.size() - 1));
        builder.add((Object)new Component(suffix));
        return builder.build();
    }

    public static class Component {
        private final String component;
        private final int index;

        Component(String component) {
            Objects.requireNonNull(component);
            this.component = component;
            this.index = -1;
        }

        Component(int index, @Nullable String component) {
            if (index < 0) {
                throw new IllegalArgumentException("Column template component index must be non-negative");
            }
            this.component = component;
            this.index = index;
        }

        public boolean isColumnNameReference() {
            return this.index >= 0;
        }

        public String getComponent() {
            return this.component;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.index >= 0 ? "_" + this.index + (this.component == null ? "" : "/" + this.component) + "_" : this.component;
        }

        public boolean equals(Object o) {
            if (o instanceof Component) {
                Component other = (Component)o;
                return this.index == -1 && other.index == -1 && this.component.equals(other.component) || this.index >= 0 && this.index == other.index;
            }
            return false;
        }

        public int hashCode() {
            return this.index == -1 ? this.component.hashCode() : Integer.hashCode(this.index);
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<Component> builder = ImmutableList.builder();
        private int index = 0;

        public Builder addColumn() {
            int index1 = this.index++;
            this.builder.add((Object)new Component(index1, ""));
            return this;
        }

        public Builder addColumn(String column) {
            int index1 = this.index++;
            this.builder.add((Object)new Component(index1, column));
            return this;
        }

        public Builder addSeparator(String separator) {
            this.builder.add((Object)new Component(separator));
            return this;
        }

        public ImmutableList<Component> build() {
            return this.builder.build();
        }
    }
}

