/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.type.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.iq.type.UniqueTermTypeExtractor;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.NotYetTypedEqualityFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public class NotYetTypedEqualityTransformerImpl
implements NotYetTypedEqualityTransformer {
    private final IQTreeTransformer expressionTransformer;

    @Inject
    protected NotYetTypedEqualityTransformerImpl(IntermediateQueryFactory iqFactory, UniqueTermTypeExtractor typeExtractor, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.expressionTransformer = new ExpressionTransformer(iqFactory, typeExtractor, termFactory, substitutionFactory);
    }

    @Override
    public IQTree transform(IQTree tree) {
        return this.expressionTransformer.transform(tree);
    }

    protected static class ExpressionTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final UniqueTermTypeExtractor typeExtractor;
        private final TermFactory termFactory;
        private final SubstitutionFactory substitutionFactory;

        protected ExpressionTransformer(IntermediateQueryFactory iqFactory, UniqueTermTypeExtractor typeExtractor, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
            super(iqFactory);
            this.typeExtractor = typeExtractor;
            this.termFactory = termFactory;
            this.substitutionFactory = substitutionFactory;
        }

        @Override
        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            ImmutableSubstitution<ImmutableTerm> initialSubstitution = rootNode.getSubstitution();
            ImmutableSubstitution<ImmutableTerm> newSubstitution = this.substitutionFactory.getSubstitution(initialSubstitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.transformTerm((ImmutableTerm)e.getValue(), child))));
            return newChild.equals(child) && newSubstitution.equals(initialSubstitution) ? tree : this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(rootNode.getVariables(), newSubstitution), newChild);
        }

        @Override
        public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            ImmutableSubstitution<ImmutableFunctionalTerm> initialSubstitution = rootNode.getSubstitution();
            ImmutableSubstitution<ImmutableFunctionalTerm> newSubstitution = this.substitutionFactory.getSubstitution(initialSubstitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.transformFunctionalTerm((ImmutableFunctionalTerm)e.getValue(), child))));
            return newChild.equals(child) && newSubstitution.equals(initialSubstitution) ? tree : this.iqFactory.createUnaryIQTree(this.iqFactory.createAggregationNode(rootNode.getGroupingVariables(), newSubstitution), newChild);
        }

        @Override
        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            ImmutableExpression initialExpression = rootNode.getFilterCondition();
            ImmutableExpression newExpression = this.transformExpression(initialExpression, tree);
            FilterNode newFilterNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeFilterCondition(newExpression);
            return newFilterNode.equals(rootNode) && newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree(newFilterNode, newChild);
        }

        @Override
        public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            ImmutableList<OrderByNode.OrderComparator> initialComparators = rootNode.getComparators();
            ImmutableList newComparators = (ImmutableList)initialComparators.stream().map(c -> this.iqFactory.createOrderComparator(this.transformNonGroundTerm(c.getTerm(), tree), c.isAscending())).collect(ImmutableCollectors.toList());
            return newComparators.equals(initialComparators) && newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree(this.iqFactory.createOrderByNode((ImmutableList<OrderByNode.OrderComparator>)newComparators), newChild);
        }

        @Override
        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            IQTree newLeftChild = this.transform(leftChild);
            IQTree newRightChild = this.transform(rightChild);
            Optional<ImmutableExpression> initialExpression = rootNode.getOptionalFilterCondition();
            Optional<ImmutableExpression> newExpression = initialExpression.map(e -> this.transformExpression((ImmutableExpression)e, tree));
            LeftJoinNode newLeftJoinNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeOptionalFilterCondition((Optional)newExpression);
            return newLeftJoinNode.equals(rootNode) && newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree(newLeftJoinNode, newLeftChild, newRightChild);
        }

        @Override
        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            ImmutableList newChildren = (ImmutableList)children.stream().map(this::transform).collect(ImmutableCollectors.toList());
            Optional<ImmutableExpression> initialExpression = rootNode.getOptionalFilterCondition();
            Optional<ImmutableExpression> newExpression = initialExpression.map(e -> this.transformExpression((ImmutableExpression)e, tree));
            InnerJoinNode newJoinNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeOptionalFilterCondition((Optional)newExpression);
            return newJoinNode.equals(rootNode) && newChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree(newJoinNode, (ImmutableList<IQTree>)newChildren);
        }

        protected ImmutableTerm transformTerm(ImmutableTerm term, IQTree tree) {
            return term instanceof ImmutableFunctionalTerm ? this.transformFunctionalTerm((ImmutableFunctionalTerm)term, tree) : term;
        }

        protected NonGroundTerm transformNonGroundTerm(NonGroundTerm term, IQTree tree) {
            return term instanceof ImmutableFunctionalTerm ? (NonGroundTerm)((Object)this.transformFunctionalTerm((ImmutableFunctionalTerm)((Object)term), tree)) : term;
        }

        protected ImmutableExpression transformExpression(ImmutableExpression expression, IQTree tree) {
            return (ImmutableExpression)this.transformFunctionalTerm(expression, tree);
        }

        protected ImmutableFunctionalTerm transformFunctionalTerm(ImmutableFunctionalTerm functionalTerm, IQTree tree) {
            ImmutableList<? extends ImmutableTerm> initialTerms = functionalTerm.getTerms();
            ImmutableList newTerms = (ImmutableList)initialTerms.stream().map(t -> t instanceof ImmutableFunctionalTerm ? this.transformFunctionalTerm((ImmutableFunctionalTerm)t, tree) : t).collect(ImmutableCollectors.toList());
            FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
            if (functionSymbol instanceof NotYetTypedEqualityFunctionSymbol) {
                return this.transformEquality((ImmutableList<ImmutableTerm>)newTerms, tree);
            }
            return newTerms.equals(initialTerms) ? functionalTerm : this.termFactory.getImmutableFunctionalTerm(functionSymbol, (ImmutableList<? extends ImmutableTerm>)newTerms);
        }

        protected ImmutableExpression transformEquality(ImmutableList<ImmutableTerm> newTerms, IQTree tree) {
            if (newTerms.size() != 2) {
                throw new MinorOntopInternalBugException("Was expecting the not yet typed equalities to be binary");
            }
            ImmutableTerm term1 = (ImmutableTerm)newTerms.get(0);
            ImmutableTerm term2 = (ImmutableTerm)newTerms.get(1);
            ImmutableList extractedTypes = (ImmutableList)newTerms.stream().map(t -> this.typeExtractor.extractUniqueTermType((ImmutableTerm)t, tree)).collect(ImmutableCollectors.toList());
            if (extractedTypes.stream().allMatch(type -> type.filter(t -> t instanceof DBTermType).isPresent())) {
                DBTermType type2;
                ImmutableList types = (ImmutableList)extractedTypes.stream().map(Optional::get).map(t -> (DBTermType)t).collect(ImmutableCollectors.toList());
                DBTermType type1 = (DBTermType)types.get(0);
                return type1.equals(type2 = (DBTermType)types.get(1)) ? this.transformSameTypeEquality(type1, term1, term2, tree) : this.transformDifferentTypesEquality(type1, type2, term1, term2);
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        private ImmutableExpression transformSameTypeEquality(DBTermType type, ImmutableTerm term1, ImmutableTerm term2, IQTree tree) {
            if (type.areEqualitiesStrict()) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            if (this.areIndependentFromConstants(term1, term2, tree) && type.areEqualitiesBetweenTwoDBAttributesStrict()) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            switch (type.getCategory()) {
                case DECIMAL: 
                case FLOAT_DOUBLE: {
                    return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                }
                case DATETIME: {
                    return this.termFactory.getDBNonStrictDatetimeEquality(term1, term2);
                }
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        protected ImmutableExpression transformDifferentTypesEquality(DBTermType type1, DBTermType type2, ImmutableTerm term1, ImmutableTerm term2) {
            if (this.areCompatibleForStrictEq(type1, type2)) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            DBTermType.Category category1 = type1.getCategory();
            DBTermType.Category category2 = type2.getCategory();
            switch (category1) {
                case INTEGER: 
                case STRING: {
                    switch (category2) {
                        case DECIMAL: 
                        case FLOAT_DOUBLE: {
                            return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                        }
                    }
                    break;
                }
                case DECIMAL: 
                case FLOAT_DOUBLE: {
                    switch (category2) {
                        case DECIMAL: 
                        case FLOAT_DOUBLE: 
                        case INTEGER: {
                            return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                        }
                    }
                    break;
                }
                case DATETIME: {
                    if (category2 != DBTermType.Category.DATETIME) break;
                    return this.termFactory.getDBNonStrictDatetimeEquality(term1, term2);
                }
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        protected boolean areIndependentFromConstants(ImmutableTerm term1, ImmutableTerm term2, IQTree tree) {
            return !(term1 instanceof DBConstant) && !(term2 instanceof DBConstant);
        }

        private boolean areCompatibleForStrictEq(DBTermType type1, DBTermType type2) {
            return Stream.of(type1.areEqualitiesStrict(type2), type2.areEqualitiesStrict(type1)).filter(Optional::isPresent).map(Optional::get).reduce((b1, b2) -> b1 != false && b2 != false).orElse(false);
        }
    }
}

