/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transform.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.impl.QueryNodeRenamer;
import it.unibz.inf.ontop.iq.transform.QueryRenamer;
import it.unibz.inf.ontop.iq.transform.impl.HomogeneousIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;

public class QueryRenamerImpl
implements QueryRenamer {
    private final InjectiveVar2VarSubstitution renamingSubstitution;
    private final IntermediateQueryFactory iqFactory;
    private final AtomFactory atomFactory;

    @AssistedInject
    private QueryRenamerImpl(@Assisted InjectiveVar2VarSubstitution injectiveVar2VarSubstitution, IntermediateQueryFactory iqFactory, AtomFactory atomFactory) {
        this.renamingSubstitution = injectiveVar2VarSubstitution;
        this.iqFactory = iqFactory;
        this.atomFactory = atomFactory;
    }

    private DistinctVariableOnlyDataAtom transformProjectionAtom(DistinctVariableOnlyDataAtom atom) {
        ImmutableList newArguments = (ImmutableList)atom.getArguments().stream().map(this.renamingSubstitution::applyToVariable).collect(ImmutableCollectors.toList());
        return this.atomFactory.getDistinctVariableOnlyDataAtom((AtomPredicate)atom.getPredicate(), (ImmutableList<Variable>)newArguments);
    }

    @Override
    public IQ transform(IQ originalQuery) {
        QueryNodeRenamer nodeTransformer = new QueryNodeRenamer(this.iqFactory, this.renamingSubstitution, this.atomFactory);
        HomogeneousIQTreeVisitingTransformer iqTransformer = new HomogeneousIQTreeVisitingTransformer(nodeTransformer, this.iqFactory);
        IQTree newIQTree = originalQuery.getTree().acceptTransformer(iqTransformer);
        DistinctVariableOnlyDataAtom newProjectionAtom = this.transformProjectionAtom(originalQuery.getProjectionAtom());
        return this.iqFactory.createIQ(newProjectionAtom, newIQTree);
    }
}

