/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transform.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.NoNullValueEnforcer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.model.term.FunctionalTermSimplification;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class NoNullValuesEnforcerImpl
implements NoNullValueEnforcer {
    private final IntermediateQueryFactory iQFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    private final CoreUtilsFactory coreUtilsFactory;

    @Inject
    private NoNullValuesEnforcerImpl(IntermediateQueryFactory iQFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory, CoreUtilsFactory coreUtilsFactory) {
        this.iQFactory = iQFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.coreUtilsFactory = coreUtilsFactory;
    }

    @Override
    public IQTree transform(IQTree tree) {
        return this.transform(tree, this.coreUtilsFactory.createVariableGenerator((Collection<Variable>)tree.getKnownVariables()));
    }

    private IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        Optional<ImmutableExpression> condition = this.termFactory.getConjunction(tree.getVariables().stream().map(this.termFactory::getDBIsNotNull));
        return condition.map(this.iQFactory::createFilterNode).map(n -> this.iQFactory.createUnaryIQTree((UnaryOperatorNode)n, tree)).map(t -> t.normalizeForOptimization(variableGenerator)).map(this::declareTopVariablesNotNull).orElse(tree);
    }

    protected IQTree declareTopVariablesNotNull(IQTree tree) {
        NotNullTopVariablePropagator transformer = new NotNullTopVariablePropagator(this.iQFactory, this.substitutionFactory, tree.getVariables());
        return transformer.transform(tree);
    }

    protected static class NotNullTopVariablePropagator
    extends DefaultNonRecursiveIQTreeTransformer {
        protected final IntermediateQueryFactory iqFactory;
        protected final ImmutableSet<Variable> nonNullVariables;
        private final SubstitutionFactory substitutionFactory;

        protected NotNullTopVariablePropagator(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, ImmutableSet<Variable> nonNullVariables) {
            this.iqFactory = iqFactory;
            this.substitutionFactory = substitutionFactory;
            this.nonNullVariables = nonNullVariables;
        }

        @Override
        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            IQTree newChild;
            ImmutableSubstitution<ImmutableTerm> initialSubstitution = rootNode.getSubstitution();
            ImmutableMap<Variable, FunctionalTermSimplification> updatedEntryMap = initialSubstitution.getFragment(ImmutableFunctionalTerm.class).getImmutableMap().entrySet().stream().filter(e -> this.nonNullVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ((ImmutableFunctionalTerm)e.getValue()).simplifyAsGuaranteedToBeNonNull()));
            ImmutableMap newSubstitutionMap = initialSubstitution.getImmutableMap().entrySet().stream().map(e -> Optional.ofNullable(updatedEntryMap.get(e.getKey())).map(s -> Maps.immutableEntry(e.getKey(), (Object)s.getSimplifiedTerm())).orElse((Map.Entry)e)).collect(ImmutableCollectors.toMap());
            ConstructionNode newConstructionNode = initialSubstitution.getImmutableMap().equals(newSubstitutionMap) ? rootNode : this.iqFactory.createConstructionNode(rootNode.getVariables(), this.substitutionFactory.getSubstitution(newSubstitutionMap));
            ImmutableSet simplifiableChildVariables = Sets.union((Set)Sets.difference(rootNode.getVariables(), initialSubstitution.getDomain()), (Set)((Set)updatedEntryMap.values().stream().flatMap(s -> s.getSimplifiableVariables().stream()).collect(ImmutableCollectors.toSet()))).immutableCopy();
            IQTree iQTree = newChild = simplifiableChildVariables.isEmpty() ? child : new NotNullTopVariablePropagator(this.iqFactory, this.substitutionFactory, (ImmutableSet<Variable>)simplifiableChildVariables).transform(child);
            if (newConstructionNode == rootNode && newChild == child) {
                return tree;
            }
            return this.iqFactory.createUnaryIQTree(newConstructionNode, newChild);
        }

        @Override
        public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
            IQTree newChild = this.transform(child);
            return newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree(rootNode, newChild);
        }
    }
}

