/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transform.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;

public class ChildTransformer
extends DefaultNonRecursiveIQTreeTransformer {
    private final IntermediateQueryFactory iqFactory;
    private final IQTreeTransformer transformer;

    public ChildTransformer(IntermediateQueryFactory iqFactory, IQTreeTransformer transformer) {
        this.iqFactory = iqFactory;
        this.transformer = transformer;
    }

    @Override
    protected IQTree transformLeaf(LeafIQTree leaf) {
        return leaf;
    }

    @Override
    protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
        return this.iqFactory.createUnaryIQTree(rootNode, this.transformer.transform(child));
    }

    @Override
    protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
        return this.iqFactory.createNaryIQTree(rootNode, (ImmutableList<IQTree>)((ImmutableList)children.stream().map(this.transformer::transform).collect(ImmutableCollectors.toList())));
    }

    @Override
    protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
        return this.iqFactory.createBinaryNonCommutativeIQTree(rootNode, this.transformer.transform(leftChild), this.transformer.transform(rightChild));
    }
}

