/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.tools.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.iq.tools.ProjectionDecomposer;
import it.unibz.inf.ontop.iq.tools.impl.ProjectionDecompositionImpl;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ProjectionDecomposerImpl
implements ProjectionDecomposer {
    private final Predicate<ImmutableFunctionalTerm> decompositionOracle;
    private final Predicate<NonFunctionalTerm> postprocessNonFunctionalDefinitionOracle;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    @AssistedInject
    private ProjectionDecomposerImpl(@Assisted Predicate<ImmutableFunctionalTerm> decompositionOracle, @Assisted Predicate<NonFunctionalTerm> postprocessNonFunctionalDefinitionOracle, SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        this.decompositionOracle = decompositionOracle;
        this.postprocessNonFunctionalDefinitionOracle = postprocessNonFunctionalDefinitionOracle;
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
    }

    @Override
    public ProjectionDecomposer.ProjectionDecomposition decomposeSubstitution(ImmutableSubstitution<? extends ImmutableTerm> substitution, VariableGenerator variableGenerator) {
        ImmutableMap<Variable, DefinitionDecomposition> decompositionMap = substitution.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.decomposeDefinition((ImmutableTerm)e.getValue(), variableGenerator, Optional.of(e.getKey()))));
        ImmutableMap<Variable, ImmutableTerm> topSubstitutionMap = decompositionMap.entrySet().stream().filter(e -> !((Variable)e.getKey()).equals(((DefinitionDecomposition)e.getValue()).term)).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ((DefinitionDecomposition)e.getValue()).term));
        ImmutableSubstitution<ImmutableTerm> topSubstitution = this.substitutionFactory.getSubstitution(topSubstitutionMap);
        Optional<ImmutableSubstitution<ImmutableTerm>> subSubstitution = this.combineSubstitutions(decompositionMap.values().stream().map(d -> d.substitution));
        return subSubstitution.map(s -> topSubstitution.isEmpty() ? ProjectionDecompositionImpl.createSubSubstitutionDecomposition(s) : ProjectionDecompositionImpl.createDecomposition(topSubstitution, s)).orElseGet(() -> ProjectionDecompositionImpl.createTopSubstitutionDecomposition(topSubstitution));
    }

    private DefinitionDecomposition decomposeDefinition(ImmutableTerm term, VariableGenerator variableGenerator, Optional<Variable> definedVariable) {
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            if (this.decompositionOracle.test(functionalTerm)) {
                ImmutableList childDecompositions = (ImmutableList)functionalTerm.getTerms().stream().map(t -> this.decomposeDefinition((ImmutableTerm)t, variableGenerator, Optional.empty())).collect(ImmutableCollectors.toList());
                Optional<ImmutableSubstitution<ImmutableTerm>> subSubstitution = this.combineSubstitutions(childDecompositions.stream().map(d -> d.substitution));
                ImmutableFunctionalTerm newFunctionalTerm = subSubstitution.map(s -> (ImmutableList)childDecompositions.stream().map(d -> d.term).collect(ImmutableCollectors.toList())).map(children -> this.termFactory.getImmutableFunctionalTerm(functionalTerm.getFunctionSymbol(), (ImmutableList<? extends ImmutableTerm>)children)).orElse(functionalTerm);
                return subSubstitution.map(s -> new DefinitionDecomposition(newFunctionalTerm, (ImmutableSubstitution)s)).orElse(new DefinitionDecomposition((ImmutableTerm)functionalTerm));
            }
            Variable variable = definedVariable.orElseGet(variableGenerator::generateNewVariable);
            Variable newTerm = !definedVariable.isPresent() && functionalTerm instanceof ImmutableExpression ? this.termFactory.getIsTrue(variable) : variable;
            return new DefinitionDecomposition(newTerm, this.substitutionFactory.getSubstitution(variable, functionalTerm));
        }
        if (definedVariable.isPresent() && !this.postprocessNonFunctionalDefinitionOracle.test((NonFunctionalTerm)term)) {
            Variable variable = definedVariable.get();
            return new DefinitionDecomposition(variable, this.substitutionFactory.getSubstitution(variable, term));
        }
        return new DefinitionDecomposition(term);
    }

    private Optional<ImmutableSubstitution<ImmutableTerm>> combineSubstitutions(Stream<Optional<ImmutableSubstitution<ImmutableTerm>>> stream) {
        return stream.filter(Optional::isPresent).map(Optional::get).reduce(ImmutableSubstitution::composeWith);
    }

    private static class DefinitionDecomposition {
        final ImmutableTerm term;
        final Optional<ImmutableSubstitution<ImmutableTerm>> substitution;

        private DefinitionDecomposition(ImmutableTerm term, ImmutableSubstitution<ImmutableTerm> substitution) {
            this.term = term;
            this.substitution = Optional.of(substitution);
        }

        private DefinitionDecomposition(ImmutableTerm term) {
            this.term = term;
            this.substitution = Optional.empty();
        }
    }
}

