/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.tools.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.IntermediateQueryBuilder;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.exception.EmptyQueryException;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.BinaryOrderedOperatorNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.tools.ExecutorRegistry;
import it.unibz.inf.ontop.iq.tools.IQConverter;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.concurrent.atomic.AtomicInteger;

@Singleton
public class IQConverterImpl
implements IQConverter {
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private IQConverterImpl(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ convert(IntermediateQuery query) {
        IQTree tree = this.convertTree(query, query.getRootNode());
        return this.iqFactory.createIQ(query.getProjectionAtom(), tree);
    }

    @Override
    public IQTree convertTree(IntermediateQuery query, QueryNode rootNode) {
        if (rootNode instanceof LeafIQTree) {
            return (LeafIQTree)rootNode;
        }
        if (rootNode instanceof UnaryOperatorNode) {
            IQTree childTree = this.convertTree(query, query.getFirstChild(rootNode).get());
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, childTree);
        }
        if (rootNode instanceof BinaryNonCommutativeOperatorNode) {
            IQTree leftChildTree = this.convertTree(query, query.getChild(rootNode, BinaryOrderedOperatorNode.ArgumentPosition.LEFT).get());
            IQTree rightChildTree = this.convertTree(query, query.getChild(rootNode, BinaryOrderedOperatorNode.ArgumentPosition.RIGHT).get());
            return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, leftChildTree, rightChildTree);
        }
        if (rootNode instanceof NaryOperatorNode) {
            ImmutableList childTrees = (ImmutableList)query.getChildren(rootNode).stream().map(c -> this.convertTree(query, (QueryNode)c)).collect(ImmutableCollectors.toList());
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, (ImmutableList<IQTree>)childTrees);
        }
        throw new MinorOntopInternalBugException("Unexpected type of query node: " + rootNode);
    }

    @Override
    public IntermediateQuery convert(IQ query, ExecutorRegistry executorRegistry) throws EmptyQueryException {
        if (query.getTree().isDeclaredAsEmpty()) {
            throw new EmptyQueryException();
        }
        IntermediateQueryBuilder queryBuilder = this.iqFactory.createIQBuilder(executorRegistry);
        IQTree topTree = query.getTree();
        QueryNode rootNode = topTree.getRootNode();
        queryBuilder.init(query.getProjectionAtom(), rootNode);
        this.insertChildren(rootNode, topTree.getChildren(), queryBuilder);
        return queryBuilder.build();
    }

    private void insertChildren(QueryNode parentNode, ImmutableList<IQTree> childrenTrees, IntermediateQueryBuilder queryBuilder) {
        AtomicInteger i = new AtomicInteger(0);
        childrenTrees.stream().map(IQTree::getRootNode).map(n -> queryBuilder.contains((QueryNode)n) ? n.clone() : n).forEach(t -> this.insertChildTree(parentNode, (QueryNode)t, (IQTree)childrenTrees.get(i.get()), queryBuilder, i.getAndIncrement()));
    }

    private void insertChildTree(QueryNode parent, QueryNode child, IQTree childTree, IntermediateQueryBuilder queryBuilder, int position) {
        if (parent instanceof BinaryOrderedOperatorNode) {
            queryBuilder.addChild(parent, child, position == 0 ? BinaryOrderedOperatorNode.ArgumentPosition.LEFT : BinaryOrderedOperatorNode.ArgumentPosition.RIGHT);
        } else {
            queryBuilder.addChild(parent, child);
        }
        this.insertChildren(child, childTree.getChildren(), queryBuilder);
    }
}

