/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.transform.impl.DefaultIdentityIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@Singleton
public class RightProvenanceNormalizer {
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    @Inject
    protected RightProvenanceNormalizer(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
        this.termFactory = coreSingletons.getTermFactory();
    }

    public RightProvenance normalizeRightProvenance(IQTree rightTree, ImmutableSet<Variable> leftVariables, Optional<ImmutableExpression> leftJoinExpression, VariableGenerator variableGenerator) {
        ImmutableSet<Variable> rightVariables = rightTree.getVariables();
        VariableNullability rightNullability = leftJoinExpression.flatMap(e -> this.termFactory.getConjunction(e.flattenAND().filter(e1 -> rightVariables.containsAll(e1.getVariables())))).map(e -> this.iqFactory.createUnaryIQTree(this.iqFactory.createFilterNode((ImmutableExpression)e), rightTree).getVariableNullability()).orElseGet(rightTree::getVariableNullability);
        return this.normalizeRightProvenance(rightTree, leftVariables, rightTree.getVariables(), variableGenerator, rightNullability);
    }

    public RightProvenance normalizeRightProvenance(IQTree rightTree, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightRequiredVariables, VariableGenerator variableGenerator) {
        return this.normalizeRightProvenance(rightTree, leftVariables, rightRequiredVariables, variableGenerator, rightTree.getVariableNullability());
    }

    private RightProvenance normalizeRightProvenance(IQTree rightTree, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> rightRequiredVariables, VariableGenerator variableGenerator, VariableNullability rightNullability) {
        ImmutableSet<Variable> rightVariables = rightTree.getVariables();
        Optional<Variable> nonNullableRightVariable = rightVariables.stream().filter(v -> !leftVariables.contains(v)).filter(v -> !rightNullability.isPossiblyNullable((Variable)v)).findFirst();
        if (nonNullableRightVariable.isPresent()) {
            return new RightProvenance(nonNullableRightVariable.get(), rightTree);
        }
        IQTree transformedRightTree = new FreshVariableTransformer(this.coreSingletons, variableGenerator).transform(rightTree);
        return transformedRightTree != rightTree && !transformedRightTree.getVariables().equals(rightVariables) ? this.extractProvenanceFromTransformedTree(transformedRightTree, rightVariables) : this.createProvenanceInConstructionNode(rightTree, rightRequiredVariables, variableGenerator);
    }

    private RightProvenance extractProvenanceFromTransformedTree(IQTree transformedRightTree, ImmutableSet<Variable> rightVariables) {
        Variable newVariable = (Variable)Sets.difference(transformedRightTree.getVariables(), rightVariables).iterator().next();
        return new RightProvenance(newVariable, transformedRightTree);
    }

    private RightProvenance createProvenanceInConstructionNode(IQTree rightTree, ImmutableSet<Variable> rightRequiredVariables, VariableGenerator variableGenerator) {
        Variable provenanceVariable = variableGenerator.generateNewVariable();
        ImmutableSet newRightProjectedVariables = (ImmutableSet)Stream.concat(Stream.of(provenanceVariable), rightRequiredVariables.stream()).collect(ImmutableCollectors.toSet());
        ConstructionNode newRightConstructionNode = this.iqFactory.createConstructionNode((ImmutableSet<Variable>)newRightProjectedVariables, this.substitutionFactory.getSubstitution(provenanceVariable, this.termFactory.getProvenanceSpecialConstant()));
        UnaryIQTree newRightTree = this.iqFactory.createUnaryIQTree(newRightConstructionNode, rightTree);
        return new RightProvenance(provenanceVariable, newRightTree);
    }

    public static class RightProvenance {
        private final Variable variable;
        private final IQTree rightTree;

        protected RightProvenance(Variable provenanceVariable, IQTree rightTree) {
            this.variable = provenanceVariable;
            this.rightTree = rightTree;
        }

        public Variable getProvenanceVariable() {
            return this.variable;
        }

        public IQTree getRightTree() {
            return this.rightTree;
        }
    }

    protected static class FreshVariableTransformer
    extends DefaultIdentityIQTreeVisitingTransformer {
        private final IntermediateQueryFactory iqFactory;
        private final VariableGenerator variableGenerator;

        public FreshVariableTransformer(CoreSingletons coreSingletons, VariableGenerator variableGenerator) {
            this.iqFactory = coreSingletons.getIQFactory();
            this.variableGenerator = variableGenerator;
        }

        @Override
        public IQTree transformExtensionalData(ExtensionalDataNode dataNode) {
            ImmutableList<Attribute> attributes = dataNode.getRelationDefinition().getAttributes();
            ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap = dataNode.getArgumentMap();
            Optional<Integer> optionalIndex = IntStream.range(0, attributes.size()).filter(i -> !argumentMap.containsKey((Object)i)).filter(i -> !((Attribute)attributes.get(i)).isNullable()).boxed().findFirst();
            return optionalIndex.map(i -> Stream.concat(argumentMap.entrySet().stream(), Stream.of(Maps.immutableEntry((Object)i, (Object)this.variableGenerator.generateNewVariable("prov")))).collect(ImmutableCollectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).map(m -> this.iqFactory.createExtensionalDataNode(dataNode.getRelationDefinition(), (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)m)).orElse(dataNode);
        }

        @Override
        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            IQTree newLeftChild = leftChild.acceptTransformer(this);
            return this.hasNotChanged(newLeftChild, leftChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree(rootNode, newLeftChild, rightChild);
        }

        boolean hasNotChanged(IQTree newChild, IQTree formerChild) {
            return newChild == formerChild || newChild.getVariables().equals(formerChild.getVariables());
        }

        @Override
        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            for (int i = 0; i < children.size(); ++i) {
                IQTree child = (IQTree)children.get(i);
                IQTree newChild = child.acceptTransformer(this);
                if (this.hasNotChanged(newChild, child)) continue;
                int indexToReplace = i;
                ImmutableList newChildren = (ImmutableList)IntStream.range(0, children.size()).mapToObj(j -> j == indexToReplace ? newChild : (IQTree)children.get(j)).collect(ImmutableCollectors.toList());
                return this.iqFactory.createNaryIQTree(rootNode, (ImmutableList<IQTree>)newChildren);
            }
            return tree;
        }
    }
}

