/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.CommutativeJoinNode;
import it.unibz.inf.ontop.iq.node.CommutativeJoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.JoinOrFilterVariableNullabilityTools;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.InnerJoinNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.impl.JoinLikeChildBindingLifter;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class InnerJoinNormalizerImpl
implements InnerJoinNormalizer {
    private static final int MAX_ITERATIONS = 10000;
    private static final int BINDING_LIFT_ITERATIONS = 1000;
    private final JoinLikeChildBindingLifter bindingLift;
    private final IntermediateQueryFactory iqFactory;
    private final ConstructionSubstitutionNormalizer substitutionNormalizer;
    private final ConditionSimplifier conditionSimplifier;
    private final TermFactory termFactory;
    private final JoinOrFilterVariableNullabilityTools variableNullabilityTools;

    @Inject
    private InnerJoinNormalizerImpl(JoinLikeChildBindingLifter bindingLift, IntermediateQueryFactory iqFactory, ConstructionSubstitutionNormalizer substitutionNormalizer, ConditionSimplifier conditionSimplifier, TermFactory termFactory, JoinOrFilterVariableNullabilityTools variableNullabilityTools) {
        this.bindingLift = bindingLift;
        this.iqFactory = iqFactory;
        this.substitutionNormalizer = substitutionNormalizer;
        this.conditionSimplifier = conditionSimplifier;
        this.termFactory = termFactory;
        this.variableNullabilityTools = variableNullabilityTools;
    }

    @Override
    public IQTree normalizeForOptimization(InnerJoinNode innerJoinNode, ImmutableList<IQTree> children, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        State state = new State(children, innerJoinNode.getOptionalFilterCondition(), variableGenerator);
        for (int i = 0; i < 10000; ++i) {
            State newState = this.liftBindingsAndDistincts(state).liftChildProjectingAwayConstructionNodes().liftConditionAndMergeJoins();
            if (newState.equals(state)) {
                return newState.liftLeftJoinAndCreateNormalizedTree(currentIQProperties);
            }
            state = newState;
        }
        throw new MinorOntopInternalBugException("InnerJoin.liftBinding() did not converge after 10000");
    }

    private State liftBindingsAndDistincts(State initialState) {
        State state = initialState;
        for (int i = 0; i < 10000; ++i) {
            State newState = state.propagateDownCondition().liftBindings().liftDistincts();
            if (newState.equals(state)) {
                return newState;
            }
            state = newState;
        }
        throw new MinorOntopInternalBugException("InnerJoin.liftBinding() did not converge after 10000");
    }

    private static ImmutableSet<Variable> extractProjectedVariables(ImmutableList<IQTree> children) {
        return (ImmutableSet)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
    }

    private static class ConditionAndTrees {
        final Optional<ImmutableExpression> condition;
        final Stream<IQTree> trees;

        ConditionAndTrees(ImmutableExpression condition, Stream<IQTree> trees) {
            this.condition = Optional.of(condition);
            this.trees = trees;
        }

        ConditionAndTrees(Stream<IQTree> trees) {
            this.condition = Optional.empty();
            this.trees = trees;
        }
    }

    private class State {
        private final ImmutableSet<Variable> projectedVariables;
        private final ImmutableList<UnaryOperatorNode> ancestors;
        private final ImmutableList<IQTree> children;
        private final Optional<ImmutableExpression> joiningCondition;
        private final VariableGenerator variableGenerator;
        private final VariableNullability childrenVariableNullability;

        private State(ImmutableSet<Variable> projectedVariables, ImmutableList<UnaryOperatorNode> ancestors, ImmutableList<IQTree> children, Optional<ImmutableExpression> joiningCondition, VariableGenerator variableGenerator, VariableNullability childrenVariableNullability) {
            this.projectedVariables = projectedVariables;
            this.ancestors = ancestors;
            this.children = children;
            this.joiningCondition = joiningCondition;
            this.variableGenerator = variableGenerator;
            this.childrenVariableNullability = childrenVariableNullability;
        }

        public State(ImmutableList<IQTree> children, Optional<ImmutableExpression> joiningCondition, VariableGenerator variableGenerator) {
            this((ImmutableSet<Variable>)InnerJoinNormalizerImpl.extractProjectedVariables((ImmutableList<IQTree>)children), (ImmutableList<UnaryOperatorNode>)ImmutableList.of(), children, joiningCondition, variableGenerator, innerJoinNormalizerImpl.variableNullabilityTools.getChildrenVariableNullability(children));
        }

        private State updateChildren(ImmutableList<IQTree> newChildren) {
            if (this.children.equals(newChildren)) {
                return this;
            }
            return new State(this.projectedVariables, this.ancestors, newChildren, this.joiningCondition, this.variableGenerator, InnerJoinNormalizerImpl.this.variableNullabilityTools.getChildrenVariableNullability(newChildren));
        }

        private State updateConditionAndChildren(Optional<ImmutableExpression> newCondition, ImmutableList<IQTree> newChildren) {
            return new State(this.projectedVariables, this.ancestors, newChildren, newCondition, this.variableGenerator, InnerJoinNormalizerImpl.this.variableNullabilityTools.getChildrenVariableNullability(newChildren));
        }

        private State updateParentConditionAndChildren(UnaryOperatorNode newParent, Optional<ImmutableExpression> newCondition, ImmutableList<IQTree> newChildren) {
            ImmutableList newAncestors = ImmutableList.builder().add((Object)newParent).addAll(this.ancestors).build();
            return new State(this.projectedVariables, (ImmutableList<UnaryOperatorNode>)newAncestors, newChildren, newCondition, this.variableGenerator, InnerJoinNormalizerImpl.this.variableNullabilityTools.getChildrenVariableNullability(newChildren));
        }

        private State declareAsEmpty() {
            EmptyNode emptyChild = InnerJoinNormalizerImpl.this.iqFactory.createEmptyNode(this.projectedVariables);
            return new State(this.projectedVariables, (ImmutableList<UnaryOperatorNode>)ImmutableList.of(), (ImmutableList<IQTree>)ImmutableList.of((Object)emptyChild), Optional.empty(), this.variableGenerator, this.childrenVariableNullability);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State other = (State)o;
            return this.joiningCondition.equals(other.joiningCondition) && this.children.size() == other.children.size() && IntStream.range(0, this.children.size()).allMatch(i -> ((IQTree)this.children.get(i)).isEquivalentTo((IQTree)other.children.get(i))) && this.ancestors.size() == other.ancestors.size() && IntStream.range(0, this.ancestors.size()).allMatch(i -> ((UnaryOperatorNode)this.ancestors.get(i)).isEquivalentTo((QueryNode)other.ancestors.get(i))) && this.projectedVariables.equals(other.projectedVariables);
        }

        public State liftBindings() {
            State state = this;
            for (int i = 0; i < 1000; ++i) {
                State newState = state.liftChildBinding();
                if (newState.equals(state)) {
                    return newState;
                }
                state = newState;
            }
            return state;
        }

        private State liftChildBinding() {
            ImmutableList liftedChildren = (ImmutableList)this.children.stream().map(c -> c.normalizeForOptimization(this.variableGenerator)).filter(c -> !(c.getRootNode() instanceof TrueNode)).collect(ImmutableCollectors.toList());
            if (liftedChildren.stream().anyMatch(IQTree::isDeclaredAsEmpty)) {
                return this.declareAsEmpty();
            }
            OptionalInt optionalSelectedLiftedChildPosition = IntStream.range(0, liftedChildren.size()).filter(i -> ((IQTree)liftedChildren.get(i)).getRootNode() instanceof ConstructionNode).filter(i -> !((ConstructionNode)((IQTree)liftedChildren.get(i)).getRootNode()).getSubstitution().isEmpty()).findFirst();
            if (!optionalSelectedLiftedChildPosition.isPresent()) {
                return this.updateChildren((ImmutableList<IQTree>)liftedChildren);
            }
            int selectedChildPosition = optionalSelectedLiftedChildPosition.getAsInt();
            UnaryIQTree selectedLiftedChild = (UnaryIQTree)liftedChildren.get(selectedChildPosition);
            ConstructionNode selectedChildConstructionNode = (ConstructionNode)selectedLiftedChild.getRootNode();
            IQTree selectedGrandChild = selectedLiftedChild.getChild();
            ImmutableSet<Variable> requiredGrandChildVariables = selectedChildConstructionNode.getChildVariables();
            IQTree selectedGrandChildWithLimitedProjection = selectedGrandChild.getVariables().equals(requiredGrandChildVariables) ? selectedGrandChild : InnerJoinNormalizerImpl.this.iqFactory.createUnaryIQTree(InnerJoinNormalizerImpl.this.iqFactory.createConstructionNode(requiredGrandChildVariables), selectedGrandChild);
            VariableNullability newChildrenVariableNullability = InnerJoinNormalizerImpl.this.variableNullabilityTools.getChildrenVariableNullability((ImmutableList<IQTree>)((ImmutableList)IntStream.range(0, liftedChildren.size()).boxed().map(i -> i == selectedChildPosition ? selectedGrandChildWithLimitedProjection : (IQTree)liftedChildren.get(i.intValue())).collect(ImmutableCollectors.toList())));
            try {
                return InnerJoinNormalizerImpl.this.bindingLift.liftRegularChildBinding(selectedChildConstructionNode, selectedChildPosition, selectedGrandChildWithLimitedProjection, (ImmutableList<IQTree>)liftedChildren, (ImmutableSet<Variable>)ImmutableSet.of(), this.joiningCondition, this.variableGenerator, newChildrenVariableNullability, this::convertIntoState);
            }
            catch (UnsatisfiableConditionException e) {
                return this.declareAsEmpty();
            }
        }

        private State convertIntoState(ImmutableList<IQTree> liftedChildren, IQTree selectedGrandChild, int selectedChildPosition, Optional<ImmutableExpression> notNormalizedCondition, ImmutableSubstitution<ImmutableTerm> ascendingSubstitution, ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution) {
            ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = InnerJoinNormalizerImpl.this.substitutionNormalizer.normalizeSubstitution(ascendingSubstitution, (ImmutableSet<Variable>)InnerJoinNormalizerImpl.extractProjectedVariables((ImmutableList<IQTree>)liftedChildren));
            Optional<ImmutableExpression> newCondition = notNormalizedCondition.map(normalization::updateExpression);
            Optional<ConstructionNode> newParent = normalization.generateTopConstructionNode();
            ImmutableList newChildren = (ImmutableList)IntStream.range(0, liftedChildren.size()).boxed().map(i -> i == selectedChildPosition ? selectedGrandChild.applyDescendingSubstitution(descendingSubstitution, newCondition) : ((IQTree)liftedChildren.get(i.intValue())).applyDescendingSubstitution(descendingSubstitution, newCondition)).map(normalization::updateChild).collect(ImmutableCollectors.toList());
            return newParent.map(p -> this.updateParentConditionAndChildren((UnaryOperatorNode)p, newCondition, (ImmutableList<IQTree>)newChildren)).orElseGet(() -> this.updateConditionAndChildren(newCondition, (ImmutableList<IQTree>)newChildren));
        }

        public IQTree liftLeftJoinAndCreateNormalizedTree(IQProperties currentIQProperties) {
            IQProperties normalizedIQProperties = currentIQProperties.declareNormalizedForOptimization();
            IQTree joinLevelTree = this.createJoinOrFilterOrEmptyOrLiftLeft(normalizedIQProperties);
            if (joinLevelTree.isDeclaredAsEmpty()) {
                return joinLevelTree;
            }
            IQTree ancestorTree = this.ancestors.stream().reduce(joinLevelTree, (t, n) -> InnerJoinNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, (IQTree)t), (t1, t2) -> {
                throw new MinorOntopInternalBugException("The order must be respected");
            });
            IQTree nonNormalizedTree = ancestorTree.getVariables().equals(this.projectedVariables) ? ancestorTree : InnerJoinNormalizerImpl.this.iqFactory.createUnaryIQTree(InnerJoinNormalizerImpl.this.iqFactory.createConstructionNode(this.projectedVariables), ancestorTree);
            return nonNormalizedTree.normalizeForOptimization(this.variableGenerator);
        }

        private boolean isLeftJoinToLiftAboveJoin(int i) {
            IQTree currentChild = (IQTree)this.children.get(i);
            if (currentChild.getRootNode() instanceof LeftJoinNode) {
                BinaryNonCommutativeIQTree leftJoinTree = (BinaryNonCommutativeIQTree)currentChild;
                Sets.SetView rightSpecificVariables = Sets.difference(leftJoinTree.getRightChild().getVariables(), leftJoinTree.getLeftChild().getVariables());
                return IntStream.range(0, this.children.size()).filter(j -> i != j).noneMatch(j -> ((IQTree)this.children.get(j)).getVariables().stream().anyMatch(arg_0 -> rightSpecificVariables.contains(arg_0)));
            }
            return false;
        }

        private IQTree createJoinOrFilterOrEmptyOrLiftLeft(IQProperties normalizedIQProperties) {
            switch (this.children.size()) {
                case 0: {
                    return InnerJoinNormalizerImpl.this.iqFactory.createTrueNode();
                }
                case 1: {
                    IQTree uniqueChild = (IQTree)this.children.get(0);
                    return this.joiningCondition.map(e -> InnerJoinNormalizerImpl.this.iqFactory.createUnaryIQTree(InnerJoinNormalizerImpl.this.iqFactory.createFilterNode((ImmutableExpression)e), uniqueChild)).orElse(uniqueChild);
                }
            }
            return this.liftLeftJoin().orElseGet(() -> InnerJoinNormalizerImpl.this.iqFactory.createNaryIQTree((NaryOperatorNode)InnerJoinNormalizerImpl.this.iqFactory.createInnerJoinNode(this.joiningCondition), this.children, normalizedIQProperties));
        }

        protected Optional<IQTree> liftLeftJoin() {
            Optional<Integer> ljChildToLiftIndex = IntStream.range(0, this.children.size()).filter(this::isLeftJoinToLiftAboveJoin).boxed().findFirst();
            if (!ljChildToLiftIndex.isPresent()) {
                return Optional.empty();
            }
            int index = ljChildToLiftIndex.get();
            BinaryNonCommutativeIQTree ljChild = (BinaryNonCommutativeIQTree)this.children.get(index);
            NaryIQTree newJoinOnLeft = InnerJoinNormalizerImpl.this.iqFactory.createNaryIQTree(InnerJoinNormalizerImpl.this.iqFactory.createInnerJoinNode(), (ImmutableList<IQTree>)((ImmutableList)Stream.concat(Stream.of(ljChild.getLeftChild()), IntStream.range(0, this.children.size()).filter(i -> i != index).boxed().map(arg_0 -> this.children.get(arg_0))).collect(ImmutableCollectors.toList())));
            BinaryNonCommutativeIQTree newLeftJoinTree = InnerJoinNormalizerImpl.this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)ljChild.getRootNode(), newJoinOnLeft, ljChild.getRightChild());
            IQTree newTree = this.joiningCondition.map(InnerJoinNormalizerImpl.this.iqFactory::createFilterNode).map(t -> InnerJoinNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)t, newLeftJoinTree)).orElse(newLeftJoinTree);
            return Optional.of(newTree);
        }

        public State propagateDownCondition() {
            if (!this.joiningCondition.isPresent()) {
                return this;
            }
            try {
                ConditionSimplifier.ExpressionAndSubstitution conditionSimplificationResults = InnerJoinNormalizerImpl.this.conditionSimplifier.simplifyCondition(this.joiningCondition.get(), this.childrenVariableNullability);
                Optional<ImmutableExpression> newJoiningCondition = conditionSimplificationResults.getOptionalExpression();
                ImmutableList newChildren = Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> (ImmutableList)this.children.stream().map(child -> child.applyDescendingSubstitution((ImmutableSubstitution<? extends VariableOrGroundTerm>)s, newJoiningCondition)).collect(ImmutableCollectors.toList())).orElseGet(() -> newJoiningCondition.map(s -> (ImmutableList)this.children.stream().map(child -> child.propagateDownConstraint((ImmutableExpression)s)).collect(ImmutableCollectors.toList())).orElse(this.children));
                Optional<ConstructionNode> newParent = Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> InnerJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)InnerJoinNormalizerImpl.extractProjectedVariables((ImmutableList<IQTree>)this.children), (ImmutableSubstitution<ImmutableTerm>)s));
                return newParent.map(p -> this.updateParentConditionAndChildren((UnaryOperatorNode)p, newJoiningCondition, (ImmutableList<IQTree>)newChildren)).orElseGet(() -> this.updateConditionAndChildren(newJoiningCondition, (ImmutableList<IQTree>)newChildren));
            }
            catch (UnsatisfiableConditionException e) {
                return this.declareAsEmpty();
            }
        }

        public State liftDistincts() {
            Optional<DistinctNode> distinctNode = this.children.stream().filter(c -> c.getRootNode() instanceof DistinctNode).map(c -> (DistinctNode)c.getRootNode()).findFirst();
            if (distinctNode.isPresent() && this.isDistinct()) {
                DistinctNode newParent = distinctNode.get();
                ImmutableList newChildren = (ImmutableList)this.children.stream().map(IQTree::removeDistincts).collect(ImmutableCollectors.toList());
                return this.updateParentConditionAndChildren(newParent, this.joiningCondition, (ImmutableList<IQTree>)newChildren);
            }
            return this;
        }

        private boolean isDistinct() {
            if (this.children.stream().allMatch(IQTree::isDistinct)) {
                return true;
            }
            NaryIQTree tree = InnerJoinNormalizerImpl.this.iqFactory.createNaryIQTree(InnerJoinNormalizerImpl.this.iqFactory.createInnerJoinNode(this.joiningCondition), this.children);
            return tree.isDistinct();
        }

        public State liftConditionAndMergeJoins() {
            if (this.children.stream().noneMatch(c -> c.getRootNode() instanceof CommutativeJoinOrFilterNode)) {
                return this;
            }
            ImmutableList conditionAndTrees = (ImmutableList)this.children.stream().map(this::extractConditionAndSubtrees).collect(ImmutableCollectors.toList());
            Stream conditions = conditionAndTrees.stream().map(ct -> ct.condition).filter(Optional::isPresent).map(Optional::get).flatMap(ImmutableExpression::flattenAND);
            Optional<ImmutableExpression> newJoiningCondition = InnerJoinNormalizerImpl.this.termFactory.getConjunction(this.joiningCondition.map(c -> Stream.concat(c.flattenAND(), conditions)).orElse(conditions));
            ImmutableList newChildren = (ImmutableList)conditionAndTrees.stream().flatMap(ct -> ct.trees).collect(ImmutableCollectors.toList());
            return this.updateConditionAndChildren(newJoiningCondition, (ImmutableList<IQTree>)newChildren);
        }

        private ConditionAndTrees extractConditionAndSubtrees(IQTree tree) {
            QueryNode rootNode = tree.getRootNode();
            if (rootNode instanceof CommutativeJoinNode) {
                CommutativeJoinNode joinNode = (CommutativeJoinNode)rootNode;
                return joinNode.getOptionalFilterCondition().map(c -> new ConditionAndTrees((ImmutableExpression)c, tree.getChildren().stream())).orElseGet(() -> new ConditionAndTrees(tree.getChildren().stream()));
            }
            if (rootNode instanceof FilterNode) {
                return new ConditionAndTrees(((FilterNode)rootNode).getFilterCondition(), tree.getChildren().stream());
            }
            return new ConditionAndTrees(Stream.of(tree));
        }

        public State liftChildProjectingAwayConstructionNodes() {
            ImmutableList newChildren = (ImmutableList)this.children.stream().map(c -> Optional.of(c).filter(t -> t.getRootNode() instanceof ConstructionNode && ((ConstructionNode)t.getRootNode()).getSubstitution().isEmpty()).map(t -> ((UnaryIQTree)t).getChild()).orElse((IQTree)c)).collect(ImmutableCollectors.toList());
            if (newChildren.equals(this.children)) {
                return this;
            }
            ImmutableSet childrenVariables = (ImmutableSet)this.children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
            ConstructionNode newParent = InnerJoinNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)childrenVariables);
            return this.updateParentConditionAndChildren(newParent, this.joiningCondition, (ImmutableList<IQTree>)newChildren);
        }
    }
}

