/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.AggregationNodeImpl;
import it.unibz.inf.ontop.iq.node.normalization.AggregationNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.impl.InjectiveBindingLiftState;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.AggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggregationNormalizerImpl
implements AggregationNormalizer {
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    protected AggregationNormalizerImpl(CoreSingletons coreSingletons) {
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.termFactory = coreSingletons.getTermFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
    }

    @Override
    public IQTree normalizeForOptimization(AggregationNode aggregationNode, IQTree child, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        IQProperties normalizedProperties = currentIQProperties.declareNormalizedForOptimization();
        if (aggregationNode.getGroupingVariables().isEmpty() && aggregationNode.getSubstitution().isEmpty()) {
            return this.iqFactory.createTrueNode();
        }
        IQTree shrunkChild = child.normalizeForOptimization(variableGenerator);
        if (shrunkChild.isDeclaredAsEmpty()) {
            return this.normalizeEmptyChild(aggregationNode, normalizedProperties);
        }
        QueryNode rootNode = shrunkChild.getRootNode();
        AggregationNormalizationState stateAfterLiftingBindings = Optional.of(rootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(n -> this.normalizeWithChildConstructionNode(aggregationNode, (ConstructionNode)n, ((UnaryIQTree)shrunkChild).getChild(), variableGenerator)).orElseGet(() -> new AggregationNormalizationState(aggregationNode, null, shrunkChild, variableGenerator));
        AggregationNormalizationState finalState = stateAfterLiftingBindings.simplifyAggregationSubstitution();
        return finalState.createNormalizedTree(normalizedProperties);
    }

    private IQTree normalizeEmptyChild(AggregationNode aggregationNode, IQProperties normalizedProperties) {
        ImmutableSet<Variable> projectedVariables = aggregationNode.getVariables();
        if (!aggregationNode.getGroupingVariables().isEmpty()) {
            return this.iqFactory.createEmptyNode(projectedVariables);
        }
        ImmutableMap<Variable, ImmutableTerm> newSubstitutionMap = aggregationNode.getSubstitution().getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.simplifyEmptyAggregate((ImmutableFunctionalTerm)e.getValue())));
        ConstructionNode constructionNode = this.iqFactory.createConstructionNode(projectedVariables, this.substitutionFactory.getSubstitution(newSubstitutionMap));
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, (IQTree)this.iqFactory.createTrueNode(), normalizedProperties);
    }

    private ImmutableTerm simplifyEmptyAggregate(ImmutableFunctionalTerm aggregateTerm) {
        FunctionSymbol functionSymbol = aggregateTerm.getFunctionSymbol();
        if (functionSymbol instanceof AggregationFunctionSymbol) {
            return ((AggregationFunctionSymbol)functionSymbol).evaluateEmptyBag(this.termFactory);
        }
        throw new MinorOntopInternalBugException("Was expecting an AggregationFunctionSymbol");
    }

    private AggregationNormalizationState normalizeWithChildConstructionNode(AggregationNode aggregationNode, ConstructionNode childConstructionNode, IQTree grandChild, VariableGenerator variableGenerator) {
        return new AggregationNormalizationState(aggregationNode, childConstructionNode, grandChild, variableGenerator).propagateNonGroupingBindingsIntoToAggregationSubstitution().liftGroupingBindings().simplifyAggregationSubstitution();
    }

    protected class AggregationNormalizationState {
        private static final int MAX_ITERATIONS = 1000;
        private final ImmutableSet<Variable> groupingVariables;
        private final ImmutableSubstitution<ImmutableFunctionalTerm> aggregationSubstitution;
        @Nullable
        private final ConstructionNode childConstructionNode;
        private final IQTree grandChild;
        private final VariableGenerator variableGenerator;
        private final ImmutableList<ConstructionNode> ancestors;

        protected AggregationNormalizationState(@Nonnull AggregationNode aggregationNode, ConstructionNode childConstructionNode, IQTree grandChild, VariableGenerator variableGenerator) {
            this.groupingVariables = aggregationNode.getGroupingVariables();
            this.aggregationSubstitution = aggregationNode.getSubstitution();
            this.childConstructionNode = childConstructionNode;
            this.grandChild = grandChild;
            this.variableGenerator = variableGenerator;
            this.ancestors = ImmutableList.of();
        }

        private AggregationNormalizationState(ImmutableList<ConstructionNode> ancestors, ImmutableSet<Variable> groupingVariables, @Nullable ImmutableSubstitution<ImmutableFunctionalTerm> aggregationSubstitution, ConstructionNode childConstructionNode, IQTree grandChild, VariableGenerator variableGenerator) {
            this.ancestors = ancestors;
            this.groupingVariables = groupingVariables;
            this.aggregationSubstitution = aggregationSubstitution;
            this.childConstructionNode = childConstructionNode;
            this.grandChild = grandChild;
            this.variableGenerator = variableGenerator;
        }

        public AggregationNormalizationState propagateNonGroupingBindingsIntoToAggregationSubstitution() {
            if (this.childConstructionNode == null) {
                return this;
            }
            ImmutableSet nonGroupingVariables = Sets.difference(AggregationNodeImpl.extractChildVariables(this.groupingVariables, this.aggregationSubstitution), this.groupingVariables).immutableCopy();
            ImmutableSubstitution<ImmutableTerm> nonGroupingSubstitution = this.childConstructionNode.getSubstitution().reduceDomainToIntersectionWith((ImmutableSet<Variable>)nonGroupingVariables);
            ImmutableSubstitution<ImmutableTerm> newAggregationSubstitution = nonGroupingSubstitution.composeWith(this.aggregationSubstitution).reduceDomainToIntersectionWith(this.aggregationSubstitution.getDomain());
            AggregationNode newAggregationNode = AggregationNormalizerImpl.this.iqFactory.createAggregationNode(this.groupingVariables, newAggregationSubstitution);
            ConstructionNode newChildConstructionNode = Optional.of(this.childConstructionNode.getSubstitution().reduceDomainToIntersectionWith(this.groupingVariables)).filter(s -> !s.isEmpty()).map(s -> AggregationNormalizerImpl.this.iqFactory.createConstructionNode(newAggregationNode.getChildVariables(), (ImmutableSubstitution<ImmutableTerm>)s)).orElse(null);
            return new AggregationNormalizationState(this.ancestors, this.groupingVariables, newAggregationSubstitution, newChildConstructionNode, this.grandChild, this.variableGenerator);
        }

        public AggregationNormalizationState liftGroupingBindings() {
            if (this.childConstructionNode == null) {
                return this;
            }
            ImmutableSubstitution<ImmutableTerm> substitution = this.childConstructionNode.getSubstitution();
            if (substitution.isEmpty()) {
                return this;
            }
            if (!this.groupingVariables.containsAll(substitution.getDomain())) {
                throw new MinorOntopInternalBugException("Was expecting all the non-grouping bindings to be lifted");
            }
            ConstructionNode groupingConstructionNode = AggregationNormalizerImpl.this.iqFactory.createConstructionNode(this.groupingVariables, substitution);
            InjectiveBindingLiftState subState = new InjectiveBindingLiftState(groupingConstructionNode, this.grandChild, this.variableGenerator, AggregationNormalizerImpl.this.coreSingletons);
            for (int i = 0; i < 1000; ++i) {
                InjectiveBindingLiftState newSubState = subState.liftBindings();
                if (newSubState.equals(subState)) {
                    return this.convertIntoState(subState);
                }
                subState = newSubState;
            }
            throw new MinorOntopInternalBugException("AggregationNormalizerImpl.liftGroupingBindings() did not converge after 1000");
        }

        private AggregationNormalizationState convertIntoState(InjectiveBindingLiftState subState) {
            ImmutableSet<Variable> aggregateVariables = this.aggregationSubstitution.getDomain();
            ImmutableList<ConstructionNode> subStateAncestors = subState.getAncestors();
            ImmutableList newAncestors = (ImmutableList)Stream.concat(this.ancestors.stream(), subStateAncestors.stream().map(a -> AggregationNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(a.getVariables(), (Set)aggregateVariables).immutableCopy(), a.getSubstitution()))).collect(ImmutableCollectors.toList());
            ImmutableSubstitution newAggregationSubstitution = subStateAncestors.stream().reduce(this.aggregationSubstitution, (s, a) -> a.getSubstitution().composeWith((ImmutableSubstitution<ImmutableTerm>)s).reduceDomainToIntersectionWith(aggregateVariables), (s1, s2) -> {
                throw new MinorOntopInternalBugException("Substitution merging was not expected");
            });
            ImmutableSet newGroupingVariables = subStateAncestors.isEmpty() ? this.groupingVariables : Sets.difference(((ConstructionNode)subStateAncestors.get(subStateAncestors.size() - 1)).getChildVariables(), newAggregationSubstitution.getDomain()).immutableCopy();
            ConstructionNode newChildConstructionNode = subState.getChildConstructionNode().filter(n -> !n.getSubstitution().isEmpty()).map(n -> AggregationNormalizerImpl.this.iqFactory.createConstructionNode(AggregationNodeImpl.extractChildVariables((ImmutableSet<Variable>)newGroupingVariables, newAggregationSubstitution), n.getSubstitution())).orElse(null);
            return new AggregationNormalizationState((ImmutableList<ConstructionNode>)newAncestors, (ImmutableSet<Variable>)newGroupingVariables, newAggregationSubstitution, newChildConstructionNode, subState.getGrandChildTree(), this.variableGenerator);
        }

        public AggregationNormalizationState simplifyAggregationSubstitution() {
            VariableNullability variableNullability = Optional.ofNullable(this.childConstructionNode).map(c -> AggregationNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, this.grandChild, AggregationNormalizerImpl.this.iqFactory.createIQProperties().declareNormalizedForOptimization())).orElse(this.grandChild).getVariableNullability();
            ImmutableSubstitution<ImmutableTerm> simplifiedSubstitution = this.aggregationSubstitution.simplifyValues(variableNullability);
            ImmutableMap<Variable, Optional> decompositionMap = simplifiedSubstitution.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof ImmutableFunctionalTerm).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.decomposeFunctionalTerm((ImmutableFunctionalTerm)e.getValue())));
            ImmutableMap liftedSubstitutionMap = Stream.concat(simplifiedSubstitution.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof NonFunctionalTerm), decompositionMap.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).map(e -> Maps.immutableEntry(e.getKey(), (Object)((ImmutableFunctionalTerm.FunctionalTermDecomposition)((Optional)e.getValue()).get()).getLiftableTerm()))).collect(ImmutableCollectors.toMap());
            ImmutableMap newAggregationSubstitutionMap = decompositionMap.entrySet().stream().flatMap(e -> ((Optional)e.getValue()).map(d -> d.getSubTermSubstitutionMap().map(s -> s.entrySet().stream()).orElseGet(Stream::empty)).orElseGet(() -> Stream.of(Maps.immutableEntry(e.getKey(), (Object)((ImmutableFunctionalTerm)simplifiedSubstitution.get((Variable)e.getKey())))))).collect(ImmutableCollectors.toMap());
            ImmutableSubstitution<ImmutableFunctionalTerm> newAggregationSubstitution = AggregationNormalizerImpl.this.substitutionFactory.getSubstitution(newAggregationSubstitutionMap);
            if (liftedSubstitutionMap.isEmpty()) {
                return new AggregationNormalizationState(this.ancestors, this.groupingVariables, newAggregationSubstitution, this.childConstructionNode, this.grandChild, this.variableGenerator);
            }
            ConstructionNode liftedConstructionNode = AggregationNormalizerImpl.this.iqFactory.createConstructionNode((ImmutableSet<Variable>)Sets.union(this.groupingVariables, this.aggregationSubstitution.getDomain()).immutableCopy(), AggregationNormalizerImpl.this.substitutionFactory.getSubstitution(liftedSubstitutionMap));
            ImmutableSet newGroupingVariables = Sets.difference(liftedConstructionNode.getChildVariables(), newAggregationSubstitution.getDomain()).immutableCopy();
            ImmutableList newAncestors = (ImmutableList)Stream.concat(this.ancestors.stream(), Stream.of(liftedConstructionNode)).collect(ImmutableCollectors.toList());
            return new AggregationNormalizationState((ImmutableList<ConstructionNode>)newAncestors, (ImmutableSet<Variable>)newGroupingVariables, newAggregationSubstitution, this.childConstructionNode, this.grandChild, this.variableGenerator);
        }

        protected Optional<ImmutableFunctionalTerm.FunctionalTermDecomposition> decomposeFunctionalTerm(ImmutableFunctionalTerm functionalTerm) {
            FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
            if (functionSymbol.isAggregation()) {
                return Optional.empty();
            }
            ImmutableList<? extends ImmutableTerm> arguments = functionalTerm.getTerms();
            ImmutableMap<Integer, Optional> subTermDecompositions = IntStream.range(0, arguments.size()).filter(i -> arguments.get(i) instanceof ImmutableFunctionalTerm).boxed().collect(ImmutableCollectors.toMap(i -> i, i -> this.decomposeFunctionalTerm((ImmutableFunctionalTerm)arguments.get(i.intValue()))));
            ImmutableList newArguments = (ImmutableList)IntStream.range(0, arguments.size()).boxed().map(i -> Optional.ofNullable(subTermDecompositions.get(i)).map(optionalDecomposition -> optionalDecomposition.map(ImmutableFunctionalTerm.FunctionalTermDecomposition::getLiftableTerm).orElseGet(this.variableGenerator::generateNewVariable)).orElseGet(() -> (ImmutableTerm)arguments.get(i.intValue()))).collect(ImmutableCollectors.toList());
            ImmutableMap subTermSubstitutionMap = subTermDecompositions.entrySet().stream().flatMap(e -> ((Optional)e.getValue()).map(d -> d.getSubTermSubstitutionMap().map(s -> s.entrySet().stream()).orElseGet(Stream::empty)).orElseGet(() -> Stream.of(Maps.immutableEntry((Object)((Variable)newArguments.get(((Integer)e.getKey()).intValue())), (Object)((ImmutableFunctionalTerm)arguments.get(((Integer)e.getKey()).intValue())))))).collect(ImmutableCollectors.toMap());
            ImmutableFunctionalTerm newFunctionalTerm = AggregationNormalizerImpl.this.termFactory.getImmutableFunctionalTerm(functionSymbol, (ImmutableList<? extends ImmutableTerm>)newArguments);
            return subTermSubstitutionMap.isEmpty() ? Optional.of(AggregationNormalizerImpl.this.termFactory.getFunctionalTermDecomposition(newFunctionalTerm)) : Optional.of(AggregationNormalizerImpl.this.termFactory.getFunctionalTermDecomposition(newFunctionalTerm, subTermSubstitutionMap));
        }

        protected IQTree createNormalizedTree(IQProperties normalizedProperties) {
            IntermediateQueryFactory iqFactory = AggregationNormalizerImpl.this.coreSingletons.getIQFactory();
            IQTree newChildTree = Optional.ofNullable(this.childConstructionNode).map(c -> iqFactory.createUnaryIQTree((UnaryOperatorNode)c, this.grandChild, iqFactory.createIQProperties().declareNormalizedForOptimization())).orElse(this.grandChild);
            AggregationNode aggregationNode = iqFactory.createAggregationNode(this.groupingVariables, this.aggregationSubstitution);
            UnaryIQTree aggregationTree = iqFactory.createUnaryIQTree((UnaryOperatorNode)aggregationNode, newChildTree, normalizedProperties);
            return this.ancestors.reverse().stream().reduce(aggregationTree, (t, a) -> iqFactory.createUnaryIQTree((UnaryOperatorNode)a, (IQTree)t), (t1, t2) -> {
                throw new MinorOntopInternalBugException("No merge was expected");
            }).normalizeForOptimization(this.variableGenerator);
        }
    }
}

