/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.com.google.common.collect.Table;
import it.unibz.inf.ontop.com.google.common.collect.Tables;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class VariableNullabilityImpl
implements VariableNullability {
    private final ImmutableSet<ImmutableSet<Variable>> nullableGroups;
    private final ImmutableSet<Variable> scope;
    private final CoreUtilsFactory coreUtilsFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;
    @Nullable
    private ImmutableSet<Variable> nullableVariables;
    @Nullable
    private ImmutableMap<Variable, Integer> variableMap;

    @AssistedInject
    private VariableNullabilityImpl(@Assisted(value="nullableGroups") ImmutableSet<ImmutableSet<Variable>> nullableGroups, @Assisted(value="scope") ImmutableSet<Variable> scope, CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.nullableGroups = nullableGroups;
        this.scope = scope;
        this.coreUtilsFactory = coreUtilsFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.nullableVariables = null;
    }

    @AssistedInject
    private VariableNullabilityImpl(@Assisted ImmutableSet<Variable> scope, CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this((ImmutableSet<ImmutableSet<Variable>>)ImmutableSet.of(), scope, coreUtilsFactory, termFactory, substitutionFactory);
    }

    @AssistedInject
    private VariableNullabilityImpl(@Assisted ImmutableFunctionalTerm functionalTerm, CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this(functionalTerm.getVariableStream(), coreUtilsFactory, termFactory, substitutionFactory);
    }

    @AssistedInject
    protected VariableNullabilityImpl(@Assisted Stream<Variable> variableStream, CoreUtilsFactory coreUtilsFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.scope = (ImmutableSet)variableStream.collect(ImmutableCollectors.toSet());
        this.nullableGroups = (ImmutableSet)this.scope.stream().map(ImmutableSet::of).collect(ImmutableCollectors.toSet());
        this.coreUtilsFactory = coreUtilsFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
        this.nullableVariables = this.scope;
    }

    @Override
    public boolean isPossiblyNullable(Variable variable) {
        return !this.scope.contains((Object)variable) || this.getNullableVariables().contains((Object)variable);
    }

    @Override
    public ImmutableSet<Variable> getNullableVariables() {
        if (this.nullableVariables == null) {
            this.nullableVariables = (ImmutableSet)this.nullableGroups.stream().flatMap(Collection::stream).collect(ImmutableCollectors.toSet());
        }
        return this.nullableVariables;
    }

    @Override
    public boolean canPossiblyBeNullSeparately(ImmutableSet<Variable> variables) {
        if (this.variableMap == null) {
            this.variableMap = VariableNullabilityImpl.extractVariableMap(this.nullableGroups);
        }
        return variables.stream().filter(arg_0 -> this.variableMap.containsKey(arg_0)).map(arg_0 -> this.variableMap.get(arg_0)).distinct().count() > 1L;
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> getNullableGroups() {
        return this.nullableGroups;
    }

    private VariableNullabilityImpl appendNewVariables(ImmutableMap<Variable, Variable> nullabilityBindings, ImmutableSet<Variable> newScope) {
        ImmutableList groupList = ImmutableList.copyOf(this.nullableGroups);
        ImmutableMap<Variable, Integer> originalVariableMap = VariableNullabilityImpl.extractVariableMap((ImmutableCollection<ImmutableSet<Variable>>)groupList);
        AtomicInteger groupCount = new AtomicInteger(groupList.size());
        ImmutableMultimap<Integer, Variable> newVariableMultimap = nullabilityBindings.entrySet().stream().collect(ImmutableCollectors.toMultimap(e -> ((Variable)e.getKey()).equals(e.getValue()) ? Integer.valueOf(groupCount.getAndIncrement()) : (Integer)originalVariableMap.get(e.getValue()), Map.Entry::getKey));
        ImmutableSet newNullableGroups = (ImmutableSet)IntStream.range(0, groupCount.get()).boxed().map(i -> i < groupList.size() ? Sets.union((Set)((Set)groupList.get(i.intValue())), (Set)ImmutableSet.copyOf((Collection)newVariableMultimap.get(i))).immutableCopy() : ImmutableSet.copyOf((Collection)newVariableMultimap.get(i))).collect(ImmutableCollectors.toSet());
        return new VariableNullabilityImpl((ImmutableSet<ImmutableSet<Variable>>)newNullableGroups, newScope, this.coreUtilsFactory, this.termFactory, this.substitutionFactory);
    }

    @Override
    public VariableNullability update(ImmutableSubstitution<? extends ImmutableTerm> substitution, ImmutableSet<Variable> newScope) {
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection<Variable>)Sets.union(substitution.getDomain(), this.getNullableVariables()).immutableCopy());
        return this.update(substitution, newScope, variableGenerator);
    }

    @Override
    public VariableNullability applyFreshRenaming(InjectiveVar2VarSubstitution freshRenamingSubstitution) {
        ImmutableSet newScope = (ImmutableSet)this.scope.stream().map(freshRenamingSubstitution::applyToVariable).collect(ImmutableCollectors.toSet());
        ImmutableSet newNullableGroups = (ImmutableSet)this.nullableGroups.stream().map(g -> (ImmutableSet)g.stream().map(freshRenamingSubstitution::applyToVariable).collect(ImmutableCollectors.toSet())).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)newNullableGroups, (ImmutableSet<Variable>)newScope);
    }

    @Override
    public VariableNullability extendToExternalVariables(Stream<Variable> possiblyExternalVariables) {
        ImmutableSet externalVariables = (ImmutableSet)possiblyExternalVariables.filter(v -> !this.scope.contains(v)).collect(ImmutableCollectors.toSet());
        if (externalVariables.isEmpty()) {
            return this;
        }
        ImmutableSet newScope = Sets.union(this.scope, (Set)externalVariables).immutableCopy();
        ImmutableSet newNullableGroups = (ImmutableSet)Stream.concat(externalVariables.stream().map(ImmutableSet::of), this.nullableGroups.stream()).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)newNullableGroups, (ImmutableSet<Variable>)newScope);
    }

    private VariableNullability update(ImmutableSubstitution<? extends ImmutableTerm> substitution, ImmutableSet<Variable> newScope, VariableGenerator variableGenerator) {
        VariableNullability nullabilityBeforeProjectingOut = this.splitSubstitution(substitution, variableGenerator).reduce(this, (n, s) -> this.updateVariableNullability((ImmutableSubstitution<? extends ImmutableTerm>)s, (VariableNullabilityImpl)n), (n1, n2) -> {
            throw new MinorOntopInternalBugException("vns are not expected to be combined");
        });
        ImmutableSet nullableGroups = (ImmutableSet)nullabilityBeforeProjectingOut.getNullableGroups().stream().map(g -> (ImmutableSet)g.stream().filter(arg_0 -> ((ImmutableSet)newScope).contains(arg_0)).collect(ImmutableCollectors.toSet())).filter(g -> !g.isEmpty()).collect(ImmutableCollectors.toSet());
        return this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, newScope);
    }

    private Stream<ImmutableSubstitution<? extends ImmutableTerm>> splitSubstitution(ImmutableSubstitution<? extends ImmutableTerm> substitution, VariableGenerator variableGenerator) {
        ImmutableMultimap functionSubTermMultimap = substitution.getImmutableMap().entrySet().stream().filter(e -> e.getValue() instanceof ImmutableFunctionalTerm).flatMap(e -> {
            ImmutableList<? extends ImmutableTerm> subTerms = ((ImmutableFunctionalTerm)e.getValue()).getTerms();
            return IntStream.range(0, subTerms.size()).filter(i -> subTerms.get(i) instanceof ImmutableFunctionalTerm).boxed().map(i -> Maps.immutableEntry(e.getKey(), (Object)i));
        }).collect(ImmutableCollectors.toMultimap());
        if (functionSubTermMultimap.isEmpty()) {
            return Stream.of(substitution);
        }
        ImmutableTable subTermNames = functionSubTermMultimap.entries().stream().map(e -> Tables.immutableCell(e.getKey(), e.getValue(), (Object)variableGenerator.generateNewVariable())).collect(ImmutableCollectors.toTable());
        ImmutableMap parentSubstitutionMap = substitution.getImmutableMap().entrySet().stream().map(e -> Optional.of(functionSubTermMultimap.get(e.getKey())).filter(indexes -> !indexes.isEmpty()).map(indexes -> {
            Variable v = (Variable)e.getKey();
            ImmutableFunctionalTerm def = (ImmutableFunctionalTerm)substitution.get(v);
            ImmutableList newArgs = (ImmutableList)IntStream.range(0, def.getArity()).boxed().map(i -> Optional.ofNullable((ImmutableTerm)subTermNames.get((Object)v, i)).orElseGet(() -> def.getTerm((int)i))).collect(ImmutableCollectors.toList());
            ImmutableFunctionalTerm newDef = this.termFactory.getImmutableFunctionalTerm(def.getFunctionSymbol(), (ImmutableList<? extends ImmutableTerm>)newArgs);
            return Maps.immutableEntry((Object)v, (Object)newDef);
        }).orElse((Map.Entry)e)).collect(ImmutableCollectors.toMap());
        ImmutableSubstitution parentSubstitution = this.substitutionFactory.getSubstitution(parentSubstitutionMap);
        ImmutableSubstitution<ImmutableTerm> childSubstitution = this.substitutionFactory.getSubstitution(subTermNames.cellSet().stream().collect(ImmutableCollectors.toMap(Table.Cell::getValue, c -> ((ImmutableFunctionalTerm)substitution.get((Variable)c.getRowKey())).getTerm((Integer)c.getColumnKey()))));
        return Stream.concat(this.splitSubstitution(childSubstitution, variableGenerator), Stream.of(parentSubstitution));
    }

    private VariableNullabilityImpl updateVariableNullability(ImmutableSubstitution<? extends ImmutableTerm> nonNestedSubstitution, VariableNullabilityImpl childNullability) {
        ImmutableMap nullabilityBindings = nonNestedSubstitution.getImmutableMap().entrySet().stream().flatMap(e -> this.evaluateTermNullability((ImmutableTerm)e.getValue(), childNullability, (Variable)e.getKey()).map(Stream::of).orElseGet(Stream::empty)).collect(ImmutableCollectors.toMap());
        ImmutableSet newScope = Sets.union(childNullability.scope, nonNestedSubstitution.getDomain()).immutableCopy();
        return childNullability.appendNewVariables(nullabilityBindings, (ImmutableSet<Variable>)newScope);
    }

    private Optional<Map.Entry<Variable, Variable>> evaluateTermNullability(ImmutableTerm term, VariableNullability childNullability, Variable key) {
        if (term instanceof Constant) {
            return term.isNull() ? Optional.of(Maps.immutableEntry((Object)key, (Object)key)) : Optional.empty();
        }
        if (term instanceof Variable) {
            return Optional.of((Variable)term).filter(childNullability::isPossiblyNullable).map(v -> Maps.immutableEntry((Object)key, (Object)v));
        }
        ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
        FunctionSymbol.FunctionalTermNullability results = functionalTerm.getFunctionSymbol().evaluateNullability(functionalTerm.getTerms(), childNullability, this.termFactory);
        return results.isNullable() ? Optional.of(results.getBoundVariable().map(v -> Maps.immutableEntry((Object)key, (Object)v)).orElseGet(() -> Maps.immutableEntry((Object)key, (Object)key))) : Optional.empty();
    }

    private static ImmutableMap<Variable, Integer> extractVariableMap(ImmutableCollection<ImmutableSet<Variable>> nullableGroups) {
        ImmutableList groupList = ImmutableList.copyOf(nullableGroups);
        return IntStream.range(0, groupList.size()).boxed().flatMap(i -> ((ImmutableSet)groupList.get(i.intValue())).stream().map(v -> Maps.immutableEntry((Object)v, (Object)i))).collect(ImmutableCollectors.toMap());
    }

    @Override
    public boolean canPossiblyBeNullSeparately(ImmutableList<? extends ImmutableTerm> terms) {
        if (terms.stream().allMatch(t -> t instanceof Variable)) {
            return this.canPossiblyBeNullSeparately((ImmutableSet<Variable>)ImmutableSet.copyOf(terms));
        }
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)Stream.concat(terms.stream().flatMap(ImmutableTerm::getVariableStream), this.getNullableVariables().stream()).collect(ImmutableCollectors.toSet()));
        ImmutableSubstitution<ImmutableTerm> substitution = this.substitutionFactory.getSubstitution(terms.stream().filter(t -> t instanceof NonVariableTerm).collect(ImmutableCollectors.toMap(t -> variableGenerator.generateNewVariable(), t -> t)));
        VariableNullability newVariableNullability = this.update(substitution, substitution.getDomain(), variableGenerator);
        ImmutableSet variables = Sets.union(terms.stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(Collectors.toSet()), substitution.getDomain()).immutableCopy();
        return newVariableNullability.canPossiblyBeNullSeparately((ImmutableSet<Variable>)variables);
    }
}

