/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.impl.QueryModifierNodeImpl;
import it.unibz.inf.ontop.iq.node.normalization.OrderByNormalizer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.Stream;

public class OrderByNodeImpl
extends QueryModifierNodeImpl
implements OrderByNode {
    private static final String ORDER_BY_NODE_STR = "ORDER BY";
    private final ImmutableList<OrderByNode.OrderComparator> comparators;
    private final OrderByNormalizer normalizer;

    @AssistedInject
    private OrderByNodeImpl(@Assisted ImmutableList<OrderByNode.OrderComparator> comparators, IntermediateQueryFactory iqFactory, OrderByNormalizer normalizer) {
        super(iqFactory);
        this.comparators = comparators;
        this.normalizer = normalizer;
    }

    @Override
    public ImmutableList<OrderByNode.OrderComparator> getComparators() {
        return this.comparators;
    }

    @Override
    public Optional<OrderByNode> applySubstitution(ImmutableSubstitution<? extends ImmutableTerm> substitution) {
        ImmutableList newComparators = (ImmutableList)this.comparators.stream().flatMap(c -> Stream.of(substitution.apply(c.getTerm())).filter(t -> t instanceof NonGroundTerm).map(t -> this.iqFactory.createOrderComparator((NonGroundTerm)t, c.isAscending()))).collect(ImmutableCollectors.toList());
        return Optional.of(newComparators).filter(cs -> !cs.isEmpty()).map(this.iqFactory::createOrderByNode);
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        throw new RuntimeException("TODO: implement");
    }

    @Override
    public IQTree normalizeForOptimization(IQTree child, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        return this.normalizer.normalizeForOptimization(this, child, variableGenerator, currentIQProperties);
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child) {
        Optional<OrderByNode> newOrderByNode = this.applySubstitution(descendingSubstitution);
        IQTree newChild = child.applyDescendingSubstitution(descendingSubstitution, constraint);
        return newOrderByNode.map(o -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)o, newChild)).orElse(newChild);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child) {
        Optional<OrderByNode> newOrderByNode = this.applySubstitution(descendingSubstitution);
        IQTree newChild = child.applyDescendingSubstitutionWithoutOptimizing(descendingSubstitution);
        return newOrderByNode.map(o -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)o, newChild)).orElse(newChild);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        OrderByNode newOrderByNode = this.applySubstitution(renamingSubstitution).orElseThrow(() -> new MinorOntopInternalBugException("The order by was expected to be kept"));
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newOrderByNode, newChild, newTreeCache);
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        return child.isDistinct();
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformOrderBy(tree, this, child);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitOrderBy(this, child);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidIntermediateQueryException {
        if (!child.getVariables().containsAll(this.getLocalVariables())) {
            throw new InvalidIntermediateQueryException("Some variables used in the node " + this + " are not provided by its child " + child);
        }
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQProperties iqProperties) {
        IQTree newChild = child.removeDistincts();
        IQProperties newProperties = newChild.equals(child) ? iqProperties.declareDistinctRemovalWithoutEffect() : iqProperties.declareDistinctRemovalWithEffect();
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this, newChild, newProperties);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        return child.inferUniqueConstraints();
    }

    @Override
    public ImmutableSet<Variable> computeNotInternallyRequiredVariables(IQTree child) {
        ImmutableSet<Variable> localVariables = this.getLocalVariables();
        return (ImmutableSet)child.getNotInternallyRequiredVariables().stream().filter(v -> !localVariables.contains(v)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public OrderByNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return (ImmutableSet)this.comparators.stream().flatMap(c -> c.getTerm().getVariableStream()).collect(ImmutableCollectors.toSet());
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return this.isEquivalentTo(node);
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.getLocalVariables();
    }

    @Override
    public ImmutableSet<Variable> getRequiredVariables(IntermediateQuery query) {
        return this.getLocalVariables();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return ImmutableSet.of();
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return queryNode instanceof OrderByNode && ((OrderByNode)queryNode).getComparators().equals(this.comparators);
    }

    @Override
    public OrderByNode clone() {
        return this.iqFactory.createOrderByNode(this.comparators);
    }

    public String toString() {
        return "ORDER BY " + this.comparators;
    }
}

