/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.InvalidQueryNodeException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.impl.ConstructionNodeTools;
import it.unibz.inf.ontop.iq.node.impl.ExtendedProjectionNodeImpl;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.NotRequiredVariableRemover;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructionNodeImpl
extends ExtendedProjectionNodeImpl
implements ConstructionNode {
    private static Logger LOGGER = LoggerFactory.getLogger(ConstructionNodeImpl.class);
    private final ImmutableSet<Variable> projectedVariables;
    private final ImmutableSubstitution<ImmutableTerm> substitution;
    private final ImmutableSet<Variable> childVariables;
    private final IntermediateQueryFactory iqFactory;
    private static final String CONSTRUCTION_NODE_STR = "CONSTRUCT";
    private final Constant nullValue;
    private final ConstructionSubstitutionNormalizer substitutionNormalizer;
    private final NotRequiredVariableRemover notRequiredVariableRemover;

    @AssistedInject
    private ConstructionNodeImpl(@Assisted ImmutableSet<Variable> projectedVariables, @Assisted ImmutableSubstitution<ImmutableTerm> substitution, ImmutableUnificationTools unificationTools, ConstructionNodeTools constructionNodeTools, ImmutableSubstitutionTools substitutionTools, SubstitutionFactory substitutionFactory, TermFactory termFactory, IntermediateQueryFactory iqFactory, OntopModelSettings settings, ConstructionSubstitutionNormalizer substitutionNormalizer, CoreUtilsFactory coreUtilsFactory, NotRequiredVariableRemover notRequiredVariableRemover) {
        super(substitutionFactory, iqFactory, unificationTools, constructionNodeTools, substitutionTools, termFactory, coreUtilsFactory);
        this.projectedVariables = projectedVariables;
        this.substitution = substitution;
        this.nullValue = termFactory.getNullConstant();
        this.iqFactory = iqFactory;
        this.substitutionNormalizer = substitutionNormalizer;
        this.notRequiredVariableRemover = notRequiredVariableRemover;
        this.childVariables = ConstructionNodeImpl.extractChildVariables(projectedVariables, substitution);
        if (settings.isTestModeEnabled()) {
            this.validateNode();
        }
    }

    private void validateNode() throws InvalidQueryNodeException {
        ImmutableSet<Variable> substitutionDomain = this.substitution.getDomain();
        if (!this.projectedVariables.containsAll(substitutionDomain)) {
            throw new InvalidQueryNodeException("ConstructionNode: all the domain variables of the substitution must be projected.\n" + this.toString());
        }
        if (substitutionDomain.stream().anyMatch(arg_0 -> this.childVariables.contains(arg_0))) {
            throw new InvalidQueryNodeException("ConstructionNode: variables defined by the substitution cannot be used for defining other variables.\n" + this.toString());
        }
        if (this.substitution.getImmutableMap().values().stream().filter(v -> v instanceof Variable).map(v -> (Variable)v).anyMatch(v -> !this.projectedVariables.contains(v))) {
            throw new InvalidQueryNodeException("ConstructionNode: substituting a variable by a non-projected variable is incorrect.\n" + this.toString());
        }
    }

    @AssistedInject
    private ConstructionNodeImpl(@Assisted ImmutableSet<Variable> projectedVariables, ImmutableUnificationTools unificationTools, ConstructionNodeTools constructionNodeTools, ImmutableSubstitutionTools substitutionTools, SubstitutionFactory substitutionFactory, TermFactory termFactory, IntermediateQueryFactory iqFactory, ConstructionSubstitutionNormalizer substitutionNormalizer, CoreUtilsFactory coreUtilsFactory, NotRequiredVariableRemover notRequiredVariableRemover) {
        super(substitutionFactory, iqFactory, unificationTools, constructionNodeTools, substitutionTools, termFactory, coreUtilsFactory);
        this.projectedVariables = projectedVariables;
        this.substitution = substitutionFactory.getSubstitution();
        this.iqFactory = iqFactory;
        this.nullValue = termFactory.getNullConstant();
        this.childVariables = ConstructionNodeImpl.extractChildVariables(projectedVariables, this.substitution);
        this.substitutionNormalizer = substitutionNormalizer;
        this.notRequiredVariableRemover = notRequiredVariableRemover;
        this.validateNode();
    }

    private static ImmutableSet<Variable> extractChildVariables(ImmutableSet<Variable> projectedVariables, ImmutableSubstitution<ImmutableTerm> substitution) {
        ImmutableSet<Variable> variableDefinedByBindings = substitution.getDomain();
        Stream variablesRequiredByBindings = substitution.getImmutableMap().values().stream().flatMap(ImmutableTerm::getVariableStream);
        return (ImmutableSet)Stream.concat(projectedVariables.stream(), variablesRequiredByBindings).filter(v -> !variableDefinedByBindings.contains(v)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.projectedVariables;
    }

    @Override
    public ImmutableSubstitution<ImmutableTerm> getSubstitution() {
        return this.substitution;
    }

    @Override
    public ConstructionNode clone() {
        return this.iqFactory.createConstructionNode(this.projectedVariables, this.substitution);
    }

    @Override
    public ConstructionNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Variable> getChildVariables() {
        return this.childVariables;
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        ImmutableSet.Builder collectedVariableBuilder = ImmutableSet.builder();
        collectedVariableBuilder.addAll(this.projectedVariables);
        ImmutableMap substitutionMap = this.substitution.getImmutableMap();
        collectedVariableBuilder.addAll((Iterable)substitutionMap.keySet());
        for (ImmutableTerm term : substitutionMap.values()) {
            if (term instanceof Variable) {
                collectedVariableBuilder.add((Object)((Variable)term));
                continue;
            }
            if (!(term instanceof ImmutableFunctionalTerm)) continue;
            collectedVariableBuilder.addAll(((ImmutableFunctionalTerm)term).getVariables());
        }
        return collectedVariableBuilder.build();
    }

    @Override
    public boolean isVariableNullable(IntermediateQuery query, Variable variable) {
        if (this.getChildVariables().contains((Object)variable)) {
            return this.isChildVariableNullable(query, variable);
        }
        return Optional.ofNullable(this.substitution.get(variable)).map(t -> this.isTermNullable(query, (ImmutableTerm)t)).orElseThrow(() -> new IllegalArgumentException("The variable " + variable + " is not projected by " + this));
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        return !this.inferUniqueConstraints(child).isEmpty();
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        if (!this.childVariables.contains((Object)variable)) {
            return this.iqFactory.createUnaryIQTree(this, child);
        }
        IQTree newChild = child.liftIncompatibleDefinitions(variable, variableGenerator);
        QueryNode newChildRoot = newChild.getRootNode();
        if (newChildRoot instanceof UnionNode && ((UnionNode)newChildRoot).hasAChildWithLiftableDefinition(variable, newChild.getChildren())) {
            ImmutableList<IQTree> grandChildren = newChild.getChildren();
            ImmutableList newChildren = (ImmutableList)grandChildren.stream().map(c -> this.iqFactory.createUnaryIQTree(this, (IQTree)c)).collect(ImmutableCollectors.toList());
            UnionNode newUnionNode = this.iqFactory.createUnionNode(this.getVariables());
            return this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)newChildren);
        }
        return this.iqFactory.createUnaryIQTree(this, newChild);
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformConstruction(tree, this, child);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitConstruction(this, child);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidQueryNodeException, InvalidIntermediateQueryException {
        this.validateNode();
        ImmutableSet<Variable> requiredChildVariables = this.getChildVariables();
        ImmutableSet<Variable> childVariables = child.getVariables();
        if (!childVariables.containsAll(requiredChildVariables)) {
            throw new InvalidIntermediateQueryException("This child " + child + " does not project all the variables required by the CONSTRUCTION node (" + requiredChildVariables + ")\n" + this);
        }
    }

    @Override
    public ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree child) {
        ImmutableSet<ImmutableSubstitution<NonVariableTerm>> childDefs = child.getPossibleVariableDefinitions();
        if (childDefs.isEmpty()) {
            ImmutableSubstitution<NonVariableTerm> def = this.substitution.getFragment(NonVariableTerm.class);
            return def.isEmpty() ? ImmutableSet.of() : ImmutableSet.of(def);
        }
        return (ImmutableSet)childDefs.stream().map(childDef -> childDef.composeWith(this.substitution)).map(s -> s.reduceDomainToIntersectionWith(this.projectedVariables)).map(s -> s.getFragment(NonVariableTerm.class)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQProperties iqProperties) {
        IQTree newChild = child.removeDistincts();
        IQProperties newProperties = newChild.equals(child) ? iqProperties.declareDistinctRemovalWithoutEffect() : iqProperties.declareDistinctRemovalWithEffect();
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this, newChild, newProperties);
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        return (ImmutableSet)child.inferUniqueConstraints().stream().filter(arg_0 -> this.projectedVariables.containsAll(arg_0)).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<Variable> computeNotInternallyRequiredVariables(IQTree child) {
        return this.getVariables();
    }

    private boolean isChildVariableNullable(IntermediateQuery query, Variable variable) {
        return query.getFirstChild(this).map(c -> c.isVariableNullable(query, variable)).orElseThrow(() -> new InvalidIntermediateQueryException("A construction node with child variables must have a child"));
    }

    private boolean isTermNullable(IntermediateQuery query, ImmutableTerm substitutionValue) {
        if (substitutionValue instanceof ImmutableFunctionalTerm) {
            ImmutableSet nullableVariables = (ImmutableSet)substitutionValue.getVariableStream().filter(v -> this.isChildVariableNullable(query, (Variable)v)).collect(ImmutableCollectors.toSet());
            return substitutionValue.isNullable((ImmutableSet<Variable>)nullableVariables);
        }
        if (substitutionValue instanceof Constant) {
            return substitutionValue.equals(this.nullValue);
        }
        if (substitutionValue instanceof Variable) {
            return this.isChildVariableNullable(query, (Variable)substitutionValue);
        }
        throw new IllegalStateException("Unexpected immutable term");
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return Optional.of(node).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).filter(n -> n.getVariables().equals(this.projectedVariables)).filter(n -> n.getSubstitution().equals(this.substitution)).isPresent();
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.getChildVariables();
    }

    @Override
    public ImmutableSet<Variable> getRequiredVariables(IntermediateQuery query) {
        return this.getLocallyRequiredVariables();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return this.substitution.getDomain();
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return this.isSyntacticallyEquivalentTo(queryNode);
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "CONSTRUCT " + this.projectedVariables + " [" + this.substitution + "]";
    }

    @Override
    public IQTree normalizeForOptimization(IQTree child, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        IQTree liftedChild = child.normalizeForOptimization(variableGenerator);
        IQTree shrunkChild = this.notRequiredVariableRemover.optimize(liftedChild, this.childVariables, variableGenerator);
        QueryNode shrunkChildRoot = shrunkChild.getRootNode();
        if (shrunkChildRoot instanceof ConstructionNode) {
            return this.mergeWithChild((ConstructionNode)shrunkChildRoot, (UnaryIQTree)shrunkChild, currentIQProperties, variableGenerator);
        }
        if (shrunkChild.isDeclaredAsEmpty()) {
            return this.iqFactory.createEmptyNode(this.projectedVariables);
        }
        if (shrunkChild.getVariables().equals(this.projectedVariables)) {
            return shrunkChild;
        }
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = this.substitutionNormalizer.normalizeSubstitution(this.substitution.simplifyValues(shrunkChild.getVariableNullability()), this.projectedVariables);
        Optional<ConstructionNode> newTopConstructionNode = normalization.generateTopConstructionNode();
        IQTree updatedChild = normalization.updateChild(shrunkChild);
        IQTree newChild = newTopConstructionNode.map(c -> this.notRequiredVariableRemover.optimize(updatedChild, c.getChildVariables(), variableGenerator)).orElse(updatedChild).normalizeForOptimization(variableGenerator);
        return newTopConstructionNode.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, newChild, currentIQProperties.declareNormalizedForOptimization())).orElseGet(() -> this.projectedVariables.equals(newChild.getVariables()) ? newChild : this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(this.projectedVariables), newChild));
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        ImmutableSet newVariables = (ImmutableSet)this.projectedVariables.stream().map(renamingSubstitution::applyToVariable).collect(ImmutableCollectors.toSet());
        ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode((ImmutableSet<Variable>)newVariables, renamingSubstitution.applyRenaming(this.substitution));
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, newChild, newTreeCache);
    }

    @Override
    protected Optional<ExtendedProjectionNode> computeNewProjectionNode(ImmutableSet<Variable> newProjectedVariables, ImmutableSubstitution<ImmutableTerm> theta, IQTree newChild) {
        return Optional.of(theta).filter(t -> !t.isEmpty() || !newProjectedVariables.equals(newChild.getVariables())).map(t -> this.iqFactory.createConstructionNode(newProjectedVariables, (ImmutableSubstitution<ImmutableTerm>)t));
    }

    private IQTree mergeWithChild(ConstructionNode childConstructionNode, UnaryIQTree childIQ, IQProperties currentIQProperties, VariableGenerator variableGenerator) {
        IQTree grandChild = childIQ.getChild();
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization substitutionNormalization = this.substitutionNormalizer.normalizeSubstitution(childConstructionNode.getSubstitution().composeWith(this.substitution).simplifyValues(grandChild.getVariableNullability()), this.projectedVariables);
        ImmutableSubstitution<ImmutableTerm> newSubstitution = substitutionNormalization.getNormalizedSubstitution();
        ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(this.projectedVariables, newSubstitution);
        IQTree updatedGrandChild = substitutionNormalization.updateChild(grandChild);
        IQTree newGrandChild = this.notRequiredVariableRemover.optimize(updatedGrandChild, newConstructionNode.getChildVariables(), variableGenerator).normalizeForOptimization(variableGenerator);
        return newGrandChild.getVariables().equals(newConstructionNode.getVariables()) ? newGrandChild : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, newGrandChild, currentIQProperties.declareNormalizedForOptimization());
    }

    public static class PropagationResults<T extends VariableOrGroundTerm> {
        public final ImmutableSubstitution<T> delta;
        public final Optional<ImmutableExpression> filter;
        public final ImmutableSubstitution<ImmutableTerm> theta;

        PropagationResults(ImmutableSubstitution<NonFunctionalTerm> thetaCBar, ImmutableSubstitution<ImmutableFunctionalTerm> thetaFBar, ImmutableSubstitution<T> newDeltaC, Optional<ImmutableExpression> f) {
            this.theta = thetaFBar.composeWith(thetaCBar);
            this.delta = newDeltaC;
            this.filter = f;
        }

        PropagationResults(ImmutableSubstitution<ImmutableTerm> theta, ImmutableSubstitution<T> delta, Optional<ImmutableExpression> newF) {
            this.theta = theta;
            this.delta = delta;
            this.filter = newF;
        }
    }
}

