/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.iq.IQProperties;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.IntermediateQuery;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.impl.ConstructionNodeTools;
import it.unibz.inf.ontop.iq.node.impl.ExtendedProjectionNodeImpl;
import it.unibz.inf.ontop.iq.node.normalization.AggregationNormalizer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.substitution.impl.ImmutableSubstitutionTools;
import it.unibz.inf.ontop.substitution.impl.ImmutableUnificationTools;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;

public class AggregationNodeImpl
extends ExtendedProjectionNodeImpl
implements AggregationNode {
    private static final String AGGREGATE_NODE_STR = "AGGREGATE";
    private final ImmutableSet<Variable> projectedVariables;
    private final ImmutableSet<Variable> groupingVariables;
    private final ImmutableSubstitution<ImmutableFunctionalTerm> substitution;
    private final ImmutableSet<Variable> childVariables;
    private final AggregationNormalizer aggregationNormalizer;

    @AssistedInject
    protected AggregationNodeImpl(@Assisted ImmutableSet<Variable> groupingVariables, @Assisted ImmutableSubstitution<ImmutableFunctionalTerm> substitution, SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory, AggregationNormalizer aggregationNormalizer, ImmutableUnificationTools unificationTools, ConstructionNodeTools constructionNodeTools, ImmutableSubstitutionTools substitutionTools, TermFactory termFactory, CoreUtilsFactory coreUtilsFactory, OntopModelSettings settings) {
        super(substitutionFactory, iqFactory, unificationTools, constructionNodeTools, substitutionTools, termFactory, coreUtilsFactory);
        this.groupingVariables = groupingVariables;
        this.substitution = substitution;
        this.aggregationNormalizer = aggregationNormalizer;
        this.projectedVariables = Sets.union(groupingVariables, substitution.getDomain()).immutableCopy();
        this.childVariables = AggregationNodeImpl.extractChildVariables(groupingVariables, substitution);
        if (settings.isTestModeEnabled()) {
            this.validateNode();
        }
    }

    public static ImmutableSet<Variable> extractChildVariables(ImmutableSet<Variable> groupingVariables, ImmutableSubstitution<ImmutableFunctionalTerm> substitution) {
        return Sets.union(groupingVariables, (Set)((Set)substitution.getImmutableMap().values().stream().flatMap(ImmutableTerm::getVariableStream).collect(ImmutableCollectors.toSet()))).immutableCopy();
    }

    @Override
    public IQTree applyDescendingSubstitution(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Optional<ImmutableExpression> constraint, IQTree child) {
        return this.applyDescendingSubstitutionOrBlock(descendingSubstitution, s -> super.applyDescendingSubstitution((ImmutableSubstitution<? extends VariableOrGroundTerm>)s, constraint, child));
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, IQTree child) {
        return this.applyDescendingSubstitutionOrBlock(descendingSubstitution, s -> super.applyDescendingSubstitutionWithoutOptimizing((ImmutableSubstitution<? extends VariableOrGroundTerm>)s, child));
    }

    private IQTree applyDescendingSubstitutionOrBlock(ImmutableSubstitution<? extends VariableOrGroundTerm> descendingSubstitution, Function<ImmutableSubstitution<? extends VariableOrGroundTerm>, IQTree> applyNonBlockedSubstitutionFct) {
        ImmutableSet<Variable> aggregationVariables = this.substitution.getDomain();
        ImmutableSubstitution<GroundTerm> blockedSubstitutionToGroundTerm = descendingSubstitution.getFragment(GroundTerm.class).reduceDomainToIntersectionWith(aggregationVariables);
        ImmutableSubstitution<Variable> blockedVar2VarSubstitution = this.extractBlockedVar2VarSubstitutionMap(descendingSubstitution.getFragment(Variable.class), aggregationVariables);
        ImmutableSubstitution<? extends VariableOrGroundTerm> nonBlockedSubstitution = descendingSubstitution.reduceDomainToIntersectionWith((ImmutableSet<Variable>)Sets.difference(descendingSubstitution.getDomain(), (Set)Sets.union(blockedSubstitutionToGroundTerm.getDomain(), blockedVar2VarSubstitution.getDomain())).immutableCopy());
        IQTree newSubTree = applyNonBlockedSubstitutionFct.apply(nonBlockedSubstitution);
        if (blockedSubstitutionToGroundTerm.isEmpty() && blockedVar2VarSubstitution.isEmpty()) {
            return newSubTree;
        }
        ImmutableExpression condition = this.termFactory.getConjunction(Stream.concat(blockedSubstitutionToGroundTerm.getImmutableMap().entrySet().stream().map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0])), blockedVar2VarSubstitution.getImmutableMap().entrySet().stream().map(e -> this.termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)e.getValue(), new ImmutableTerm[0])))).orElseThrow(() -> new MinorOntopInternalBugException("Inconsistent with the previous check"));
        FilterNode filterNode = this.iqFactory.createFilterNode(condition);
        InjectiveVar2VarSubstitution renamingSubstitution = this.substitutionFactory.getInjectiveVar2VarSubstitution(filterNode.getLocalVariables().stream().collect(ImmutableCollectors.toMap(v -> v, v -> this.termFactory.getVariable("v" + UUID.randomUUID().toString()))));
        IQTree filterTree = this.iqFactory.createUnaryIQTree(filterNode, newSubTree).applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(this.constructionNodeTools.computeNewProjectedVariables(descendingSubstitution, this.getVariables())), filterTree);
    }

    private ImmutableSubstitution<Variable> extractBlockedVar2VarSubstitutionMap(ImmutableSubstitution<Variable> descendingVar2Var, ImmutableSet<Variable> aggregationVariables) {
        ImmutableMultimap<Variable, Variable> invertedMultimap = descendingVar2Var.getImmutableMap().entrySet().stream().collect(ImmutableCollectors.toMultimap(Map.Entry::getValue, Map.Entry::getKey));
        ImmutableSet blockedVariables = (ImmutableSet)invertedMultimap.asMap().entrySet().stream().flatMap(e -> this.extractBlockedDomainVars((Variable)e.getKey(), (Collection)e.getValue(), aggregationVariables)).collect(ImmutableCollectors.toSet());
        return descendingVar2Var.reduceDomainToIntersectionWith((ImmutableSet<Variable>)blockedVariables);
    }

    private Stream<Variable> extractBlockedDomainVars(Variable rangeVariable, Collection<Variable> domainVariables, ImmutableSet<Variable> aggregationVariables) {
        if (aggregationVariables.contains((Object)rangeVariable)) {
            return domainVariables.stream();
        }
        if (this.groupingVariables.contains((Object)rangeVariable)) {
            return domainVariables.stream().filter(arg_0 -> aggregationVariables.contains(arg_0));
        }
        Variable dominantVariable = domainVariables.stream().filter(arg_0 -> this.groupingVariables.contains(arg_0)).findAny().orElseGet(() -> (Variable)domainVariables.iterator().next());
        return domainVariables.stream().filter(v -> aggregationVariables.contains(v) && !dominantVariable.equals(v));
    }

    @Override
    protected Optional<ExtendedProjectionNode> computeNewProjectionNode(ImmutableSet<Variable> newProjectedVariables, ImmutableSubstitution<ImmutableTerm> theta, IQTree newChild) {
        return Optional.of(this.iqFactory.createAggregationNode((ImmutableSet<Variable>)Sets.difference(newProjectedVariables, theta.getDomain()).immutableCopy(), theta));
    }

    @Override
    public IQTree normalizeForOptimization(IQTree child, VariableGenerator variableGenerator, IQProperties currentIQProperties) {
        return this.aggregationNormalizer.normalizeForOptimization(this, child, variableGenerator, currentIQProperties);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveVar2VarSubstitution renamingSubstitution, IQTree child, IQTreeCache treeCache) {
        IQTree newChild = child.applyFreshRenaming(renamingSubstitution);
        ImmutableSet newGroupingVariables = (ImmutableSet)this.groupingVariables.stream().map(renamingSubstitution::applyToVariable).collect(ImmutableCollectors.toSet());
        AggregationNode newNode = this.iqFactory.createAggregationNode((ImmutableSet<Variable>)newGroupingVariables, renamingSubstitution.applyRenaming(this.substitution));
        IQTreeCache newTreeCache = treeCache.applyFreshRenaming(renamingSubstitution);
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newNode, newChild, newTreeCache);
    }

    @Override
    public boolean isDistinct(IQTree tree, IQTree child) {
        return true;
    }

    @Override
    public IQTree liftIncompatibleDefinitions(Variable variable, IQTree child, VariableGenerator variableGenerator) {
        return this.iqFactory.createUnaryIQTree(this, child);
    }

    @Override
    public IQTree acceptTransformer(IQTree tree, IQTreeVisitingTransformer transformer, IQTree child) {
        return transformer.transformAggregation(tree, this, child);
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor, IQTree child) {
        return visitor.visitAggregation(this, child);
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public AggregationNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public ImmutableSet<Variable> getLocalVariables() {
        return Sets.union(this.getChildVariables(), this.substitution.getDomain()).immutableCopy();
    }

    @Override
    public boolean isVariableNullable(IntermediateQuery query, Variable variable) {
        return true;
    }

    @Override
    public boolean isSyntacticallyEquivalentTo(QueryNode node) {
        return Optional.of(node).filter(n -> n instanceof AggregationNode).map(n -> (AggregationNode)n).filter(n -> n.getGroupingVariables().equals(this.groupingVariables)).filter(n -> n.getSubstitution().equals(this.substitution)).isPresent();
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return this.getChildVariables();
    }

    @Override
    public ImmutableSet<Variable> getRequiredVariables(IntermediateQuery query) {
        return this.getLocallyRequiredVariables();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return this.substitution.getDomain();
    }

    @Override
    public boolean isEquivalentTo(QueryNode queryNode) {
        return this.isSyntacticallyEquivalentTo(queryNode);
    }

    @Override
    public void validateNode(IQTree child) throws InvalidIntermediateQueryException {
        this.validateNode();
        Sets.SetView missingVariables = Sets.difference(this.getLocallyRequiredVariables(), child.getVariables());
        if (!missingVariables.isEmpty()) {
            throw new InvalidIntermediateQueryException("The child of the aggregation node is missing some variables: " + missingVariables);
        }
    }

    protected void validateNode() throws InvalidIntermediateQueryException {
        if (!Sets.intersection(this.groupingVariables, this.substitution.getDomain()).isEmpty()) {
            throw new InvalidIntermediateQueryException(String.format("AggregationNode: the grouping variables (%s) and the substitution domain (%s) must be disjoint", this.groupingVariables, this.substitution.getDomain()));
        }
        ImmutableMap nonAggregateMap = this.substitution.getImmutableMap().entrySet().stream().filter(e -> !((ImmutableFunctionalTerm)e.getValue()).getFunctionSymbol().isAggregation()).collect(ImmutableCollectors.toMap());
        if (!nonAggregateMap.isEmpty()) {
            throw new InvalidIntermediateQueryException("The substitution of the aggregation node should only define aggregates, not " + nonAggregateMap);
        }
    }

    @Override
    public ImmutableSet<ImmutableSubstitution<NonVariableTerm>> getPossibleVariableDefinitions(IQTree child) {
        ImmutableSet groupingVariableDefs = (ImmutableSet)child.getPossibleVariableDefinitions().stream().map(s -> s.reduceDomainToIntersectionWith(this.groupingVariables)).collect(ImmutableCollectors.toSet());
        ImmutableSubstitution<NonVariableTerm> def = this.substitution.getFragment(NonVariableTerm.class);
        if (groupingVariableDefs.isEmpty()) {
            return def.isEmpty() ? ImmutableSet.of() : ImmutableSet.of(def);
        }
        return (ImmutableSet)groupingVariableDefs.stream().map(childDef -> childDef.union(def).get()).collect(ImmutableCollectors.toSet());
    }

    @Override
    public IQTree removeDistincts(IQTree child, IQProperties iqProperties) {
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this, child, iqProperties.declareDistinctRemovalWithoutEffect());
    }

    @Override
    public ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints(IQTree child) {
        return this.groupingVariables.isEmpty() ? ImmutableSet.of(this.getVariables()) : (ImmutableSet)Stream.concat(child.inferUniqueConstraints().stream().filter(arg_0 -> this.groupingVariables.containsAll(arg_0)), Stream.of(this.getGroupingVariables())).collect(ImmutableCollectors.toSet());
    }

    @Override
    public ImmutableSet<Variable> computeNotInternallyRequiredVariables(IQTree child) {
        return this.substitution.getImmutableMap().keySet();
    }

    @Override
    public ImmutableSubstitution<ImmutableFunctionalTerm> getSubstitution() {
        return this.substitution;
    }

    @Override
    public ImmutableSet<Variable> getGroupingVariables() {
        return this.groupingVariables;
    }

    @Override
    public ImmutableSet<Variable> getChildVariables() {
        return this.childVariables;
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.projectedVariables;
    }

    @Override
    public AggregationNode clone() {
        return this.iqFactory.createAggregationNode(this.groupingVariables, this.substitution);
    }

    public String toString() {
        return "AGGREGATE " + this.groupingVariables + " [" + this.substitution + "]";
    }
}

