/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.evaluator.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.cache.Cache;
import it.unibz.inf.ontop.com.google.common.cache.CacheBuilder;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.evaluator.TermNullabilityEvaluator;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;

@Singleton
public class TermNullabilityEvaluatorImpl
implements TermNullabilityEvaluator {
    private static final long TERM_EVALUATOR_CACHE_SIZE = 10000L;
    private final SubstitutionFactory substitutionFactory;
    private final Constant valueNull;
    private final CoreUtilsFactory coreUtilsFactory;
    private final Cache<Map.Entry<ImmutableExpression, ImmutableSet<Variable>>, Boolean> cache;

    @Inject
    private TermNullabilityEvaluatorImpl(SubstitutionFactory substitutionFactory, TermFactory termFactory, CoreUtilsFactory coreUtilsFactory) {
        this.substitutionFactory = substitutionFactory;
        this.valueNull = termFactory.getNullConstant();
        this.coreUtilsFactory = coreUtilsFactory;
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).build();
    }

    @Override
    public boolean isFilteringNullValue(ImmutableExpression expression, Variable variable) {
        ImmutableExpression nullCaseExpression = this.substitutionFactory.getSubstitution(variable, this.valueNull).applyToBooleanExpression(expression);
        return nullCaseExpression.evaluate2VL(this.coreUtilsFactory.createSimplifiedVariableNullability(expression)).isEffectiveFalse();
    }

    @Override
    public boolean isFilteringNullValues(ImmutableExpression expression, ImmutableSet<Variable> tightVariables) {
        Map.Entry entry = Maps.immutableEntry((Object)expression, tightVariables);
        Boolean cacheResult = (Boolean)this.cache.getIfPresent((Object)entry);
        if (cacheResult != null) {
            return cacheResult;
        }
        ImmutableExpression nullCaseExpression = this.substitutionFactory.getSubstitution(tightVariables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> this.valueNull))).applyToBooleanExpression(expression);
        boolean result = nullCaseExpression.evaluate2VL(this.coreUtilsFactory.createSimplifiedVariableNullability(expression)).isEffectiveFalse();
        this.cache.put((Object)entry, (Object)result);
        return result;
    }
}

