/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SQLStandardQuotedIDFactory
implements QuotedIDFactory {
    public static final String QUOTATION_STRING = "\"";
    public static final String NO_QUOTATION = "";

    @Override
    public QuotedID createAttributeID(@Nonnull String s) {
        Objects.requireNonNull(s);
        return this.createFromString(s);
    }

    @Override
    public RelationID createRelationID(@Nonnull String tableId) {
        return new RelationIDImpl((ImmutableList<QuotedID>)ImmutableList.of((Object)this.createFromString(tableId)));
    }

    @Override
    public RelationID createRelationID(String ... components) {
        Objects.requireNonNull(components[components.length - 1]);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = components.length - 1; i >= 0; --i) {
            if (components[i] == null) continue;
            builder.add((Object)this.createFromString(components[i]));
        }
        return new RelationIDImpl((ImmutableList<QuotedID>)builder.build());
    }

    protected QuotedID createFromString(@Nonnull String s) {
        Objects.requireNonNull(s);
        if (s.startsWith(QUOTATION_STRING) && s.endsWith(QUOTATION_STRING)) {
            return new QuotedIDImpl(s.substring(1, s.length() - 1), QUOTATION_STRING);
        }
        return new QuotedIDImpl(s.toUpperCase(), NO_QUOTATION);
    }

    @Override
    public String getIDQuotationString() {
        return QUOTATION_STRING;
    }
}

